/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.botp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.JacksonJsonUtil;

public class SouInquiryToQuotePlugin
extends AbstractConvertPlugIn {
    private static Log log = LogFactory.getLog(SouInquiryToQuotePlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        Long contacterId = null;
        long orgId = 0L;
        long currUserId = RequestContext.get().getCurrUserId();
        OperateOption option = this.getOption();
        Map autoBillNoMap = new HashMap();
        String appId = null;
        if (option.getVariables().containsKey("quote_source")) {
            appId = option.getVariableValue("quote_source");
        }
        if (option.containsVariable("autoBillNoMap")) {
            String autoBillNoMapStr = option.getVariableValue("autoBillNoMap");
            try {
                autoBillNoMap = (Map)JacksonJsonUtil.fromJSON((String)autoBillNoMapStr, Map.class);
            }
            catch (IOException ioe) {
                log.error("autoFillNos json Exception\uff1a" + ioe.getMessage());
            }
        }
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        String srcEntityKey = this.getSrcMainType().toString();
        String tgtEntityKey = this.getTgtMainType().toString();
        boolean flag = srcEntityKey.equals("sou_inquiry") && tgtEntityKey.equals("sou_quote");
        List<Object> bills = new ArrayList<DynamicObject>(16);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            if (flag && StringUtils.isBlank((CharSequence)bill.getString("billno"))) {
                String readNumber = CodeRuleServiceHelper.getNumber((String)"quo_quote", (DynamicObject)bill, (String)bill.getString("org.id"));
                bill.set("billno", (Object)readNumber);
            }
            orgId = bill.getLong("org.id");
            if (flag) {
                bill.set("bizstatus", null);
            }
            bills.add(bill);
        }
        if (!"sou".equals(appId)) {
            QFilter statusFilter;
            QFilter enableFilter;
            QFilter userFilter = new QFilter("user", "=", (Object)currUserId);
            DynamicObjectCollection personDyns = QueryServiceHelper.query((String)"scp_bizperson", (String)"id,user,org.id", (QFilter[])new QFilter[]{userFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")}, (String)"id");
            if (personDyns != null && !personDyns.isEmpty()) {
                for (DynamicObject personDyn : personDyns) {
                    if (personDyn.getLong("org.id") != orgId) continue;
                    contacterId = personDyn.getLong("id");
                }
            }
            if (bills.size() == 0) {
                return;
            }
            DynamicObject quoteBill = (DynamicObject)bills.get(0);
            List supIdList = BizPartnerUtil.getSupplierByUserAndOrgOfBizPartner((Long)quoteBill.getLong("org.id"));
            String inquiryno = quoteBill.getString("inquiryno");
            this.removeSups(inquiryno, supIdList);
            Map supMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)supIdList)});
            for (DynamicObject bill : bills) {
                long contacter = bill.getLong("contacter_id");
                long supplier = bill.getLong("supplier_id");
                long bizpartner = bill.getLong("bizpartner_id");
                bill.set("contacter_id", (Object)contacterId);
                if (supIdList == null || supIdList.size() < 1 || contacter != 0L || supplier != 0L || bizpartner != 0L) continue;
                bill.set("supplier", supMap.get(supIdList.get(0)));
                bill.set("bizpartner_id", (Object)BizPartnerUtil.getBizPartnerBySupplier(supIdList.get(0)));
                BillPushAssistUtil.processTurnsCountInfo((String)"sou_inquiry", (DynamicObject[])new DynamicObject[]{bill}, (String)bill.getString("inquiryno"), (List)supIdList);
            }
            bills = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoteAutoFillService", (String)"autoFillLastPriceMap", (Object[])new Object[]{bills, autoBillNoMap});
        } else {
            for (DynamicObject bill : bills) {
                bill.set("origin", (Object)"2");
            }
        }
        if (bills != null && bills.size() > 0) {
            e.getTargetExtDataEntitySet().Parse(bills.toArray(new DynamicObject[0]), (MainEntityType)this.getTgtMainType());
        }
    }

    private void removeSups(String inquiryNo, List<Long> supIdList) {
        QFilter filter = new QFilter("billno", "=", (Object)inquiryNo);
        DynamicObject inquiryBill = BusinessDataServiceHelper.loadSingle((String)"sou_inquiry", (String)"supscope,turns,entryentity.supplier,entryentity.entryturns", (QFilter[])filter.toArray());
        String supscope = inquiryBill.getString("supscope");
        if (supscope == null || supscope.isEmpty() || !"2".equals(supscope)) {
            return;
        }
        String turns = inquiryBill.getString("turns");
        ArrayList<Long> inscopeSups = new ArrayList<Long>();
        DynamicObjectCollection entryentity = inquiryBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            if (!turns.equals(entry.getString("entryturns"))) continue;
            inscopeSups.add(entry.getLong("supplier.id"));
        }
        if (!inscopeSups.isEmpty()) {
            supIdList.removeIf(n -> !inscopeSups.contains(n));
        }
    }
}

