/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.util.CommonUtil;

public class SouToPurOrderConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(SouToPurOrderConvertPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        if (e.getSelectedRows().isEmpty()) {
            return;
        }
        List selectedRows = e.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            Long souComparePkId = (Long)selectedRow.getPrimaryKeyValue();
            QFilter qFilter1 = new QFilter("id", "=", (Object)souComparePkId);
            DynamicObject souCompareDyn = QueryServiceHelper.queryOne((String)"sou_compare", (String)"id,inquiryno", (QFilter[])new QFilter[]{qFilter1});
            if (souCompareDyn == null || StringUtils.isEmpty((CharSequence)souCompareDyn.getString("inquiryno"))) continue;
            String inquiryNo = souCompareDyn.getString("inquiryno");
            QFilter qFilter2 = new QFilter("billno", "=", (Object)inquiryNo);
            qFilter2.and(new QFilter("bizstatus", "=", (Object)BizStatusEnum.END.getVal()));
            DynamicObject souInquiryDyn = QueryServiceHelper.queryOne((String)"sou_inquiry", (String)"id", (QFilter[])new QFilter[]{qFilter2});
            if (souInquiryDyn == null) continue;
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u7ecf\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"SouToPurOrderConvertPlugin_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            e.setCustFilterExpression("false");
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        List bills = new ArrayList<DynamicObject>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            this.dealBaseQty(bill);
            bills.add(bill);
        }
        if ((bills = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"batchSetPODefValue", (Object[])new Object[]{bills})) != null && bills.size() > 0) {
            e.getTargetExtDataEntitySet().Parse(bills.toArray(new DynamicObject[0]), (MainEntityType)this.getTgtMainType());
        }
    }

    private void dealBaseQty(DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            BigDecimal qty = entry.getBigDecimal("qty");
            DynamicObject material = entry.getDynamicObject("material.masterid");
            DynamicObject unit = entry.getDynamicObject("unit");
            if (material == null) continue;
            DynamicObject baseUnit = material.getDynamicObject("baseunit");
            DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
            BigDecimal baseqty = entry.getBigDecimal("baseqty");
            entry.set("baseunit", (Object)baseUnit);
            entry.set("auxunit", (Object)auxptyUnit);
            if (qty == null || unit == null || baseUnit == null) continue;
            BigDecimal baseQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
            if (auxptyUnit == null) continue;
            BigDecimal auxQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxptyUnit);
            entry.set("auxqty", (Object)auxQty);
        }
    }
}

