/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.upgrade;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.scm.common.util.FeatureCheckUtil;

public class SouScheduleUpgradePlugin
implements IUpgradeService {
    private static final String[] checktables = new String[]{" T_PUR_INQUIRY ", " T_PUR_QUOTE ", " T_PUR_BIDBILL ", " T_PUR_COMPARE "};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean isnew = true;
        for (String table : checktables) {
            if (!this.existsdata(table)) continue;
            isnew = false;
            break;
        }
        Set licenseModules = LicenseServiceHelper.getLicenseModules();
        Map checkRes = FeatureCheckUtil.checkQuoFeature();
        if (!CollectionUtils.isEmpty((Collection)licenseModules) && (licenseModules.contains("SOU") || licenseModules.contains("sou") || ((Boolean)checkRes.get("hasLicense")).booleanValue())) {
            isnew = false;
        }
        if (isnew) {
            this.update();
        }
        result.setSuccess(true);
        return result;
    }

    private void update() {
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_SCH_SCHEDULE set fstatus = '0' where FNUMBER in ('sou_soubidautoopen_SKDP_S','sou_SouBidBillAutoConfirm_SKDP_S','sou_souinqueryautoopen_SKDP_S')");
        DBRoute dbRoute = new DBRoute("sys");
        DB.execute((DBRoute)dbRoute, (String)sql.toString());
    }

    private boolean existsdata(String tablename) {
        DBRoute dbRoute = new DBRoute("pur");
        String sql = "SELECT 1 FROM  " + tablename;
        try (DataSet ds = DB.queryDataSet((String)"SouScheduleUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql);){
            Iterator it = ds.iterator();
            if (it.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

