/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;

public class SouBidStartValidator
extends AbstractValidator {
    public String getEntityKey() {
        return this.entityKey;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.entityKey = "sou_bidbill";
    }

    public void initialize() {
        super.initialize();
    }

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject model = rowDataEntity.getDataEntity();
            String bidStatus = model.getString("bidstatus");
            int bidNum = model.getInt("bidnumber");
            String checktype = model.getString("checktype");
            Date opendate = model.getDate("opendate");
            DynamicObjectCollection col = model.getDynamicObjectCollection("supquoentry");
            if (col == null || col.size() <= 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u4f9b\u5e94\u5546\u62a5\u540d\uff0c\u4e0d\u5141\u8bb8\u542f\u52a8\u7ade\u4ef7\u3002", (String)"SouBidStartValidator_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (bidStatus != null && bidStatus.equals(BidStatusEnum.END.getVal())) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u65e0\u6cd5\u5f00\u59cb\u7ade\u4ef7\u542f\u52a8\u3002", (String)"SouBidStartValidator_1", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (bidStatus != null && (bidStatus.equals(BidStatusEnum.CONFIRMED.getVal()) || bidStatus.equals(BidStatusEnum.EXECUTED.getVal()))) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u542f\u52a8\u7ade\u4ef7\u3002", (String)"SouBidStartValidator_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (bidStatus != null && bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5728\u7ade\u4ef7\u4e2d\u3002", (String)"SouBidStartValidator_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (bidStatus != null && bidStatus.equals(BidStatusEnum.EVALUATING.getVal())) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u6b63\u5728\u8bc4\u6807\u4e2d\uff0c\u4e0d\u80fd\u542f\u52a8\u7ade\u4ef7\u3002", (String)"SouBidStartValidator_4", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (bidStatus != null && bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
                if ("3".equals(checktype) || !bidStatus.equals(BidStatusEnum.BEENEXAMINED.getVal())) continue;
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u672a\u8d44\u5ba1\u3002", (String)"SouBidStartValidator_5", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (opendate.after(TimeServiceHelper.now())) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u5f00\u542f\u7ade\u4ef7\u3002", (String)"SouBidStartValidator_6", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (col.size() < bidNum) {
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u5c11\u4e8e{0}\u5bb6\u3002", (String)"SouBidStartValidator_7", (String)"scm-sou-opplugin", (Object[])new Object[0]), bidNum));
                continue;
            }
            StringBuffer strBuffer = new StringBuffer();
            int supplierCount = this.countEnrollSuppler(strBuffer, model);
            if (supplierCount >= bidNum) continue;
            if (strBuffer.length() == 0) {
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u5c11\u4e8e{0}\u5bb6\u3002", (String)"SouBidStartValidator_7", (String)"scm-sou-opplugin", (Object[])new Object[0]), bidNum));
                continue;
            }
            String[] arrStr = strBuffer.toString().split("\n");
            for (int i = 0; i < arrStr.length; ++i) {
                this.addErrorMessage(rowDataEntity, arrStr[i]);
            }
        }
    }

    private int countEnrollSuppler(StringBuffer strBuffer, DynamicObject bidObj) {
        int supplierCount = 0;
        String supentrystatus = "";
        Date suppaydate = null;
        DynamicObjectCollection supquoentryCol = bidObj.getDynamicObjectCollection("supquoentry");
        String checktype = bidObj.getString("checktype");
        BigDecimal cashdeposit = bidObj.getBigDecimal("cashdeposit");
        String supplierName = "";
        for (DynamicObject dynamicObject : supquoentryCol) {
            supentrystatus = dynamicObject.getString("supentrystatus");
            suppaydate = dynamicObject.getDate("suppaydate");
            DynamicObject entrysupplier = dynamicObject.getDynamicObject("entrysupplier");
            if (entrysupplier == null) continue;
            supplierName = entrysupplier.getString("name");
            if (null == supentrystatus || "".equals(supentrystatus)) continue;
            if ("1".equals(checktype)) {
                if (cashdeposit.compareTo(BigDecimal.ZERO) == 0) {
                    if (SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) {
                        ++supplierCount;
                        continue;
                    }
                    if (SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) {
                        strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u8d44\u5ba1\u672a\u901a\u8fc7\u3002", (String)"SouBidStartValidator_8", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                        continue;
                    }
                    strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u672a\u8d44\u5ba1\u3002", (String)"SouBidStartValidator_9", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                    continue;
                }
                if (SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus)) {
                    ++supplierCount;
                    continue;
                }
                if (SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) {
                    strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u672a\u4ea4\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidStartValidator_10", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                    continue;
                }
                if (SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) {
                    strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u8d44\u5ba1\u672a\u901a\u8fc7\u3002", (String)"SouBidStartValidator_8", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                    continue;
                }
                strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u672a\u8d44\u5ba1\u3002", (String)"SouBidStartValidator_9", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                continue;
            }
            if (cashdeposit.compareTo(BigDecimal.ZERO) == 0) {
                if ("3".equals(checktype)) {
                    if (SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) {
                        ++supplierCount;
                        continue;
                    }
                    strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u672a\u62a5\u540d\u3002", (String)"SouBidStartValidator_11", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                    continue;
                }
                if (SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus) || SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) {
                    ++supplierCount;
                    continue;
                }
                if (!SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) continue;
                strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u8d44\u5ba1\u672a\u901a\u8fc7\u3002", (String)"SouBidStartValidator_8", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                continue;
            }
            if ("3".equals(checktype)) {
                if (SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus)) {
                    ++supplierCount;
                    continue;
                }
                if (!SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus) && !SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) continue;
                strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u672a\u4ea4\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidStartValidator_10", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                continue;
            }
            if (SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus) || SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus) && suppaydate != null) {
                ++supplierCount;
                continue;
            }
            if (SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus) || SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus) && suppaydate == null) {
                strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u672a\u4ea4\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidStartValidator_10", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
                continue;
            }
            if (!SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) continue;
            strBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\uff08{0}\uff09\u8d44\u5ba1\u672a\u901a\u8fc7\u3002", (String)"SouBidStartValidator_8", (String)"scm-sou-opplugin", (Object[])new Object[0]), supplierName)).append('\n');
        }
        return supplierCount;
    }
}

