/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.sou.common.SouCommonUtil;

public class SouCompareValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<String> inquirynos = new ArrayList<String>();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (this.getOperateKey().equals("unaudit")) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                DynamicObjectCollection materialCol = dynamicObject.getDynamicObjectCollection("materialentry");
                boolean flag = false;
                for (DynamicObject entry : materialCol) {
                    boolean isupdateasinfo = entry.getBoolean("isupdateasinfo");
                    if (!isupdateasinfo) continue;
                    flag = isupdateasinfo;
                    break;
                }
                if (flag) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4f9b\u8d27\u6e05\u5355\uff0c\u4e0d\u5141\u8bb8%1$s", (String)"SouCompareValidator_2", (String)"scm-sou-opplugin", (Object[])new Object[0]), this.getOperationName()));
                }
                Object pkId = dataEntity.getValue("id");
                Object[] objects = new Object[]{pkId};
                if (!SouCommonUtil.existBelowOrders((Object[])objects, (String)"sou_compare")) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8%1$s", (String)"SouCompareValidator_3", (String)"scm-sou-opplugin", (Object[])new Object[0]), this.getOperationName()));
            }
        }
        for (ExtendedDataEntity rowDataEntity : dataEntities) {
            DynamicObject compareBillObject = rowDataEntity.getDataEntity();
            String inquiryno = compareBillObject.getString("inquiryno");
            if (!StringUtils.isNotBlank((CharSequence)inquiryno)) continue;
            inquirynos.add(inquiryno);
        }
        HashSet inquirySet = new HashSet(inquirynos.size());
        if (inquirynos.size() > 0) {
            QFilter qFilter = new QFilter("billno", "in", inquirynos);
            qFilter.and("bizstatus", "=", (Object)BizStatusEnum.END.getVal());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"sou_inquiry", (String)"billno", (QFilter[])new QFilter[]{qFilter}, null);){
                dataSet.forEach(row -> inquirySet.add(row.getString("billno")));
            }
        }
        for (ExtendedDataEntity rowDataEntity : dataEntities) {
            DynamicObject compareBillObject = rowDataEntity.getDataEntity();
            String inquiryno = compareBillObject.getString("inquiryno");
            if (!inquirySet.contains(inquiryno)) continue;
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u7ecf\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8%1$s", (String)"SouCompareValidator_1", (String)"scm-sou-opplugin", (Object[])new Object[0]), this.getOperationName()));
        }
    }
}

