/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SouSubmitCfmqtyValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("controlqty");
        preparePropertys.add("materialentry.qty");
        preparePropertys.add("materialentry.srcentryid");
        preparePropertys.add("materialentry.id");
        preparePropertys.add("materialentry.seq");
        return preparePropertys;
    }

    public void validate() {
        ArrayList<Long> srcentryidList = new ArrayList<Long>();
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : materialentry) {
                String srcentryid = entry.getString("srcentryid");
                if (StringUtils.isEmpty((CharSequence)srcentryid)) continue;
                srcentryidList.add(Long.parseLong(srcentryid));
            }
        }
        QFilter filter = new QFilter("materialentry.id", "in", srcentryidList);
        DynamicObjectCollection quoteinfo = QueryServiceHelper.query((String)"sou_quote", (String)"materialentry.id entryid, materialentry.srcentryid srcentryid", (QFilter[])filter.toArray());
        if (quoteinfo == null || quoteinfo.isEmpty()) {
            return;
        }
        HashMap<String, String> idSrcIdMap = new HashMap<String, String>();
        for (DynamicObject quote : quoteinfo) {
            idSrcIdMap.put(quote.getString("entryid"), quote.getString("srcentryid"));
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String controlqty = dynamicObject.getString("controlqty");
            if ("1".equals(controlqty)) continue;
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            HashMap<String, BigDecimal> inquiryqtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> cfmqtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, List<String>> linenumberMap = new HashMap<String, List<String>>();
            for (DynamicObject compareEntry : materialentry) {
                String srcentryid = compareEntry.getString("srcentryid");
                String quoteSrcentryid = (String)idSrcIdMap.get(srcentryid);
                if (StringUtils.isEmpty((CharSequence)srcentryid) || StringUtils.isEmpty((CharSequence)quoteSrcentryid)) continue;
                String materialNo = compareEntry.getDynamicObject("material").getString("number");
                String key = materialNo + "_" + quoteSrcentryid;
                inquiryqtyMap.put(key, compareEntry.getBigDecimal("inquiryqty"));
                List<String> linenumberList = linenumberMap.get(key);
                if (linenumberList == null) {
                    linenumberList = new ArrayList<String>();
                    linenumberList.add(compareEntry.getString("seq"));
                    linenumberMap.put(key, linenumberList);
                } else {
                    linenumberList.add(compareEntry.getString("seq"));
                }
                BigDecimal cfmqty = cfmqtyMap.get(key);
                if (cfmqty == null || cfmqty.compareTo(BigDecimal.ZERO) == 0) {
                    cfmqtyMap.put(key, compareEntry.getBigDecimal("qty"));
                    continue;
                }
                cfmqtyMap.put(key, cfmqty.add(compareEntry.getBigDecimal("qty")));
            }
            StringBuilder stringBuilder = this.getMessage(inquiryqtyMap, cfmqtyMap, linenumberMap);
            if (stringBuilder.length() == 0) continue;
            String message = String.format(ResManager.loadKDString((String)"%s\u7684\u786e\u8ba4\u6570\u91cf\u4e4b\u548c\u4e0d\u80fd\u8d85\u8fc7\u8be2\u4ef7\u6570\u91cf\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SouCompareBillEdit_13", (String)"scm-sou-formplugin", (Object[])new Object[0]), stringBuilder.toString());
            this.addErrorMessage(dataEntity, message);
        }
    }

    private StringBuilder getMessage(HashMap<String, BigDecimal> inquiryqtyMap, HashMap<String, BigDecimal> cfmqtyMap, HashMap<String, List<String>> linenumberMap) {
        Set<Map.Entry<String, BigDecimal>> entrySet = inquiryqtyMap.entrySet();
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, BigDecimal> entry : entrySet) {
            String key = entry.getKey();
            BigDecimal inquiryQty = entry.getValue();
            if (cfmqtyMap.get(key) == null || inquiryQty.compareTo(cfmqtyMap.get(key)) >= 0) continue;
            List<String> lines = linenumberMap.get(key);
            String[] splitKey = key.split("_");
            if (stringBuilder.length() == 0) {
                stringBuilder.append(String.format(ResManager.loadKDString((String)"\u62a5\u4ef7\u8be6\u60c5\u5206\u5f55\u7b2c%s\u884c\u7269\u6599", (String)"SouCompareBillEdit_12", (String)"scm-sou-formplugin", (Object[])new Object[0]), lines)).append(splitKey[0]);
                continue;
            }
            stringBuilder.append(";").append(String.format(ResManager.loadKDString((String)"\u62a5\u4ef7\u8be6\u60c5\u5206\u5f55\u7b2c%s\u884c\u7269\u6599", (String)"SouCompareBillEdit_12", (String)"scm-sou-formplugin", (Object[])new Object[0]), lines)).append(splitKey[0]);
        }
        return stringBuilder;
    }
}

