/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.sou.service.ISouPmOrdersWraper;

public class SouPmOrdersWraper
implements ISouPmOrdersWraper {
    public List<DynamicObject> wrapPmOrdersBill(List<DynamicObject> orders, Map<String, String> paramMap) {
        if (paramMap != null) {
            Collection values;
            String data = paramMap.get("data");
            String formId = paramMap.get("formId");
            String idProperty = "materialentry.id";
            if ("sou_bidbillcfm".equals(formId)) {
                idProperty = "entryentity.id";
            }
            HashMap<String, DynamicObject> storeMap = new HashMap<String, DynamicObject>();
            Map infosMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            if (infosMap != null && infosMap.size() > 0 && !(values = infosMap.values()).isEmpty()) {
                QFilter qFilter = new QFilter(idProperty, "in", values);
                DynamicObjectCollection compareColls = QueryServiceHelper.query((String)formId, (String)this.getSelects(formId), (QFilter[])new QFilter[]{qFilter}, null);
                for (DynamicObject compareColl : compareColls) {
                    storeMap.put(compareColl.getString("materialentry.prentryid"), compareColl);
                }
            }
            HashMap<Long, DynamicObject> baseInfoMap = new HashMap<Long, DynamicObject>(orders.size());
            for (DynamicObject order : orders) {
                DynamicObjectCollection billentry = order.getDynamicObjectCollection("billentry");
                for (DynamicObject dynamicObject : billentry) {
                    DynamicObject info = (DynamicObject)storeMap.get(dynamicObject.getString("srcbillentryid"));
                    if (info == null) continue;
                    DynamicObject person = this.storeBaseData(baseInfoMap, info.getLong("person.person"), "bd_operator");
                    order.set("operator", (Object)person);
                    DynamicObject group = this.storeBaseData(baseInfoMap, info.getLong("person.group"), "bd_operatorgroup");
                    order.set("operatorgroup", (Object)group);
                    DynamicObject settletype = this.storeBaseData(baseInfoMap, info.getLong("settletype"), "bd_settlementtype");
                    order.set("settletype", (Object)settletype);
                    DynamicObject paycond = this.storeBaseData(baseInfoMap, info.getLong("paycond"), "bd_paycondition");
                    order.set("paycondition", (Object)paycond);
                    DynamicObject supplier = this.storeBaseData(baseInfoMap, info.getLong("materialentry.supplier"), "bd_supplier");
                    order.set("supplier", (Object)supplier);
                    DynamicObject quoteCurr = this.storeBaseData(baseInfoMap, info.getLong("materialentry.quotecurr"), "bd_currency");
                    order.set("settlecurrency", (Object)quoteCurr);
                    DynamicObject taxrateid = this.storeBaseData(baseInfoMap, info.getLong("materialentry.taxrateid"), "bd_taxrate");
                    dynamicObject.set("taxrateid", (Object)taxrateid);
                    order.set("exchangerate", (Object)info.getBigDecimal("materialentry.exrate"));
                    order.set("exchangetype", (Object)info.getBigDecimal("materialentry.entryquotation"));
                    DynamicObject curr = this.storeBaseData(baseInfoMap, info.getLong("curr"), "bd_currency");
                    order.set("currency", (Object)curr);
                    dynamicObject.set("qty", null);
                    dynamicObject.set("receiveqtyup", null);
                    dynamicObject.set("receiveqtydown", null);
                    dynamicObject.set("receivebaseqtyup", null);
                    dynamicObject.set("receivebaseqtydown", null);
                    dynamicObject.set("price", (Object)info.getBigDecimal("materialentry.price"));
                    dynamicObject.set("priceandtax", (Object)info.getBigDecimal("materialentry.taxprice"));
                    BigDecimal baseQty = this.getDesQtyConv(info.getLong("materialentry.material"), info.getLong("materialentry.unit"), info.getBigDecimal("materialentry.qty"), info.getLong("materialentry.material.baseunit"));
                    dynamicObject.set("baseqty", (Object)baseQty);
                    dynamicObject.set("taxrate", (Object)info.getBigDecimal("materialentry.taxrate"));
                    BigDecimal dctrate = info.getBigDecimal("materialentry.dctrate");
                    String taxtype = info.getString("taxtype");
                    if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxtype)) {
                        order.set("istax", (Object)Boolean.FALSE);
                    } else {
                        order.set("istax", (Object)Boolean.TRUE);
                    }
                    dynamicObject.set("discountrate", (Object)dctrate);
                    if (dctrate != null && BigDecimal.ZERO.compareTo(dctrate) < 0) {
                        dynamicObject.set("discounttype", (Object)"A");
                    } else {
                        dynamicObject.set("discounttype", (Object)"NULL");
                    }
                    dynamicObject.set("deliveraddress", (Object)info.getString("materialentry.entrydeliaddr"));
                    dynamicObject.set("soubillentity", (Object)"sou_compare");
                    dynamicObject.set("soubillid", (Object)info.getLong("id"));
                    dynamicObject.set("soubillentryid", (Object)info.getLong("materialentry.id"));
                    dynamicObject.set("soubillnumber", (Object)info.getString("billno"));
                    dynamicObject.set("soubillentryseq", (Object)info.getLong("materialentry.seq"));
                }
            }
        }
        return orders;
    }

    protected DynamicObject storeBaseData(Map<Long, DynamicObject> baseInfoMap, Long pk, String baseFormId) {
        DynamicObject baseData = baseInfoMap.get(pk);
        if (baseData == null) {
            baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)baseFormId);
            baseInfoMap.put(pk, baseData);
        }
        return baseData;
    }

    protected String getSelects(String formId) {
        StringBuilder sb = new StringBuilder();
        if ("sou_compare".equals(formId)) {
            sb.append("id,taxtype,billno,person.person").append(",person.group,businesstype,settletype,curr,materialentry.material,materialentry.material.baseunit,materialentry.unit").append(",paycond,materialentry.qty,materialentry.id,materialentry.entrypurorg").append(",materialentry.prbillid,materialentry.prentryid,materialentry.price,materialentry.taxprice").append(",materialentry.taxrateid,materialentry.taxrate,materialentry.dctrate").append(",materialentry.supplier,materialentry.quotecurr,materialentry.entrydeliaddr").append(",materialentry.seq,materialentry.exrate,materialentry.entryquotation");
        }
        return sb.toString();
    }

    private BigDecimal getDesQtyConv(Long materialId, Long srcUnit, BigDecimal srcQty, Long desUnit) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null) {
            if (srcUnit.equals(desUnit)) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
                if (muConv != null) {
                    int numerator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        DynamicObject desUnitObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)desUnit)});
                        int unitPrecisionType = 4;
                        if (desUnitObj != null) {
                            int unitPrecision = desUnitObj.getInt("precision");
                            int account = desUnitObj.getInt("precisionaccount");
                            if (account == 2) {
                                unitPrecisionType = 1;
                            } else if (account == 3) {
                                unitPrecisionType = 0;
                            }
                            desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                        }
                    }
                }
            }
        } else {
            desQty = BigDecimal.ZERO;
        }
        return desQty;
    }
}

