/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.sou.common.SouBidCfmBillUtil;
import kd.scm.sou.common.SouCompareBillUtil;
import kd.scm.sou.service.ISouToEasService;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;

public class SouToEasServiceImp
implements ISouToEasService {
    private static final Log log = LogFactory.getLog(SouToEasServiceImp.class);

    public Object toContractInfo(String serviceCode, Map<String, Object> verifyInfo, Object ... paras) {
        ArrayList<Object> inputs = new ArrayList<Object>(paras.length);
        for (Object para : paras) {
            inputs.add(para);
        }
        if ("true".equals(verifyInfo.get("succed"))) {
            if (!"".equals(verifyInfo.get("botp"))) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("rules", (List)verifyInfo.get("botp"));
                param.put("tobilltype", "contract");
                param.put("pkstr", paras[0]);
                return param;
            }
            try {
                if (inputs.size() == 1) {
                    inputs.add("");
                }
                Long instanceId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{serviceCode, inputs});
                return instanceId;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public Map<String, Object> verifyEASBill(DynamicObject[] dynamicObjects, String billname, String entryKey, String targetBillType, String tartetBillName) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        StringBuilder msgSb = new StringBuilder();
        StringBuilder billNoCheck = new StringBuilder();
        List<DynamicObject> collect = Arrays.stream(dynamicObjects).collect(Collectors.toList());
        Iterator iterator = collect.iterator();
        while (iterator.hasNext()) {
            DynamicObject bill = (DynamicObject)iterator.next();
            String billNo = bill.getString("billno");
            DynamicObjectCollection entrs = bill.getDynamicObjectCollection(entryKey);
            StringBuilder EASOrderCheck = new StringBuilder();
            int size = entrs.size();
            int i = 0;
            for (DynamicObject entry : entrs) {
                String poBillno = entry.getString("pcbillno");
                if (poBillno == null || poBillno.trim().length() <= 0) continue;
                ++i;
                if (EASOrderCheck.toString().contains(poBillno)) continue;
                EASOrderCheck.append(poBillno).append('\u3001');
            }
            if (i != size) continue;
            billNoCheck.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\uff0c\u5df2\u7ecf\u751f\u6210%3$s\uff1a%4$s\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210", (String)"SouToEasServiceImp_0", (String)"scm-sou-mservice", (Object[])new Object[0]), bill.getDynamicObjectType().getDisplayName().getLocaleValue(), billNo, tartetBillName, EASOrderCheck.subSequence(0, EASOrderCheck.length() - 1))).append('\n');
            iterator.remove();
        }
        if (collect.size() == 0) {
            msgSb.append((CharSequence)billNoCheck);
        }
        if (msgSb.length() > 0) {
            returnMap.put("title", MessageFormat.format(ResManager.loadKDString((String)"{0}\u751f\u6210\u5931\u8d25\u3002", (String)"SouToEasServiceImp_1", (String)"scm-sou-mservice", (Object[])new Object[0]), tartetBillName));
            returnMap.put("succed", "false");
            returnMap.put("message", msgSb);
            return returnMap;
        }
        switch (billname) {
            case "sou_compare": {
                return this.getSouCompareRule(collect.toArray(new DynamicObject[0]), targetBillType, tartetBillName);
            }
            case "sou_bidbillcfm": {
                return this.getSouBidBillRule(collect.toArray(new DynamicObject[0]), targetBillType, tartetBillName);
            }
        }
        returnMap.put("succed", "true");
        returnMap.put("botp", "");
        return returnMap;
    }

    private Map<String, Object> getSouBidBillRule(DynamicObject[] dynamicObjects, String targetBill, String targetBillName) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        if (SouBidCfmBillUtil.isValideData((DynamicObject[])dynamicObjects, (String)"entryentity")) {
            String inwareRules = SouBidCfmBillUtil.getBotpRule((DynamicObject[])dynamicObjects, (String)"entryentity", (String)targetBill);
            if (StringUtils.isEmpty((String)inwareRules)) {
                returnMap.put("title", MessageFormat.format(ResManager.loadKDString((String)"{0}\u751f\u6210\u5931\u8d25\u3002", (String)"SouToEasServiceImp_1", (String)"scm-sou-mservice", (Object[])new Object[0]), targetBillName));
                returnMap.put("succed", "false");
                returnMap.put("message", ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"SouToEasServiceImp_2", (String)"scm-sou-mservice", (Object[])new Object[0]));
                return returnMap;
            }
            JSONArray orderRuleList = JSONArray.fromObject((Object)inwareRules);
            if (orderRuleList.size() > 0 && orderRuleList.size() != 0) {
                returnMap.put("succed", "true");
                returnMap.put("botp", orderRuleList);
            }
        } else {
            returnMap.put("succed", "true");
            returnMap.put("botp", "");
        }
        return returnMap;
    }

    private Map<String, Object> getSouCompareRule(DynamicObject[] dynamicObjects, String targetBill, String targetBillName) {
        String inwareRules = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        try {
            inwareRules = SouCompareBillUtil.getBotpRule((DynamicObject[])dynamicObjects, (String)targetBill);
        }
        catch (Exception e) {
            returnMap.put("title", ResManager.loadKDString((String)"\u83b7\u53d6\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"SouToEasServiceImp_3", (String)"scm-sou-mservice", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"SouToEasServiceImp_2", (String)"scm-sou-mservice", (Object[])new Object[0]));
            log.error("\u83b7\u53d6\u8f6c\u6362\u89c4\u5219\u5931\u8d25", (Throwable)e);
            return returnMap;
        }
        if (SouCompareBillUtil.isEasBill()) {
            if (StringUtils.isEmpty((String)inwareRules)) {
                returnMap.put("title", MessageFormat.format(ResManager.loadKDString((String)"{0}\u751f\u6210\u5931\u8d25\u3002", (String)"SouToEasServiceImp_1", (String)"scm-sou-mservice", (Object[])new Object[0]), targetBillName));
                returnMap.put("succed", "false");
                returnMap.put("message", ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"SouToEasServiceImp_2", (String)"scm-sou-mservice", (Object[])new Object[0]));
                return returnMap;
            }
            JSONArray orderRuleList = JSONArray.fromObject((Object)inwareRules);
            if (orderRuleList.size() > 0 && orderRuleList.size() != 0) {
                returnMap.put("succed", "true");
                returnMap.put("botp", orderRuleList);
            }
        } else {
            returnMap.put("succed", "true");
            returnMap.put("botp", "");
        }
        return returnMap;
    }

    public String taskCallBack(Object returnData) {
        String data;
        Map resultMap;
        String success;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return "";
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && "true".equals(success = (String)(resultMap = (Map)SerializationUtils.fromJsonString((String)(data = taskInfo.getData()), Map.class)).get("success"))) {
            return (String)resultMap.get("result");
        }
        return "";
    }
}

