/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.plugin.AbstractBidHall;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SouBidHallUtil;
import kd.scm.sou.common.SouBidBillUtil;

public abstract class AbstractSouBidHall
extends AbstractBidHall {
    protected static final String MATERIALENTRY = "materialentry";
    protected static final String SUPQUOENTRY = "supquoentry";
    protected static final String QUOENTRY = "quoentry";
    protected static final String DEALEXCEPTION = "dealexception";
    protected static final String VIEWALL = "viewall";
    protected static final String REFRESH = "refresh";
    protected static final String BIDSTART = "bidstart";

    public void onCountDownEnd(CountDownEvent evt) {
        DynamicObject bidBill;
        String firstEnd;
        IPageCache cache = this.getPageCache();
        CountDown countDown = (CountDown)evt.getSource();
        if ("autorefresh_cd".equals(countDown.getKey())) {
            String bidStatus = (String)this.getModel().getValue("bidstatusval");
            if ((bidStatus.equals(BidStatusEnum.BIDDING.getVal()) || bidStatus.equals(BidStatusEnum.PAUSED.getVal()) || bidStatus.equals(BidStatusEnum.EVALUATING.getVal()) || bidStatus.equals(BidStatusEnum.END.getVal())) && this.isRefresh()) {
                this.refresh(null, false);
            }
            countDown.setDuration(this.getRefreshTime());
        }
        if ((firstEnd = cache.get("firstEnd")) == null && (bidBill = this.getSouBidBill()) != null && SouBidHallUtil.getRestOfTime((DynamicObject)bidBill) <= 0L) {
            String bidStatus = bidBill.getString("bidstatus");
            if (bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
                bidBill.set("bidstatus", (Object)BidStatusEnum.EVALUATING);
                SouBidBillUtil.updateSupEntryNotBiddingStatus((DynamicObject)bidBill);
                bidBill.set("bidnum", (Object)SouBidBillUtil.countQuoSup((DynamicObject)bidBill));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidBill});
            }
            this.setBidStatus(bidBill);
            this.setSupQuoInfo(bidBill);
            cache.put("firstEnd", "1");
        }
    }

    protected int getRefreshTime() {
        return 2;
    }

    public boolean isRefresh() {
        DynamicObject bidBill = this.getSouBidBill();
        if (null == bidBill) {
            return false;
        }
        String curSecond = this.getPageCache().get("curSecond");
        if (null != curSecond) {
            int curSecondInt = Integer.parseInt(curSecond);
            if (curSecondInt % 4 == 0) {
                curSecondInt = 1;
                this.getPageCache().put("curSecond", String.valueOf(curSecondInt));
                return true;
            }
            this.getPageCache().put("curSecond", String.valueOf(++curSecondInt));
        } else {
            this.getPageCache().put("curSecond", "1");
        }
        String delaytimeStr = this.getPageCache().get("delaytime");
        long delaytime = delaytimeStr == null ? 0L : Long.parseLong(delaytimeStr);
        Date pausetime = bidBill.getDate("pausetime");
        Date pausestarttime = bidBill.getDate("pausestarttime");
        if (null != pausetime && null != pausestarttime && pausetime.getTime() == pausestarttime.getTime() && delaytime != pausetime.getTime()) {
            this.getPageCache().put("delaytime", String.valueOf(pausetime.getTime()));
            return true;
        }
        return false;
    }

    protected void setBidStatus(DynamicObject quoBidBill) {
        String bidStatus = quoBidBill.getString("bidstatus");
        BidStatusEnum bidStatusEnum = BidStatusEnum.fromVal((String)bidStatus);
        Label bidStatusLable = (Label)this.getView().getControl("bidstatus");
        bidStatusLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\uff1a{0}", (String)"SouBidHallPlugin_14", (String)"scm-sou-formplugin", (Object[])new Object[0]), bidStatusEnum.getName()));
        this.getModel().setValue("bidstatusval", (Object)bidStatus);
        IFormView view = this.getView();
        if (bidStatusEnum.equals((Object)BidStatusEnum.BIDDING)) {
            view.setVisible(Boolean.FALSE, new String[]{"tblstart"});
            view.setVisible(Boolean.TRUE, new String[]{"tblterminate"});
        } else if (bidStatusEnum.equals((Object)BidStatusEnum.PAUSED)) {
            view.setVisible(Boolean.TRUE, new String[]{"tblstart"});
            view.setVisible(Boolean.TRUE, new String[]{"tblterminate"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tblstart"});
            view.setVisible(Boolean.FALSE, new String[]{"tblterminate"});
        }
    }

    protected void updateSupplierInfo(DynamicObject souBidBill) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refresh(null, true);
    }

    protected void bindData(DynamicObject souBidBill) {
        this.setTitle(souBidBill);
        this.setBidStatus(souBidBill);
        this.setRestOfTime(souBidBill);
        this.setBidRuleInfo(souBidBill);
        this.initCurrQuoInfo(souBidBill);
        this.setSupQuoInfo(souBidBill);
        this.getModel().setValue("org", (Object)souBidBill.getDynamicObject("org"));
    }

    protected abstract void initCurrQuoInfo(DynamicObject var1);

    protected void updateCurrQuoInfo(DynamicObject souBidBill) {
    }

    protected abstract void setSupQuoInfo(DynamicObject var1);

    protected void setBidRuleInfo(DynamicObject souBidBill) {
        super.setBidRuleInfo(souBidBill);
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        Date openDate = souBidBill.getDate("opendate");
        this.getModel().setValue("opendate", (Object)openDate);
        int bidTime = souBidBill.getInt("bidtime");
        Label bidtimeLable = (Label)view.getControl("bidtime");
        bidtimeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u5206\u949f", (String)"SouBidHallPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]), bidTime));
        DynamicObject curr = souBidBill.getDynamicObject("curr");
        BigDecimal bid = new BigDecimal(0);
        String sign = "";
        if (curr != null) {
            sign = curr.getString("sign");
            this.getModel().setValue("currency", curr.getPkValue());
            int precision = (Integer)curr.get("amtprecision");
            bid = new BigDecimal(String.valueOf(souBidBill.get("sumtaxamount"))).setScale(precision, 4);
        } else {
            bid = new BigDecimal(String.valueOf(souBidBill.get("sumtaxamount")));
        }
        view.getModel().setValue("sumtaxamount", (Object)bid);
        String sumTaxamount = bid.toString();
        Label reducetypeLable = (Label)view.getControl("reducetype");
        String reduceType = souBidBill.getString("reducetype");
        if (reduceType.equals("A")) {
            reducetypeLable.setText(ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b(%)", (String)"SouBidHallPlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        } else if (reduceType.equals("B")) {
            reducetypeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\u6309\u91d1\u989d({0})", (String)"SouBidHallPlugin_4", (String)"scm-sou-formplugin", (Object[])new Object[0]), sign));
        }
        String reducePct = String.valueOf(souBidBill.get("reducepct"));
        this.getModel().setValue("reducepct", souBidBill.get("reducepct"));
        Label bidcountLable = (Label)view.getControl("bidcount");
        int bidCount = souBidBill.getInt("bidcount");
        if (bidCount > 0) {
            bidcountLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u6b21", (String)"SouBidHallPlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0]), bidCount));
        } else {
            bidcountLable.setText(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"SouBidHallPlugin_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        String minAmount = String.valueOf(souBidBill.get("minamount"));
        this.getModel().setValue("minamount", souBidBill.get("minamount"));
        Label open2Lable = (Label)view.getControl("open2");
        boolean isOpen = souBidBill.getBoolean("open2");
        if (isOpen) {
            open2Lable.setText(ResManager.loadKDString((String)"\u516c\u5f00\u6392\u540d", (String)"SouBidHallPlugin_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        } else {
            open2Lable.setText(ResManager.loadKDString((String)"\u4e0d\u516c\u5f00\u6392\u540d", (String)"SouBidHallPlugin_9", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        cache.put("reduceType", reduceType);
        cache.put("reducePct", reducePct);
        cache.put("bidCount", String.valueOf(bidCount));
        cache.put("sumTaxamount", sumTaxamount);
        cache.put("minAmount", minAmount);
    }

    protected void setDelayRuleInfo(int lasttime, int delaytime) {
        String lasttimeLbl = "lasttime";
        IFormView view = this.getView();
        if (lasttime > 0) {
            Label lasttimeLabel = (Label)view.getControl(lasttimeLbl);
            lasttimeLabel.setText(MessageFormat.format(ResManager.loadKDString((String)"\u5012\u8ba1\u65f6{0}\u5206\u949f\u5185\u6709\u62a5\u4ef7\uff0c\u5ef6\u65f6{1}\u5206\u949f", (String)"AbstractSouBidHall_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), lasttime, delaytime));
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap13"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap13"});
        }
    }

    protected void setTitle(DynamicObject quoBidBill) {
        IFormView view = this.getView();
        DynamicObject org = quoBidBill.getDynamicObject("org");
        String name = quoBidBill.getString("name");
        Label titleLable = (Label)view.getControl("title");
        titleLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08\u53d1\u8d77\u65b9\uff1a{1}\uff09", (String)"SouBidHallPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), name, org.getString("name")));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "dealexception": {
                this.dealException();
                break;
            }
            case "bidstart": {
                this.bidStart();
                break;
            }
            case "refresh": {
                this.getPageCache().put("hashCache", null);
                this.refresh(null, true);
                break;
            }
            case "viewall": {
                this.viewAllQuo();
                break;
            }
        }
    }

    protected abstract void viewAllQuo();

    protected void refresh(DynamicObject souBidBill, boolean force) {
    }

    protected void bidStart() {
        DynamicObject souBidBill = this.getSouBidBill();
        String bidStatus = souBidBill.getString("bidStatus");
        if (!bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u662f\u6682\u505c\u72b6\u6001\u7684\u65e0\u9700\u542f\u52a8\u3002", (String)"SouBidHallPlugin_15", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        souBidBill.set("bidstatus", (Object)BidStatusEnum.BIDDING.getVal());
        souBidBill.set("pausestarttime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((IDataEntityType)souBidBill.getDataEntityType(), (Object[])new Object[]{souBidBill});
        this.setRestOfTime(souBidBill);
        this.getAppCache().put(String.valueOf(souBidBill.getPkValue()), (Object)TimeServiceHelper.now());
    }

    protected void dealException() {
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        Map paramMap = parameter.getCustomParams();
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_exception", (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, DEALEXCEPTION), (ShowType)ShowType.Modal));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "dealexception": {
                this.refresh(null, true);
                break;
            }
        }
    }

    protected DynamicObject getSouBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ade\u4ef7\u5355\u636e\u4fe1\u606f\u5931\u8d25\u3002", (String)"SouBidHallPlugin_16", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        long bidBillIdLong = Long.parseLong(bidBillIdObj.toString());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)MATERIALENTRY, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)QUOENTRY, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)SUPQUOENTRY, (boolean)false);
        DynamicObject objs = BusinessDataServiceHelper.loadSingle((String)"sou_bidbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidBillIdLong)});
        if (objs == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ade\u4ef7\u5355\u636e\u4fe1\u606f\u5931\u8d25\u3002", (String)"SouBidHallPlugin_16", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        return objs;
    }
}

