/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.sou.common.SouBidBillUtil;
import kd.scm.sou.common.SouCommonUtil;
import kd.scm.sou.common.entity.QuoteWinInfo;
import kd.scm.sou.formplugin.SouBidConfirmPlugin;

public class SouBidEntryConfirmPlugin
extends SouBidConfirmPlugin {
    @Override
    public void registerListener(EventObject e) {
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.bindData();
    }

    @Override
    public void bindData() {
        DynamicObject bidInfo = this.getSouBidBillInfo();
        HashSet<Long> supplierSet = new HashSet<Long>();
        final IPageCache pageCache = this.getView().getPageCache();
        Map resultMap = SouBidBillUtil.getSupQuoWinMap((DynamicObjectCollection)bidInfo.getDynamicObjectCollection("entryentity2"), (String)"materialrowid", supplierSet, (Function)new Function<DynamicObject, IPageCache>(){
            Map<String, String> cacheMap = new HashMap<String, String>();

            @Override
            public IPageCache apply(DynamicObject info) {
                String supplierId = info.getString("quotesupplier_id");
                String materialRowId = info.getString("materialrowid");
                String key = supplierId + "-" + materialRowId;
                String quote = this.cacheMap.get(key);
                BigDecimal quotePrice = info.getBigDecimal("quoteprice");
                BigDecimal quoteTaxPrice = info.getBigDecimal("quotetaxprice");
                String value = (quotePrice == null ? "0" : quotePrice.toString()) + "-" + (quoteTaxPrice == null ? "0" : quoteTaxPrice.toString());
                if (StringUtils.isBlank((CharSequence)quote)) {
                    this.cacheMap.put(key, value);
                    pageCache.put(key, value);
                }
                return pageCache;
            }
        });
        this.createComBoValue(bidInfo.getDynamicObjectCollection("entryentity1"), supplierSet);
        DynamicObjectCollection materialEntry = bidInfo.getDynamicObjectCollection("entryentity");
        this.setProjectInfo(bidInfo);
        this.createAwardRowInfo(materialEntry, resultMap, bidInfo.getDynamicObject("curr"));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String name = e.getProperty().getName();
        block6: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null) {
                return;
            }
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            switch (name) {
                case "awardobj": {
                    String value = this.getPageCache().get(newValue + "-" + this.getModel().getValue("materialrowid", rowIndex));
                    if (StringUtils.isBlank((CharSequence)value)) {
                        this.getModel().setValue("quoprice", (Object)"", rowIndex);
                        continue block6;
                    }
                    String[] split = value.split("-");
                    if (split.length == 2) {
                        BigDecimal quoTaxPrice = this.converToBigDecimal(split[1]);
                        this.getModel().setValue("quoprice", (Object)quoTaxPrice, rowIndex);
                        continue block6;
                    }
                    this.getModel().setValue("quoprice", (Object)"", rowIndex);
                    continue block6;
                }
            }
        }
    }

    private BigDecimal converToBigDecimal(String value) {
        return value == null ? BigDecimal.ZERO : new BigDecimal(value);
    }

    private void setProjectInfo(DynamicObject bidInfo) {
        this.getModel().setValue("bidtitle", (Object)bidInfo.getString("name"));
        this.getModel().setValue("auditdate", (Object)TimeServiceHelper.now());
    }

    private void createAwardRowInfo(DynamicObjectCollection materialEntry, Map<String, QuoteWinInfo> resultMap, DynamicObject curr) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        BigDecimal qty = null;
        for (int i = 0; i < materialEntry.size(); ++i) {
            QuoteWinInfo info = resultMap.get(((DynamicObject)materialEntry.get(i)).getString("id"));
            vs.set("awardobj", info == null ? "1" : info.getSupplierId(), i);
            DynamicObject row = (DynamicObject)materialEntry.get(i);
            vs.set("material_id", (Object)row.getLong("material_id"), i);
            vs.set("materialrowid", row.getPkValue(), i);
            String nameText = row.getString("materialnametext");
            if (StringUtils.isBlank((CharSequence)nameText)) {
                vs.set("materialnametext", (Object)row.getLocaleString("material.name").getLocaleValue(), i);
            } else {
                vs.set("materialnametext", (Object)nameText, i);
            }
            vs.set("unit_id", row.get("unit_id"), i);
            qty = row.getBigDecimal("qty");
            vs.set("qty", (Object)qty, i);
            vs.set("currency_id", curr.getPkValue(), i);
            vs.set("price", (Object)row.getBigDecimal("price"), i);
            vs.set("quoprice", (Object)(info == null ? BigDecimal.ZERO : info.getWinTaxPrice()), i);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    private void createComBoValue(DynamicObjectCollection quoSupplier, Set<Long> supplierSet) {
        ComboEdit awardComboEdit = (ComboEdit)this.getView().getControl("awardobj");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u6388\u6807", (String)"SouBidConfirmPlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0])), "1"));
        quoSupplier.forEach(info -> {
            String supplierId = info.getString("entrysupplier_id");
            String supplierName = info.getDynamicObject("entrysupplier").getString("name");
            ComboItem comboItem = new ComboItem(new LocaleString(supplierName), supplierId);
            comboItemList.add(comboItem);
        });
        awardComboEdit.setComboItems(comboItemList);
    }

    public DynamicObject getSouBidBillInfo() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj != null) {
            long bidBillIdLong = Long.parseLong(bidBillIdObj.toString());
            String selects = "id,billno,name,bidstatus,billstatus,curr,bidamount,bidprofit,sumtaxamount,decidedate,entryentity.material,entryentity.entryid,entryentity.qty,entryentity.price,entryentity.taxprice,entryentity.unit,entryentity.winsupplier,entryentity.winprice,entryentity.wintaxprice,entryentity.winamount,entryentity.winoption,entryentity2.quotematerial,entryentity2.quotesupplier,entryentity2.quotedate,entryentity2.materialrowid,entryentity2.quoteprice,entryentity2.quotetaxprice,entryentity2.quoteamount,entryentity1.supamount,entryentity1.entrysupplier,entryentity.materialnametext";
            return BusinessDataServiceHelper.loadSingle((String)"sou_bidbillcfm", (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidBillIdLong)});
        }
        return null;
    }

    @Override
    public void confirmBid() {
        IFormView view = this.getView();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        DynamicObject souBidInfo = BusinessDataServiceHelper.loadSingle(bidBillIdObj, (String)"sou_bidbillcfm");
        boolean flag = false;
        HashMap<String, String> materialMap = new HashMap<String, String>(entryentity.size());
        for (DynamicObject info : entryentity) {
            String supplierId;
            if (!StringUtils.equals((CharSequence)info.getString("awardobj"), (CharSequence)"1")) {
                flag = true;
            }
            if ((supplierId = (String)materialMap.get(info.getString("materialrowid"))) != null) continue;
            materialMap.put(info.getString("materialrowid"), info.getString("awardobj") + "-" + info.getString("awardoption"));
        }
        if (!flag) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u4f9b\u5e94\u5546\u3002", (String)"SouBidConfirmPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setSouBidInfo(souBidInfo, materialMap);
        HashMap<String, Boolean> returnData = new HashMap<String, Boolean>();
        returnData.put("isConfirmed", true);
        view.returnDataToParent(returnData);
        view.close();
    }

    private void setSouBidInfo(DynamicObject souBidInfo, Map<String, String> materialMap) {
        DynamicObjectCollection materialEntry = souBidInfo.getDynamicObjectCollection("entryentity");
        BigDecimal total = BigDecimal.ZERO;
        IPageCache pageCache = this.getPageCache();
        HashSet<String> winSupplierSet = new HashSet<String>(1024);
        for (DynamicObject info : materialEntry) {
            String[] split;
            String[] split1;
            String awardobj = materialMap.get(info.getString("id"));
            if (awardobj == null || StringUtils.equals((CharSequence)(split1 = awardobj.split("-"))[0], (CharSequence)"1")) continue;
            info.set("winsupplier_id", (Object)split1[0]);
            winSupplierSet.add(split1[0]);
            String quoteInfo = pageCache.get(split1[0] + "-" + info.getString("id"));
            if (StringUtils.isBlank((CharSequence)quoteInfo) || (split = quoteInfo.split("-")).length != 2) continue;
            info.set("winprice", (Object)this.converToBigDecimal(split[0]));
            BigDecimal taxprice = this.converToBigDecimal(split[1]);
            info.set("wintaxprice", (Object)taxprice);
            BigDecimal taxAmount = info.getBigDecimal("qty").multiply(taxprice);
            info.set("winamount", (Object)taxAmount);
            if (split1.length == 2) {
                info.set("winoption", (Object)split1[1]);
            }
            total = total.add(taxAmount);
        }
        DynamicObjectCollection supQuoEntrys = souBidInfo.getDynamicObjectCollection("entryentity1");
        Set<String> quoSupIdSet = this.getQuoSupIdSet();
        for (DynamicObject supQuoEntry : supQuoEntrys) {
            DynamicObject quoSup = supQuoEntry.getDynamicObject("entrysupplier");
            if (null == quoSup) continue;
            String quoSupId = quoSup.getPkValue().toString();
            if (winSupplierSet.contains(quoSupId)) {
                supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.WINTHEBID);
                continue;
            }
            if (!quoSupIdSet.contains(quoSupId)) continue;
            supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.FAILTHEBID);
        }
        souBidInfo.set("bidamount", (Object)total);
        souBidInfo.set("bidprofit", (Object)souBidInfo.getBigDecimal("sumtaxamount").subtract(total));
        souBidInfo.set("decidedate", (Object)TimeServiceHelper.now());
        souBidInfo.set("bidstatus", (Object)BidStatusEnum.CONFIRMED);
        souBidInfo.set("decider", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.update((DynamicObject)souBidInfo);
        DynamicObjectCollection entryentity = souBidInfo.getDynamicObjectCollection("entryentity");
        SouCommonUtil.updatePmStatus((DynamicObjectCollection)entryentity);
    }
}

