/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.SouBidHallUtil;
import kd.scm.sou.common.SouBidBillUtil;
import kd.scm.sou.formplugin.AbstractSouBidHall;

public class SouBidHallByEntryPlugin
extends AbstractSouBidHall
implements SelectRowsEventListener {
    private static final int INIT_LINE_COUNT = 1;
    private static final String MATERIAL_ROW_ID = "materialrowid";
    private static final String QUOTE_MATERIAL = "quotematerial";
    private static String[] SYMBLE = new String[]{"circle", "rect", "roundRect", "diamond"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid eg = (EntryGrid)this.getControl("currquoentity");
        eg.addSelectRowsListener((SelectRowsEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("hashCache", "1");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && "getsigninfo".equals(opKey = e.getOperateKey())) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map param = parameter.getCustomParams();
            Object bidBillId = param.get("bidBillId");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sou_bidsign_info");
            showParameter.setCustomParam("bidBillId", bidBillId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    @Override
    protected void initCurrQuoInfo(DynamicObject souBidBill) {
        DynamicObjectCollection materialCols = souBidBill.getDynamicObjectCollection("materialentry");
        DynamicObjectCollection quoteCols = souBidBill.getDynamicObjectCollection("quoentry");
        SouBidHallUtil.sortByQuoteDate((DynamicObjectCollection)quoteCols, (int)-1);
        TreeSet<String> treeSet = new TreeSet<String>();
        HashMap<String, Map<String, BigDecimal>> dataResultMap = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, BigDecimal> neweastPriceMap = this.wrapNeweastPrice(quoteCols, treeSet, dataResultMap);
        this.initCurrQuoEntity(souBidBill, neweastPriceMap);
        this.initEntryChartData(materialCols, treeSet, dataResultMap, souBidBill);
    }

    @Override
    protected void refresh(DynamicObject souBidBill, boolean force) {
        if (souBidBill == null) {
            souBidBill = this.needFresh(force);
        }
        if (Objects.nonNull(souBidBill)) {
            this.bindData(souBidBill);
        }
    }

    private Map<String, BigDecimal> wrapNeweastPrice(DynamicObjectCollection quoteCols, TreeSet<String> treeSet, Map<String, Map<String, BigDecimal>> dataResultMap) {
        HashMap<String, BigDecimal> newEastPriceMap = new HashMap<String, BigDecimal>();
        int size = quoteCols.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal quoteamount;
            DynamicObject parent;
            DynamicObject dynamicObject = (DynamicObject)quoteCols.get(i);
            Date quoteDate = dynamicObject.getDate("quotedate");
            String rowKey = dynamicObject.getString(MATERIAL_ROW_ID);
            String key = DateUtil.date2str((Date)quoteDate, (String)"yyyy-MM-dd HH:mm:ss");
            if (StringUtils.isBlank((CharSequence)key)) continue;
            treeSet.add(key);
            Map<String, BigDecimal> valueMap = dataResultMap.get(key);
            if (valueMap == null) {
                valueMap = new HashMap<String, BigDecimal>();
                dataResultMap.put(key, valueMap);
            }
            if ((parent = (DynamicObject)dynamicObject.getParent()) != null) {
                String taxtype = parent.getString("taxtype");
                String quotemode = parent.getString("quotemode");
                quoteamount = "2".equals(quotemode) ? (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxtype) ? dynamicObject.getBigDecimal("quoteprice") : dynamicObject.getBigDecimal("quotetaxprice")) : dynamicObject.getBigDecimal("quoteamount");
            } else {
                quoteamount = dynamicObject.getBigDecimal("quoteamount");
            }
            valueMap.put(rowKey, quoteamount);
            BigDecimal bigDecimal = (BigDecimal)newEastPriceMap.get(rowKey);
            if (bigDecimal != null) continue;
            newEastPriceMap.put(rowKey, quoteamount);
        }
        return newEastPriceMap;
    }

    protected void initCurrQuoEntity(DynamicObject souBidBill, Map<String, BigDecimal> neweastPriceMap) {
        if (this.hasCache()) {
            this.updateCurrQuoEntity(neweastPriceMap);
        } else {
            this.insertCurrQuoInfo(souBidBill, neweastPriceMap);
        }
    }

    private void insertCurrQuoInfo(DynamicObject souBidBill, Map<String, BigDecimal> neweastPriceMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        model.deleteEntryData("currquoentity");
        DynamicObjectCollection materialCols = souBidBill.getDynamicObjectCollection("materialentry");
        DynamicObject curr = souBidBill.getDynamicObject("curr");
        String taxType = souBidBill.getString("taxtype");
        for (int i = 0; i < materialCols.size(); ++i) {
            DynamicObject row = (DynamicObject)materialCols.get(i);
            DynamicObject material = row.getDynamicObject("material");
            ts.set("currmaterial", (Object)material, i);
            String materialnametext = row.getString("materialnametext");
            if (StringUtils.isBlank((CharSequence)materialnametext)) {
                ts.set("currmaterialnametext", (Object)material.getLocaleString("name").getLocaleValue(), i);
            } else {
                ts.set("currmaterialnametext", (Object)materialnametext, i);
            }
            ts.set("currmaterial_id", (Object)row.getLong("material_id"), i);
            ts.set("currcurrency", (Object)curr, i);
            ts.set("currprice", (Object)row.getBigDecimal("price"), i);
            ts.set("currtaxprice", (Object)row.getBigDecimal("taxprice"), i);
            ts.set("currislarge", (Object)row.getBoolean("islarge"), i);
            ts.set(MATERIAL_ROW_ID, row.getPkValue(), i);
            ts.set("currlatestprice", (Object)neweastPriceMap.get(String.valueOf(row.getPkValue())), i);
        }
        model.batchCreateNewEntryRow("currquoentity", ts);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"currprice"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"currtaxprice"});
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"currprice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"currtaxprice"});
        }
    }

    private boolean hasCache() {
        return StringUtils.isNotBlank((CharSequence)this.getPageCache().get("hashCache"));
    }

    private void updateCurrQuoEntity(Map<String, BigDecimal> neweastPriceMap) {
        DynamicObjectCollection currquoentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("currquoentity");
        if (currquoentity != null) {
            for (int i = 0; i < currquoentity.size(); ++i) {
                this.getModel().setValue("currlatestprice", (Object)neweastPriceMap.get(((DynamicObject)currquoentity.get(i)).getString(MATERIAL_ROW_ID)), i);
            }
        }
    }

    private void initEntryChartData(DynamicObjectCollection materialCols, TreeSet<String> treeSet, Map<String, Map<String, BigDecimal>> dataResultMap, DynamicObject souBidBill) {
        Control pointlineChart = this.getControl("entrychart");
        if (pointlineChart instanceof PointLineChart) {
            PointLineChart pieChart = (PointLineChart)pointlineChart;
            pieChart.clearGraphic();
            Axis xAxis = pieChart.createXAxis(ResManager.loadKDString((String)"", (String)"SouBidHallPlugin_10", (String)"scm-sou-formplugin", (Object[])new Object[0]), AxisType.category);
            pieChart.getLegendXAlign();
            DynamicObject currency = souBidBill.getDynamicObject("curr");
            String currSign = currency.getString("sign");
            pieChart.createYAxis(MessageFormat.format(ResManager.loadKDString((String)"\u91d1\u989d({0})", (String)"SouBidHallPlugin_13", (String)"scm-sou-formplugin", (Object[])new Object[0]), currSign), AxisType.value);
            EntryGrid grid = (EntryGrid)this.getView().getControl("currquoentity");
            int[] rows = grid.getSelectRows();
            pieChart.setMargin(Position.left, "30");
            pieChart.setMargin(Position.right, "50");
            if (rows.length > 0) {
                for (int i = 0; i < rows.length && rows.length <= 1; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)materialCols.get(rows[i]);
                    String rowId = String.valueOf(dynamicObject.getPkValue());
                    DynamicObject material = dynamicObject.getDynamicObject("material");
                    if (material == null) continue;
                    String materialName = dynamicObject.getString("materialnametext");
                    LineSeries series = StringUtils.isBlank((CharSequence)materialName) ? pieChart.createSeries(material.getString("name")) : pieChart.createSeries(materialName);
                    series.setSmooth(true);
                    series.setPropValue("symbol", (Object)SYMBLE[i]);
                    for (String dateSet : treeSet) {
                        Map<String, BigDecimal> valueMap = dataResultMap.get(dateSet);
                        if (valueMap == null) continue;
                        BigDecimal bigDecimal = valueMap.get(rowId);
                        List data = series.getData();
                        if (data != null && bigDecimal == null) {
                            series.addData((Number)data.get(data.size() - 1));
                            continue;
                        }
                        series.addData((Number)bigDecimal);
                    }
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"entrychart"});
                xAxis.setCategorys(treeSet.toArray(new String[0]));
                pieChart.bindData(null);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entrychart"});
            }
        }
    }

    @Override
    protected void setSupQuoInfo(DynamicObject souBidBill) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        model.deleteEntryData("pastquoentity");
        DynamicObject curr = souBidBill.getDynamicObject("curr");
        DynamicObjectCollection quoteCols = souBidBill.getDynamicObjectCollection("quoentry");
        String taxtype = souBidBill.getString("taxtype");
        boolean flag = true;
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxtype)) {
            flag = false;
        }
        for (int i = 0; i < quoteCols.size(); ++i) {
            DynamicObject object = (DynamicObject)quoteCols.get(i);
            DynamicObject material = object.getDynamicObject(QUOTE_MATERIAL);
            ts.set("pastmaterial", material.getPkValue(), i);
            String nameText = object.getString("quotematerialnametext");
            if (StringUtils.isBlank((CharSequence)nameText)) {
                ts.set("pastmaterialnametext", (Object)material.getLocaleString("name").getLocaleValue(), i);
            } else {
                ts.set("pastmaterialnametext", (Object)nameText, i);
            }
            ts.set("pastsupplier", object.getDynamicObject("quotesupplier").getPkValue(), i);
            ts.set("passcurrency_id", curr.getPkValue(), i);
            if (flag) {
                ts.set("pastlatestprice", (Object)object.getBigDecimal("quotetaxprice"), i);
            } else {
                ts.set("pastlatestprice", (Object)object.getBigDecimal("quoteprice"), i);
            }
            ts.set("pastquotetime", object.get("quotedate"), i);
            ts.set("taxrateid_id", object.get("quotaxrateid_id"), i);
            ts.set("taxrate", object.get("quotaxrate"), i);
            ts.set("passtaxprice", object.get("quotetaxprice"), i);
            ts.set("passprice", object.get("quoteprice"), i);
        }
        model.batchCreateNewEntryRow("pastquoentity", ts);
    }

    @Override
    protected void setBidRuleInfo(DynamicObject souBidBill) {
        super.setBidRuleInfo(souBidBill);
        IFormView view = this.getView();
        int lastTime = souBidBill.getInt("lasttime");
        int delayTime = souBidBill.getInt("delaytime");
        this.setDelayRuleInfo(lastTime, delayTime);
        Label quoteMode = (Label)view.getControl("quotemode");
        if ("1".equals(souBidBill.getString("quotemode"))) {
            quoteMode.setText(ResManager.loadKDString((String)"\u6309\u603b\u989d", (String)"SouBidHallPlugin_19", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        } else {
            quoteMode.setText(ResManager.loadKDString((String)"\u6309\u884c\u9879\u76ee", (String)"SouBidHallPlugin_18", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        Label addRemark = (Label)view.getControl("addremark");
        addRemark.setText(souBidBill.getString("addremark"));
        Label taxTypeLbl = (Label)view.getControl("taxtype");
        String taxType = souBidBill.getString("taxtype");
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            taxTypeLbl.setText(TaxTypeEnum.TAXSEXPRICE_INTAX.getName());
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            taxTypeLbl.setText(TaxTypeEnum.TAXSEXPRICE_EXTAX.getName());
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            taxTypeLbl.setText(TaxTypeEnum.TAXSINPRICE_INTAX.getName());
        }
    }

    @Override
    protected void viewAllQuo() {
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        Map paramMap = parameter.getCustomParams();
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_quoteview", (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "viewall"), (ShowType)ShowType.Modal));
    }

    @Override
    protected void updateSupplierInfo(DynamicObject souBidBill) {
        SouBidBillUtil.confirmBidEntryQuote((DynamicObject)souBidBill, (boolean)true);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (entryGrid != null && entryGrid.getEntryKey().equals("currquoentity")) {
            this.refresh(null, true);
        }
    }
}

