/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SouBidHallUtil;
import kd.scm.sou.common.SouBidBillUtil;

public class SouBidHallPlugin
extends AbstractFormPlugin
implements CountDownListener {
    private static Log log = LogFactory.getLog((String)"SouBidHallPlugin");
    private static final String SUPQUOENTRY = "supquoentry";
    private static final String QUOENTRY = "quoentry";
    private static final String DEALEXCEPTION = "dealexception";
    private static final String VIEWALL = "viewall";
    private static final String REFRESH = "refresh";
    private static final String BIDSTART = "bidstart";

    public void registerListener(EventObject e) {
        CountDown autorefresh_cd;
        super.registerListener(e);
        CountDown countdown = (CountDown)this.getControl("countdownap");
        if (countdown != null) {
            countdown.addCountDownListener((CountDownListener)this);
        }
        if ((autorefresh_cd = (CountDown)this.getControl("autorefresh_cd")) != null) {
            autorefresh_cd.addCountDownListener((CountDownListener)this);
        }
    }

    public void onCountDownEnd(CountDownEvent countDownEvt) {
        DynamicObject bidBill;
        String firstEnd;
        IPageCache cache = this.getPageCache();
        CountDown countDown = (CountDown)countDownEvt.getSource();
        if ("autorefresh_cd".equals(countDown.getKey())) {
            String bidStatus = (String)this.getModel().getValue("bidstatusval");
            if ((bidStatus.equals(BidStatusEnum.BIDDING.getVal()) || bidStatus.equals(BidStatusEnum.PAUSED.getVal()) || bidStatus.equals(BidStatusEnum.EVALUATING.getVal()) || bidStatus.equals(BidStatusEnum.END.getVal())) && this.isRefresh()) {
                this.refresh();
            }
            countDown.setDuration(1);
        }
        if ((firstEnd = cache.get("firstEnd")) == null && (bidBill = this.getSouBidBill()) != null && SouBidHallUtil.getRestOfTime((DynamicObject)bidBill) <= 0L) {
            String bidStatus = bidBill.getString("bidstatus");
            if (bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
                bidBill.set("bidstatus", (Object)BidStatusEnum.EVALUATING);
                SouBidBillUtil.updateSupEntryNotBiddingStatus((DynamicObject)bidBill);
                bidBill.set("bidnum", (Object)SouBidBillUtil.countQuoSup((DynamicObject)bidBill));
                SouBidBillUtil.updateSupplierInfo((DynamicObject)bidBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidBill});
            }
            this.setBidStatus(bidBill);
            this.setSupQuoInfo(bidBill);
            cache.put("firstEnd", "1");
        }
    }

    public boolean isRefresh() {
        DynamicObject bidBill = this.getSouBidBill();
        if (null == bidBill) {
            return false;
        }
        String curSecond = this.getPageCache().get("curSecond");
        if (null != curSecond) {
            int curSecondInt = Integer.parseInt(curSecond);
            if (curSecondInt % 4 == 0) {
                curSecondInt = 1;
                this.getPageCache().put("curSecond", String.valueOf(curSecondInt));
                return true;
            }
            this.getPageCache().put("curSecond", String.valueOf(++curSecondInt));
        } else {
            this.getPageCache().put("curSecond", "1");
        }
        String delaytimeStr = this.getPageCache().get("delaytime");
        long delaytime = delaytimeStr == null ? 0L : Long.parseLong(delaytimeStr);
        Date pausetime = bidBill.getDate("pausetime");
        Date pausestarttime = bidBill.getDate("pausestarttime");
        if (null != pausetime && null != pausestarttime && pausetime.getTime() == pausestarttime.getTime() && delaytime != pausetime.getTime()) {
            this.getPageCache().put("delaytime", String.valueOf(pausetime.getTime()));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && "getsigninfo".equals(opKey = e.getOperateKey())) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map param = parameter.getCustomParams();
            Object bidBillId = param.get("bidBillId");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sou_bidsign_info");
            showParameter.setCustomParam("bidBillId", bidBillId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.bindData();
        this.setAutoRefreshTime(1);
    }

    private void bindData() {
        DynamicObject souBidBill = this.getSouBidBill();
        if (souBidBill == null) {
            return;
        }
        this.setTitle(souBidBill);
        this.setBidStatus(souBidBill);
        this.setRestOfTime(souBidBill);
        this.setBidRuleInfo(souBidBill);
        this.setSupQuoInfo(souBidBill);
        this.setTendencyChartData(souBidBill);
        DynamicObject org = souBidBill.getDynamicObject("org");
        this.getModel().setValue("org", org != null ? org.getPkValue() : Long.valueOf(0L));
    }

    private void setTitle(DynamicObject quoBidBill) {
        IFormView view = this.getView();
        DynamicObject org = quoBidBill.getDynamicObject("org");
        String name = quoBidBill.getString("name");
        Label titleLable = (Label)view.getControl("title");
        titleLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08\u53d1\u8d77\u65b9\uff1a{1}\uff09", (String)"SouBidHallPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]), name, org.getString("name")));
    }

    private DynamicObject getSouBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap params = new HashMap(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.valueOf(String.valueOf(bidBillIdObj)));
        params.put("id", idMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)QUOENTRY, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)SUPQUOENTRY, (boolean)false);
        DynamicObject[] objs = ORMUtil.load((String)"sou_bidbill", (String)selectFields, params, (String)"quoentry.quotedate desc");
        return objs.length == 0 ? null : objs[0];
    }

    private void setRestOfTime(DynamicObject quoBidBill) {
        Label secondsLable;
        Label minutesLable;
        IFormView view = this.getView();
        String bidStatus = quoBidBill.getString("bidstatus");
        CountDown countdown = (CountDown)this.getControl("countdownap");
        long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)quoBidBill);
        long days = restOfTime / 86400000L;
        long hours = (restOfTime - days * 86400000L) / 3600000L;
        long minutes = (restOfTime - days * 86400000L - hours * 3600000L) / 60000L;
        long second = restOfTime / 1000L - days * 24L * 60L * 60L - hours * 60L * 60L - minutes * 60L;
        Label hoursLable = (Label)view.getControl("hours");
        if (hoursLable != null) {
            hoursLable.setText(String.valueOf(hours));
        }
        if ((minutesLable = (Label)view.getControl("minutes")) != null) {
            minutesLable.setText(String.valueOf(minutes));
        }
        if ((secondsLable = (Label)view.getControl("seconds")) != null) {
            secondsLable.setText(String.valueOf(second));
        }
        if (countdown != null) {
            countdown.setDuration((int)(restOfTime / 1000L));
            if (restOfTime == 0L) {
                countdown.pause();
            }
            log.info("@@\u5012\u8ba1\u65f6\u5f00\u59cb\uff1a" + restOfTime);
        }
        if (countdown != null && bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
            countdown.pause();
        }
    }

    private void setBidRuleInfo(DynamicObject quoBidBill) {
        IPageCache cache = this.getPageCache();
        IFormView view = this.getView();
        Date openDate = quoBidBill.getDate("opendate");
        this.getModel().setValue("opendate", (Object)openDate);
        int bidTime = quoBidBill.getInt("bidtime");
        Label bidtimeLable = (Label)view.getControl("bidtime");
        bidtimeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u5206\u949f", (String)"SouBidHallPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]), bidTime));
        int lasttime = quoBidBill.getInt("lasttime");
        if (lasttime > 0) {
            Label lasttimeLabel = (Label)view.getControl("lasttime");
            lasttimeLabel.setText(String.valueOf(lasttime));
            Label delaytimeLable = (Label)view.getControl("delaytime");
            delaytimeLable.setText(quoBidBill.getString("delaytime"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"delayflexpanelap1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"delayflexpanelap1"});
        }
        DynamicObject curr = quoBidBill.getDynamicObject("curr");
        BigDecimal bid = BigDecimal.ZERO;
        String sign = "";
        if (curr != null) {
            sign = curr.getString("sign");
            this.getModel().setValue("currency", curr.getPkValue());
            int precision = (Integer)curr.get("amtprecision");
            bid = new BigDecimal(String.valueOf(quoBidBill.get("sumtaxamount"))).setScale(precision, 4);
        } else {
            bid = new BigDecimal(String.valueOf(quoBidBill.get("sumtaxamount")));
        }
        view.getModel().setValue("sumtaxamount", (Object)bid);
        String sumTaxamount = bid.toString();
        Label reducetypeLable = (Label)view.getControl("reducetype");
        String reduceType = quoBidBill.getString("reducetype");
        if (reduceType.equals("A")) {
            reducetypeLable.setText(ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b(%)", (String)"SouBidHallPlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        } else if (reduceType.equals("B")) {
            reducetypeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\u6309\u91d1\u989d({0})", (String)"SouBidHallPlugin_4", (String)"scm-sou-formplugin", (Object[])new Object[0]), sign));
        }
        DynamicProperty quotationtrend1 = quoBidBill.getDynamicObjectType().getProperty("quotationtrend");
        if (quotationtrend1 instanceof ComboProp) {
            String trend = quoBidBill.getString("quotationtrend");
            Label quotationtrend = (Label)view.getControl("quotationtrend");
            String itemByName = ((ComboProp)quotationtrend1).getItemByName(trend);
            if (quotationtrend != null) {
                quotationtrend.setText(itemByName);
            }
        }
        String reducePct = String.valueOf(quoBidBill.get("reducepct"));
        this.getModel().setValue("reducepct", quoBidBill.get("reducepct"));
        Label bidcountLable = (Label)view.getControl("bidcount");
        int bidCount = quoBidBill.getInt("bidcount");
        if (bidCount > 0) {
            bidcountLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u6b21", (String)"SouBidHallPlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0]), String.valueOf(quoBidBill.get("bidcount"))));
        } else {
            bidcountLable.setText(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"SouBidHallPlugin_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        String minAmount = String.valueOf(quoBidBill.get("minamount"));
        this.getModel().setValue("minamount", quoBidBill.get("minamount"));
        Label open2Lable = (Label)view.getControl("open2");
        boolean isOpen = quoBidBill.getBoolean("open2");
        if (isOpen) {
            open2Lable.setText(ResManager.loadKDString((String)"\u516c\u5f00\u6392\u540d", (String)"SouBidHallPlugin_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        } else {
            open2Lable.setText(ResManager.loadKDString((String)"\u4e0d\u516c\u5f00\u6392\u540d", (String)"SouBidHallPlugin_9", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        cache.put("reduceType", reduceType);
        cache.put("reducePct", reducePct);
        cache.put("bidCount", String.valueOf(bidCount));
        cache.put("sumTaxamount", sumTaxamount);
        cache.put("minAmount", minAmount);
        this.setIsLargeBaseInfo(quoBidBill);
    }

    private void setIsLargeBaseInfo(DynamicObject quoBidBill) {
        Label islargebaseLabel = (Label)this.getView().getControl("islargebase");
        boolean islargebase = quoBidBill.getBoolean("islargebase");
        if (islargebase) {
            islargebaseLabel.setText(ResManager.loadKDString((String)"\u662f", (String)"SouBidHallPlugin_16", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        } else {
            islargebaseLabel.setText(ResManager.loadKDString((String)"\u5426", (String)"SouBidHallPlugin_17", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
    }

    private void setSupQuoInfo(DynamicObject quoBidBill) {
        DynamicObjectCollection quoCols = quoBidBill.getDynamicObjectCollection(QUOENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        model.deleteEntryData("entryentity");
        for (int j = quoCols.size() - 1; j >= 0; --j) {
            if (i >= 5) continue;
            DynamicObject quoCol = (DynamicObject)quoCols.get(j);
            Object quoSupObj = quoCol.get("quotesupplier");
            Object quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? ((DynamicObject)quoSupObj).getPkValue() : quoSupObj;
            ts.set("supplier", quoSupplierPk, i);
            ts.set("quoteamt", quoCol.get("quoteamount"), i);
            ts.set("reduceamt", quoCol.get("suppreduceamt"), i);
            ts.set("quotetime", quoCol.get("quotedate"), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private void setTendencyChartData(DynamicObject quoBidBill) {
        Control pointlineChart = this.getControl("tendencychart");
        if (pointlineChart instanceof PointLineChart) {
            PointLineChart pieChart = (PointLineChart)pointlineChart;
            pieChart.setMargin(Position.left, "30");
            pieChart.setMargin(Position.right, "50");
            Axis chart = pieChart.createXAxis(ResManager.loadKDString((String)"\u65e5\u671f", (String)"SouBidHallPlugin_10", (String)"scm-sou-formplugin", (Object[])new Object[0]), AxisType.category);
            pieChart.setName(new LocaleString(ResManager.loadKDString((String)"\u62a5\u4ef7\u91d1\u989d\u8d8b\u52bf\u56fe", (String)"SouBidHallPlugin_11", (String)"scm-sou-formplugin", (Object[])new Object[0])));
            LineSeries series = pieChart.createSeries(ResManager.loadKDString((String)"\u62a5\u4ef7\u91d1\u989d", (String)"SouBidHallPlugin_12", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            ArrayList<String> quoDateList = new ArrayList<String>(6);
            ArrayList<Object> dataList = new ArrayList<Object>(6);
            DynamicObjectCollection quoCols = quoBidBill.getDynamicObjectCollection(QUOENTRY);
            for (DynamicObject quoCol : quoCols) {
                quoDateList.add(DateUtil.date2str((Date)quoCol.getDate("quotedate"), null));
                dataList.add(quoCol.get("quoteamount"));
            }
            chart.setCategorys(quoDateList.toArray(new String[0]));
            series.setData(dataList.toArray(new Number[0]));
            DynamicObject currency = quoBidBill.getDynamicObject("curr");
            String currSign = currency.getString("sign");
            pieChart.createYAxis(MessageFormat.format(ResManager.loadKDString((String)"\u91d1\u989d({0})", (String)"SouBidHallPlugin_13", (String)"scm-sou-formplugin", (Object[])new Object[0]), currSign), AxisType.value);
            pieChart.setShowTooltip(true);
            pieChart.bindData((BindingContext)null);
        }
    }

    private void setBidStatus(DynamicObject quoBidBill) {
        String bidStatus = quoBidBill.getString("bidstatus");
        BidStatusEnum bidStatusEnum = BidStatusEnum.fromVal((String)bidStatus);
        Label bidStatusLable = (Label)this.getView().getControl("bidstatus");
        bidStatusLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\uff1a{0}", (String)"SouBidHallPlugin_14", (String)"scm-sou-formplugin", (Object[])new Object[0]), bidStatusEnum.getName()));
        this.getModel().setValue("bidstatusval", (Object)bidStatus);
        IFormView view = this.getView();
        if (bidStatusEnum.equals((Object)BidStatusEnum.BIDDING)) {
            view.setVisible(Boolean.FALSE, new String[]{"tblstart"});
            view.setVisible(Boolean.TRUE, new String[]{"tblterminate"});
        } else if (bidStatusEnum.equals((Object)BidStatusEnum.PAUSED)) {
            view.setVisible(Boolean.TRUE, new String[]{"tblstart"});
            view.setVisible(Boolean.TRUE, new String[]{"tblterminate"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tblstart"});
            view.setVisible(Boolean.FALSE, new String[]{"tblterminate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "viewall": {
                this.viewAllQuo();
                break;
            }
            case "dealexception": {
                this.dealException();
                break;
            }
            case "refresh": {
                this.refresh();
                break;
            }
            case "bidstart": {
                this.bidStart();
                break;
            }
        }
    }

    private void viewAllQuo() {
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        Map paramMap = parameter.getCustomParams();
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_quoteview", (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, VIEWALL), (ShowType)ShowType.Modal));
    }

    private void dealException() {
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        Map paramMap = parameter.getCustomParams();
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_exception", (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, DEALEXCEPTION), (ShowType)ShowType.Modal));
    }

    private void bidStart() {
        DynamicObject bidBill = this.getSouBidBill();
        if (bidBill != null) {
            String bidStatus = bidBill.getString("bidStatus");
            if (!bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u662f\u6682\u505c\u72b6\u6001\u7684\u65e0\u9700\u542f\u52a8\u3002", (String)"SouBidHallPlugin_15", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return;
            }
            bidBill.set("bidstatus", (Object)BidStatusEnum.BIDDING.getVal());
            bidBill.set("pausestarttime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((IDataEntityType)bidBill.getDataEntityType(), (Object[])new Object[]{bidBill});
            this.setBidStatus(bidBill);
            this.setRestOfTime(bidBill);
        }
    }

    private void refresh() {
        DynamicObject bidBill = this.getSouBidBill();
        if (null != bidBill) {
            this.setBidStatus(bidBill);
            this.setRestOfTime(bidBill);
            this.setSupQuoInfo(bidBill);
            this.setTendencyChartData(bidBill);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "dealexception": {
                this.refresh();
                break;
            }
            case "viewall": {
                break;
            }
        }
    }

    protected void setAutoRefreshTime(int second) {
        CountDown autorefresh_cd = (CountDown)this.getControl("autorefresh_cd");
        autorefresh_cd.setDuration(second);
    }
}

