/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SouSupScopeEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.service.ExcelDataEntityServiceImp;
import kd.scm.common.service.IExcelDataEntityService;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ExchangeCurrUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.sou.common.SouCompareBillUtil;
import kd.scm.sou.common.SouInquiryUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.common.WriteBackUtil;
import kd.scm.sou.formplugin.AbstractSouCompareBatchPlugin;
import kd.scm.sou.formplugin.SouCompareBatchImportPlugin;
import kd.scm.sou.formplugin.SouToolBatchDataSheetHandler;
import kd.scm.sou.formplugin.ext.AdoptionHelper;
import kd.scm.sou.formplugin.ext.AdoptionModel;
import kd.scm.sou.formplugin.ext.imp.DefaultSouCompareAssistantRecentPriceSource;
import kd.scm.sou.formplugin.ext.imp.DefaultSouCompareToolSupColumn;
import kd.scm.sou.formplugin.service.ISouCompareAssistantBatchService;
import kd.scm.sou.formplugin.service.impl.DefaultSouCompareAssistantBatchService;
import kd.scm.sou.service.ISouGroupParamerterService;
import kd.scm.sou.service.SouGroupParamerterServiceImp;
import kd.sdk.scm.sou.entity.SouCompareAssiRecentPriceArgs;
import kd.sdk.scm.sou.extpoint.ISouCompareAssistantRecentPriceSource;
import kd.sdk.scm.sou.extpoint.ISouCompareToolSupColumn;
import org.apache.poi.util.StringUtil;

public class SouCompareAssistantBatchPlugin
extends AbstractSouCompareBatchPlugin
implements HyperLinkClickListener,
TreeNodeClickListener,
RowClickEventListener,
UploadListener {
    private static Log log = LogFactory.getLog(SouCompareAssistantBatchPlugin.class);
    private AdoptionModel adoptionModel = null;
    private Map<String, BigDecimal[]> adoptQuoteInfoMap = new HashMap<String, BigDecimal[]>();
    private static Map<String, String> billnoEntryMap = new HashMap<String, String>(4);
    private static Map<String, String> billnoIdMap = new HashMap<String, String>(4);
    private static final String QUOQUERY = "quoquery";
    private static final String CONFIRMCOMPARE_ACTIONID = "confirmCompareActionId";
    private static final String INQUIRY_ENTRYTITY = "inquiry_entry";
    private static final String INQUIRY_ENTRYTITY_SUFFIX = "1";
    private static final String QUOTE_ENTRYTITY = "quote_entry";
    private static final String QUOTE_ENTRYTITY_SUFFIX = "2";
    private static final String QUOTESUM_ENTRYTITY = "quohead_entry";
    private static final String QUOTESUM_ENTRYTITY_SUFFIX = "4";
    private static final String RECENTLY_ENTRYTITY = "recentprice_entry";
    private static final String COMPARE_ENTRYTITY = "compareprice_entry";
    private static final String RECENTLY_ENTRYTITY_SUFFIX = "3";
    private static final String IS_TREE_NODE_CLICK = "isTreeNodeClick";
    private static final String RESULT = "result";
    private static final String CFMTAXRATE = "cfmtaxrate";
    private static final String CFMTAXRATEID = "cfmtaxrateid";
    private static final String CFMTAXPRICE = "cfmtaxprice";
    private static final String CFMPRICE = "cfmprice";
    private static final String CFMQTY = "cfmqty";
    private static final String CFMAMOUNT = "cfmamount";
    private static final String CFMTAXAMOUNT = "cfmtaxamount";
    private static final String INQUIRY_NO = "inquiryno";
    private static final String EX_RATE = "exrate";
    private static final String ENTRY_QUOTATION = "entryquotation";
    private static final String EXCLUDE_UNIT_TAX = "excludeunittax";
    private static final String INCLUDE_UNIT_TAX = "includeunittax";
    private static final int TOP = 10;
    private static final String[] KEYS = new String[]{"fromdate", "enddate", "org", "inquiryno"};
    private List<Long> quoEntryIdList = new ArrayList<Long>();
    private Map<String, BigDecimal> quoEntryId_CompareQty = new HashMap<String, BigDecimal>();
    private boolean isNeedChange = true;

    private String getMsgCancleEditNewAdmin() {
        return ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SouCompareAssistantBatchPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid inquiryGrid = (EntryGrid)this.getView().getControl(INQUIRY_ENTRYTITY);
        inquiryGrid.addRowClickListener((RowClickEventListener)this);
        inquiryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid quoteGrid = (EntryGrid)this.getView().getControl(QUOTE_ENTRYTITY);
        quoteGrid.addRowClickListener((RowClickEventListener)this);
        quoteGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid headGrid = (EntryGrid)this.getView().getControl(QUOTESUM_ENTRYTITY);
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid compareGrid = (EntryGrid)this.getView().getControl(COMPARE_ENTRYTITY);
        compareGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid recentlyGrid = (EntryGrid)this.getView().getControl(RECENTLY_ENTRYTITY);
        recentlyGrid.addHyperClickListener((HyperLinkClickListener)this);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        if (toolBar != null) {
            toolBar.addUploadListener((UploadListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter;
        Map param;
        Object inquiryno;
        super.afterCreateNewData(e);
        String isNode = this.getPageCache().get(IS_TREE_NODE_CLICK);
        if (null == isNode || "0".equals(isNode)) {
            this.initAllTreeNodes();
        }
        if ((inquiryno = (param = (parameter = this.getView().getFormShowParameter()).getCustomParams()).get(INQUIRY_NO)) != null) {
            this.allotDynamicData(inquiryno.toString());
        }
    }

    @Override
    protected void setAdoptRuleItem() {
        Boolean adoptRule = (Boolean)this.getModel().getValue("totalinquiry");
        this.getView().setVisible(adoptRule, new String[]{"adopttaxamount", "adoptamount"});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "tocompare": {
                this.verifyCfmQty(args);
                break;
            }
        }
    }

    private void verifyCfmQty(BeforeDoOperationEventArgs args) {
        if (QUOTE_ENTRYTITY_SUFFIX.equals(this.getModel().getValue("controlqty"))) {
            DynamicObject entity = this.getModel().getDataEntity(true);
            DynamicObjectCollection inquiry_entry = entity.getDynamicObjectCollection(INQUIRY_ENTRYTITY);
            ArrayList<String> seq_materialNoList = new ArrayList<String>();
            for (DynamicObject inquiry : inquiry_entry) {
                DynamicObjectCollection quote_entry = inquiry.getDynamicObjectCollection(QUOTE_ENTRYTITY);
                BigDecimal sum = BigDecimal.ZERO;
                for (DynamicObject quote : quote_entry) {
                    BigDecimal cfmqty2 = quote.getBigDecimal("cfmqty2");
                    sum = sum.add(cfmqty2);
                }
                if (sum.compareTo(inquiry.getBigDecimal("qty1")) <= 0) continue;
                String materialNo = inquiry.getDynamicObject("material1").getString("number");
                String seq = inquiry.getString("seq");
                seq_materialNoList.add(seq + "_" + materialNo);
            }
            this.buildCfmQtyErrorMsg(seq_materialNoList);
            if (!seq_materialNoList.isEmpty()) {
                args.setCancel(true);
            }
        }
    }

    private void buildCfmQtyErrorMsg(ArrayList<String> seqmaterialNoList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < seqmaterialNoList.size(); ++i) {
            String seq_materialNo_ = seqmaterialNoList.get(i);
            String[] arr = seq_materialNo_.split("_");
            if (arr.length != 2) continue;
            if (i != 0) {
                stringBuilder.append("\u3001");
            }
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\u7269\u6599", (String)"SouCompareAssistantBatchPlugin_24", (String)"scm-sou-formplugin", (Object[])new Object[0]), arr[0])).append(arr[1]);
            if (i != seqmaterialNoList.size() - 1) continue;
            String message = String.format(ResManager.loadKDString((String)"%s\u7684\u786e\u8ba4\u6570\u91cf\u4e4b\u548c\u4e0d\u80fd\u8d85\u8fc7\u8be2\u4ef7\u6570\u91cf\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SouCompareAssistantBatchPlugin_23", (String)"scm-sou-formplugin", (Object[])new Object[0]), stringBuilder.toString());
            stringBuilder = new StringBuilder(message);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)stringBuilder.toString())) {
            this.getView().showTipNotification(stringBuilder.toString(), Integer.valueOf(10000));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operate = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operate) {
                case "conditionquery": {
                    this.getPageCache().remove("adoptType");
                    HashMap objectMap = new HashMap();
                    FormShowParameter param = BillFormUtil.assembleShowDynamicFormParam((String)"sou_comparequery", objectMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, QUOQUERY), (ShowType)ShowType.NonModal);
                    this.openQuoQuery(param);
                    break;
                }
                case "allbilladopt": {
                    this.toadopt();
                    break;
                }
                case "tocompare": {
                    if (!this.isEffectiveInquiry()) {
                        return;
                    }
                    String inquiryno = String.valueOf(this.getModel().getValue(INQUIRY_NO));
                    DynamicObject[] savedCompareData = SouInquiryUtil.getSavedCompareData((String)inquiryno);
                    if (savedCompareData != null && savedCompareData.length >= 1) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMCOMPARE_ACTIONID, (IFormPlugin)this);
                        String confirmTip = MessageFormat.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355{0}\u5df2\u751f\u6210\u4fdd\u5b58\u7684\u6bd4\u4ef7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouCompareAssistantBatchPlugin_16", (String)"scm-sou-formplugin", (Object[])new Object[0]), inquiryno);
                        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                        return;
                    }
                    this.toCompare();
                    break;
                }
                case "myexport": {
                    this.export();
                    break;
                }
                case "adopttaxprice": 
                case "adoptprice": 
                case "adopttaxamount": 
                case "adoptamount": {
                    if (!this.isEffectiveInquiry()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8be2\u4ef7\u9879\u76ee\uff0c\u4e0d\u652f\u6301\u591a\u4e2a\u8be2\u4ef7\u5355\u540c\u65f6\u4e00\u952e\u91c7\u7eb3\u3002", (String)"SouCompareAssistantBatchPlugin_22", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getPageCache().put("adoptType", operate);
                    this.getPageCache().put(IS_TREE_NODE_CLICK, INQUIRY_ENTRYTITY_SUFFIX);
                    this.allotDynamicData(String.valueOf(this.getModel().getValue(INQUIRY_NO)));
                    break;
                }
            }
        }
    }

    private boolean isEffectiveInquiry() {
        String inquiryno = String.valueOf(this.getModel().getValue(INQUIRY_NO));
        DynamicObject[] compareCol = SouInquiryUtil.getCompareData((String)inquiryno);
        if (kd.bos.util.StringUtils.isEmpty((String)inquiryno)) {
            return false;
        }
        boolean success = true;
        if (compareCol != null && compareCol.length >= 1) {
            String compareBillStatus;
            switch (compareBillStatus = compareCol[0].getString("billstatus")) {
                case "B": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u63d0\u4ea4\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouCompareAssistantBatchPlugin_17", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    success = false;
                    break;
                }
                case "C": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouCompareAssistantBatchPlugin_18", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    success = false;
                    break;
                }
                default: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouCompareAssistantBatchPlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    success = false;
                }
            }
        }
        return success;
    }

    private IExcelDataEntityService getExcelDataEntityService() {
        return new ExcelDataEntityServiceImp();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "quoquery": {
                if (!(returnData instanceof Map)) break;
                Map dataMap = (Map)returnData;
                IPageCache cache = this.getPageCache();
                for (String key : KEYS) {
                    if (null == cache.get(key)) continue;
                    cache.remove(key);
                }
                for (Map.Entry entry : dataMap.entrySet()) {
                    Object val = entry.getValue();
                    cache.put((String)entry.getKey(), null == val ? null : val.toString());
                }
                this.fresh(null);
                break;
            }
            case "allbilladoptid": {
                if (!(returnData instanceof Map)) break;
                Map dataMap = (Map)returnData;
                if (dataMap.size() == 0) {
                    return;
                }
                Object suppid = dataMap.get("suppid");
                this.setAdoptionRows(suppid, null);
                break;
            }
        }
    }

    private void setAdoptionRows(Object suppid, Map<String, Map<String, Object>> dealMap) {
        this.getModel().beginInit();
        boolean importflag = suppid == null;
        EntryGrid inquiryEntry = (EntryGrid)this.getControl(INQUIRY_ENTRYTITY);
        int[] selectRows = inquiryEntry.getSelectRows();
        HashMap<String, BigDecimal[]> midResultMap = new HashMap<String, BigDecimal[]>(16);
        DynamicObjectCollection inquirycols = this.getModel().getEntryEntity(INQUIRY_ENTRYTITY);
        if (selectRows.length > 0) {
            for (int rowindex : selectRows) {
                DynamicObject inquiryobj = (DynamicObject)inquirycols.get(rowindex);
                this.dealAdoptionQuotEntry(suppid, inquiryobj, importflag, dealMap, midResultMap);
            }
        } else {
            for (DynamicObject inquiryobj : inquirycols) {
                this.dealAdoptionQuotEntry(suppid, inquiryobj, importflag, dealMap, midResultMap);
            }
        }
        this.setAdoptInfo(midResultMap);
        this.getModel().endInit();
        this.getView().updateView(QUOTESUM_ENTRYTITY);
        this.getView().updateView(QUOTE_ENTRYTITY);
    }

    private void dealAdoptionQuotEntry(Object suppid, DynamicObject inquiryobj, boolean importflag, Map<String, Map<String, Object>> dealMap, Map<String, BigDecimal[]> midResultMap) {
        DynamicObjectCollection quocols = inquiryobj.getDynamicObjectCollection(QUOTE_ENTRYTITY);
        String taxType = String.valueOf(this.getModel().getValue("taxtype"));
        int scaleNum = 6;
        for (DynamicObject quoobj : quocols) {
            BigDecimal oldcfmamount = quoobj.getBigDecimal("cfmamount2");
            BigDecimal oldcfmtaxamount = quoobj.getBigDecimal("cfmtaxamount2");
            if (!importflag) {
                if (quoobj.getDynamicObject("supplier2") != null && quoobj.getDynamicObject("supplier2").getPkValue().toString().equals(suppid.toString())) {
                    quoobj.set("result2", (Object)INQUIRY_ENTRYTITY_SUFFIX);
                    this.setResult(INQUIRY_ENTRYTITY_SUFFIX, quoobj);
                } else {
                    quoobj.set("result2", (Object)QUOTE_ENTRYTITY_SUFFIX);
                    this.setResult(QUOTE_ENTRYTITY_SUFFIX, quoobj);
                }
            } else {
                Map<String, Object> entryMap = dealMap.get(quoobj.getString("entryid2"));
                if (entryMap != null) {
                    Object result2 = entryMap.get("result2");
                    quoobj.set("note2", entryMap.get("note2"));
                    quoobj.set("result2", entryMap.get("result2"));
                    if (INQUIRY_ENTRYTITY_SUFFIX.equals(result2)) {
                        BigDecimal price;
                        quoobj.set("cfmqty2", entryMap.get("cfmqty2"));
                        BigDecimal cfmTaxRate = (BigDecimal)entryMap.get("cfmtaxrate2");
                        quoobj.set("cfmtaxrate2", entryMap.get("cfmtaxrate2"));
                        quoobj.set("cfmtaxrateid2", entryMap.get("cfmtaxrateid2"));
                        DynamicObject quotecurr = quoobj.getDynamicObject("quotecurr2");
                        BigDecimal bigDecimal = cfmTaxRate = cfmTaxRate == null ? BigDecimal.ZERO : cfmTaxRate.movePointLeft(2);
                        if (quotecurr != null) {
                            scaleNum = quotecurr.getInt("priceprecision");
                        }
                        BigDecimal taxRate = CalConstant.BIGDECIMAL_ONE.add(cfmTaxRate);
                        BigDecimal imortPrice = null;
                        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
                            price = (BigDecimal)entryMap.get("cfmtaxprice2");
                            imortPrice = price.divide(taxRate, scaleNum, RoundingMode.HALF_UP);
                            quoobj.set("cfmprice2", (Object)imortPrice);
                            quoobj.set("cfmtaxprice2", (Object)price);
                        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                            price = (BigDecimal)entryMap.get("cfmprice2");
                            imortPrice = price.multiply(taxRate).setScale(scaleNum, RoundingMode.HALF_UP);
                            quoobj.set("cfmtaxprice2", (Object)imortPrice);
                            quoobj.set("cfmprice2", (Object)price);
                        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                            taxRate = CalConstant.BIGDECIMAL_ONE.subtract(cfmTaxRate);
                            price = (BigDecimal)entryMap.get("cfmtaxprice2");
                            imortPrice = price.multiply(taxRate).setScale(scaleNum, RoundingMode.HALF_UP);
                            quoobj.set("cfmprice2", (Object)imortPrice);
                            quoobj.set("cfmtaxprice2", (Object)price);
                        }
                        this.setResult(String.valueOf(quoobj.get("result2")), quoobj, false);
                    } else {
                        this.setResult(String.valueOf(quoobj.get("result2")), quoobj, true);
                    }
                }
            }
            BigDecimal newcfmamount = quoobj.getBigDecimal("cfmamount2");
            BigDecimal newcfmtaxamount = quoobj.getBigDecimal("cfmtaxamount2");
            this.preDealAdoptInfo(midResultMap, "cfmamount2", oldcfmamount, newcfmamount, quoobj);
            this.preDealAdoptInfo(midResultMap, "cfmtaxamount2", oldcfmtaxamount, newcfmtaxamount, quoobj);
        }
    }

    private void fresh(String billno) {
        IPageCache cache = this.getPageCache();
        cache.put(IS_TREE_NODE_CLICK, "0");
        this.openData();
        this.allotDynamicData(billno);
    }

    protected void preDealAdoptInfo(Map<String, BigDecimal[]> adoptMapInfo, String key, BigDecimal oldValue, BigDecimal newValue, DynamicObject rowInfo) {
        BigDecimal[] valueInfos;
        String billno = rowInfo.getString("billno2");
        int scale = rowInfo.getInt("curr2.amtprecision");
        BigDecimal exRate = rowInfo.getBigDecimal("exrate2");
        if (exRate == null) {
            exRate = BigDecimal.ONE;
        }
        if ((valueInfos = adoptMapInfo.get(billno)) == null) {
            valueInfos = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
            adoptMapInfo.put(billno, valueInfos);
        }
        BigDecimal prevValue = null;
        prevValue = "cfmamount2".equals(key) ? valueInfos[0] : valueInfos[1];
        String entryQuotation = rowInfo.getString("entryquotation2");
        if (oldValue != null) {
            prevValue = prevValue.subtract(MultCurrencyCalImpl.convertByExrate((BigDecimal)oldValue, (BigDecimal)exRate, (int)scale, (String)entryQuotation));
        }
        if (newValue != null) {
            prevValue = prevValue.add(MultCurrencyCalImpl.convertByExrate((BigDecimal)newValue, (BigDecimal)exRate, (int)scale, (String)entryQuotation));
        }
        if ("cfmamount2".equals(key)) {
            valueInfos[0] = prevValue;
        } else {
            valueInfos[1] = prevValue;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CONFIRMCOMPARE_ACTIONID, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.toCompare();
        }
    }

    protected void setResult(String result, DynamicObject obj) {
        this.setResult(result, obj, true);
    }

    protected void setResult(String result, DynamicObject obj, boolean flag) {
        DynamicObject curr1 = (DynamicObject)this.getModel().getValue("curr");
        int settleScale = 6;
        if (curr1 != null && curr1.getDynamicObjectType().getProperty("priceprecision") != null) {
            settleScale = curr1.getInt("priceprecision");
        }
        if (INQUIRY_ENTRYTITY_SUFFIX.equals(result)) {
            String taxType = String.valueOf(this.getModel().getValue("taxtype"));
            int scale = 6;
            DynamicObject curr = obj.getDynamicObject("quotecurr2");
            if (curr != null && curr.getDynamicObjectType().getProperty("amtprecision") != null) {
                scale = curr.getInt("amtprecision");
            }
            if (flag) {
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)obj.get("qty2"));
                BigDecimal price = CommonUtil.getBigDecimalPro((Object)obj.get("price2"));
                BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)obj.get("taxprice2"));
                BigDecimal taxRate = CommonUtil.getBigDecimalPro((Object)obj.get("taxrate2"));
                Object taxRateId = obj.get("taxrateid2");
                obj.set("cfmprice2", (Object)price);
                obj.set("cfmtaxprice2", (Object)taxPrice);
                obj.set("cfmtaxrate2", (Object)taxRate);
                obj.set("cfmtaxrateid2", taxRateId);
                obj.set("cfmqty2", (Object)qty);
            }
            BigDecimal exRate = obj.getBigDecimal("exrate2");
            String entryquotation = obj.getString("entryquotation2");
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("qty", "cfmqty2");
            propMap.put("taxrate", "cfmtaxrate2");
            propMap.put("taxprice", "cfmtaxprice2");
            propMap.put("price", "cfmprice2");
            obj.set("cfmamount2", (Object)MultCurrencyCalImpl.calAmount((DynamicObject)obj, (String)taxType, propMap, (int)scale));
            obj.set("cfmtaxamount2", (Object)MultCurrencyCalImpl.calTaxAmount((DynamicObject)obj, (String)taxType, propMap, (int)scale));
            obj.set("excludeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)obj.getBigDecimal("cfmprice2"), (BigDecimal)exRate, (int)settleScale, (String)entryquotation));
            obj.set("includeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)obj.getBigDecimal("cfmtaxprice2"), (BigDecimal)exRate, (int)settleScale, (String)entryquotation));
        } else if (QUOTE_ENTRYTITY_SUFFIX.equals(result)) {
            obj.set("cfmprice2", (Object)0);
            obj.set("cfmtaxprice2", (Object)0);
            obj.set("cfmtaxrate2", (Object)0);
            obj.set("cfmqty2", (Object)0);
            obj.set("cfmamount2", (Object)0);
            obj.set("cfmtaxamount2", (Object)0);
            obj.set("cfmtaxrateid2", null);
            obj.set("excludeunittax2", (Object)0);
            obj.set("includeunittax2", (Object)0);
        }
    }

    private void openData() {
        Map<String, Map<String, Object>> quiryParams = this.getQuiryMap();
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_inquiry", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_inquiry", (String)"entryentity", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_inquiry", (String)"materialentry", (boolean)false);
        DynamicObject[] billColl = ORMUtil.load((String)"sou_inquiry", (String)selectFields, quiryParams);
        HashSet<String> inQuiry = new HashSet<String>();
        DynamicObject quiry = null;
        DynamicObject quote = null;
        DynamicObjectCollection quiryEntry = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int i = 0; i < billColl.length; ++i) {
            quiry = billColl[i];
            quiryEntry = quiry.getDynamicObjectCollection("entryentity");
            quiry.set("bizstatus", (Object)"B");
            if (quiryEntry == null || quiryEntry.size() <= 0) continue;
            inQuiry.add(quiry.getString("billno"));
            indexSet.add(i);
        }
        DynamicObject[] newBillColl = new DynamicObject[indexSet.size()];
        int count = 0;
        Iterator iterator = indexSet.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            newBillColl[count] = billColl[index];
            ++count;
        }
        DynamicObject[] quoteColl = InquiryUtil.getQuoteBillByInquiryBillNo(new ArrayList(inQuiry));
        if (quoteColl != null) {
            for (int i = 0; i < quoteColl.length; ++i) {
                quote = quoteColl[i];
                quote.set("bizstatus", (Object)"B");
            }
        }
        if (newBillColl.length > 0 && quoteColl != null && quoteColl.length > 0) {
            InquiryUtil.updateInquiryBill((DynamicObject[])newBillColl, (DynamicObject[])quoteColl);
            this.updateQuoteBill(quoteColl);
            SaveServiceHelper.save((DynamicObject[])newBillColl);
            SaveServiceHelper.save((DynamicObject[])quoteColl);
        }
    }

    private void updateQuoteBill(DynamicObject[] quoteBillObjs) {
        if (quoteBillObjs.length == 0) {
            return;
        }
        for (DynamicObject quoteBill : quoteBillObjs) {
            quoteBill.set("bizstatus", (Object)BizStatusEnum.OPENEDTHEBID.getVal());
        }
        SaveServiceHelper.save((IDataEntityType)quoteBillObjs[0].getDynamicObjectType(), (Object[])quoteBillObjs);
    }

    private Map<String, Map<String, Object>> getQuiryMap() {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        HashMap<String, Date> dateMap = new HashMap<String, Date>(1);
        HashMap<String, String> opentypeMap = new HashMap<String, String>(1);
        HashMap<String, String> bizstatusMap = new HashMap<String, String>(1);
        HashMap<String, String> billstatusMap = new HashMap<String, String>(1);
        dateMap.put("<", TimeServiceHelper.now());
        opentypeMap.put("=", INQUIRY_ENTRYTITY_SUFFIX);
        bizstatusMap.put("=", "A");
        billstatusMap.put("=", "C");
        params.put("enddate", dateMap);
        params.put("opentype", opentypeMap);
        params.put("bizstatus", bizstatusMap);
        params.put("billstatus", billstatusMap);
        return params;
    }

    private void openQuoQuery(FormShowParameter param) {
        this.getView().showForm(param);
    }

    protected void toadopt() {
        String inquiryNo = this.getModel().getValue(INQUIRY_NO).toString();
        if (null == inquiryNo || "".equals(inquiryNo.trim())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be2\u4ef7\u5355\u53f7\u3002", (String)"SouCompareAssistantBatchPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        if (!this.validatePerm(inquiryNo)) {
            return;
        }
        DynamicObject[] compareCol = SouInquiryUtil.getCompareData((String)inquiryNo);
        if (compareCol != null && compareCol.length >= 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouCompareAssistantBatchPlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openDealPage("sou_allbilladopt", "allbilladoptid", ShowType.NonModal);
    }

    protected boolean validatePerm(String inquiryNo) {
        DynamicObjectCollection selectDatas = QueryServiceHelper.query((String)"sou_inquiry", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)inquiryNo)});
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (selectDatas.size() > 0) {
            String errMsg;
            if (!SouPermUtil.hasSouBillViewRightForOrg((Long)((DynamicObject)selectDatas.get(0)).getLong("id"), (String)"sou_inquiry", (String)"sou_inquiry")) {
                errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8be2\u4ef7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouCompareAssistantBatchPlugin_14", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            }
            if (!SouPermUtil.hasSouBillViewRightForOrg((Long)((DynamicObject)selectDatas.get(0)).getLong("id"), (String)"sou_inquiry", (String)"sou_quote")) {
                errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u62a5\u4ef7\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouCompareAssistantBatchPlugin_15", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            }
            if (!(errMsg = String.join((CharSequence)"\uff0c", errMsgList)).isEmpty()) {
                this.getView().showErrorNotification(errMsg);
                return false;
            }
        }
        return true;
    }

    private void openDealPage(String pageKey, String actionId, ShowType showType) {
        DynamicObjectCollection inquiryCols = this.getModel().getEntryEntity(INQUIRY_ENTRYTITY);
        EntryGrid inquiryEntry = (EntryGrid)this.getControl(INQUIRY_ENTRYTITY);
        int[] selectRows = inquiryEntry.getSelectRows();
        ArrayList<Integer> selectRowList = new ArrayList<Integer>(selectRows.length);
        for (int selectRow : selectRows) {
            if (selectRow == inquiryCols.size() - 1) continue;
            selectRowList.add(selectRow);
        }
        if (selectRowList.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6709\u6548\u7269\u6599\u884c\u3002", (String)"SouCompareAssistantBatchPlugin_20", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Integer> srcEntryIdMap = new HashMap<String, Integer>(selectRowList.size());
        for (Integer rowIndex : selectRowList) {
            String srcEntryId = ((DynamicObject)inquiryCols.get(rowIndex.intValue())).getString("srcentryid1");
            if (rowIndex.intValue() == inquiryCols.size() || srcEntryId == null || "".equals(srcEntryId)) continue;
            srcEntryIdMap.put(srcEntryId, rowIndex);
        }
        String inquiryNo = this.getModel().getValue(INQUIRY_NO).toString();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject inquiryObj = this.getInquiryObjByBillNo(inquiryNo);
        Map<String, Object> dataMap = this.getQuoteByInquiry(inquiryNo);
        DynamicObjectCollection quoteCollections = null;
        DynamicObjectCollection quoteSupCollections = null;
        if (null != dataMap.get("quote")) {
            quoteCollections = (DynamicObjectCollection)dataMap.get("quote");
        }
        if (null != dataMap.get("supplier")) {
            quoteSupCollections = (DynamicObjectCollection)dataMap.get("supplier");
        }
        HashMap<String, DynamicObjectCollection> quoMap = new HashMap<String, DynamicObjectCollection>();
        quoMap.put("quote", quoteCollections);
        quoMap.put("supplier", quoteSupCollections);
        paramMap.put("quomap", quoMap);
        paramMap.put("inquirytitle", inquiryObj.getString("inquirytitle"));
        paramMap.put(INQUIRY_NO, inquiryNo);
        paramMap.put("billDate", inquiryObj.getDate("billdate"));
        paramMap.put("srcentryid", srcEntryIdMap);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)showType));
    }

    protected void toCompare() {
        Object inquiryNo = this.getModel().getValue(INQUIRY_NO);
        if (null == inquiryNo || "".equals(inquiryNo.toString())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be2\u4ef7\u5355\u53f7\u3002", (String)"SouCompareAssistantBatchPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        if (!this.validatePerm(String.valueOf(inquiryNo))) {
            return;
        }
        String inquiryNoStr = inquiryNo.toString();
        DynamicObjectCollection selectDatas = QueryServiceHelper.query((String)"sou_inquiry", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)inquiryNoStr)});
        if (selectDatas.size() <= 0 || !SouPermUtil.hasSouBillViewRightForOrg((Long)((DynamicObject)selectDatas.get(0)).getLong("id"), (String)"sou_inquiry", (String)"sou_compare")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6bd4\u4ef7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouCompareAssistantBatchPlugin_13", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        this.adoptionModel = new AdoptionModel("sou_comparetool", this.getModel().getDataEntity(true));
        Object[] objs = this.adoptionModel.toTargetBill(inquiryNoStr, null, this);
        if (objs.length > 0) {
            this.openComparePage(objs);
            this.writeBackQuoData();
            this.getPageCache().remove(INQUIRY_NO);
            this.getPageCache().remove(IS_TREE_NODE_CLICK);
            this.allotDynamicData("");
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u5f20\u8be2\u4ef7\u5355\u3002", (String)"SouCompareAssistantBatchPlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        }
    }

    public void setQuoEntry(DynamicObject billObj) {
        this.setQuoEntry(billObj, 1);
    }

    private List<String> getValideInquirno(List<String> inquiryNoList) {
        ArrayList<String> status = new ArrayList<String>(2);
        status.add(BillStatusEnum.SUBMIT.getVal());
        status.add(BillStatusEnum.AUDIT.getVal());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"sou_compare", (String)INQUIRY_NO, (QFilter[])new QFilter[]{new QFilter(INQUIRY_NO, "in", inquiryNoList).and("billstatus", "in", status)}, (String)"id");){
            dataSet.forEach(row -> {
                String inquiryno = row.getString(INQUIRY_NO);
                inquiryNoList.removeIf(billno -> billno.equals(inquiryno));
            });
        }
        return inquiryNoList;
    }

    public DynamicObject createCompareBillHead(DynamicObject inquiry) {
        return this.createCompareBillHead(inquiry, null);
    }

    @Override
    public void createCompareQuoEntry(DynamicObject billObj, String entryKey) {
        this.createCompareQuoEntry(billObj, entryKey, this.getModel().getValue(INQUIRY_NO), 1);
    }

    @Override
    public void createCompareBillEntry(DynamicObject billObj, String entryKey) {
        this.createCompareBillEntry(billObj, entryKey, 1);
    }

    @Override
    public void createCompareBillEntry(DynamicObject billObj, String entryKey, int source) {
        if (this.adoptionModel != null) {
            this.adoptionModel.createCompareBillEntry(billObj, entryKey, this, source);
        }
    }

    private void openComparePage(Object[] objs) {
        if (objs == null) {
            return;
        }
        if (objs.length <= 1) {
            BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)"sou_compare", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)((Long)((DynamicObject)objs[0]).getPkValue()), null, null);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void writeBackQuoData() {
        HashMap writeBackProMap = new HashMap();
        ArrayList<String> proList = new ArrayList<String>();
        proList.add("sumcompareqty");
        writeBackProMap.put("materialentry", proList);
        WriteBackUtil.writeBackBill((String)"sou_quote", writeBackProMap, this.quoEntryIdList, this.quoEntryId_CompareQty, (String)"audit");
    }

    protected String getInquiryKey(DynamicObject obj) {
        StringBuilder inquiryKeySb = new StringBuilder();
        inquiryKeySb.append(obj.getString(INQUIRY_NO)).append('_').append(obj.get("srcentryid"));
        return inquiryKeySb.toString();
    }

    @Override
    protected void deleteViewEntry() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entity = dataModel.getEntryEntity(QUOTE_ENTRYTITY);
        if (entity != null) {
            dataModel.deleteEntryData(QUOTE_ENTRYTITY);
            dataModel.deleteEntryData(QUOTESUM_ENTRYTITY);
            dataModel.deleteEntryData(RECENTLY_ENTRYTITY);
            dataModel.deleteEntryData(COMPARE_ENTRYTITY);
            dataModel.deleteEntryData(INQUIRY_ENTRYTITY);
        }
        Container inquirybaseContainer = (Container)this.getControl("inquirybasepanel");
        Container inquiryquoContainer = (Container)this.getControl("inquiryquopanel");
        List inquirybaseList = DynamicObjectUtil.getContainerProperties((Container)inquirybaseContainer);
        for (int i = 0; i < inquirybaseList.size(); ++i) {
            IDataEntityProperty property = dataModel.getProperty((String)inquirybaseList.get(i));
            if (property == null) continue;
            dataModel.setValue((String)inquirybaseList.get(i), null);
        }
        List inquiryquoList = DynamicObjectUtil.getContainerProperties((Container)inquiryquoContainer);
        for (int i = 0; i < inquiryquoList.size(); ++i) {
            IDataEntityProperty property = dataModel.getProperty((String)inquiryquoList.get(i));
            if (property == null) continue;
            dataModel.setValue((String)inquiryquoList.get(i), null);
        }
    }

    @Override
    protected Map<String, Object> getQuoteByInquiry(String inquiryNo) {
        Map<String, Map<String, Object>> quoParams = this.buildCondition();
        quoParams.putAll(AdoptionHelper.getQuoteDefaultParam(inquiryNo));
        String orderBys = "materialentry.srcentryid asc";
        return this.getQuoteByInquiryFromDB("sou_quote", quoParams, orderBys);
    }

    protected Map<String, Object> getQuoteByInquiryFromDB(String entityName, Map<String, Map<String, Object>> params, String orderBys) {
        Map<String, Object> map;
        String adoptType = this.getPageCache().get("adoptType");
        this.adoptionModel = new AdoptionModel("sou_comparetool", this.getModel().getDataEntity(true));
        if (params != null && (map = params.get(INQUIRY_NO)) != null) {
            DynamicObject bill;
            String inquiryNo = String.valueOf(map.get("="));
            if (kd.bos.util.StringUtils.isEmpty((String)adoptType) && kd.bos.util.StringUtils.isNotEmpty((String)inquiryNo) && (bill = QueryServiceHelper.queryOne((String)"sou_inquiry", (String)"adoptrule", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)inquiryNo)})) != null) {
                adoptType = this.adoptionModel.getRule().getRule(bill.getString("adoptrule"));
                this.getPageCache().put("adoptType", adoptType);
            }
        }
        this.adoptionModel.initDataSource(entityName, params, orderBys, this.getQuoteInfoBlackMap(), adoptType);
        return this.adoptionModel.getData();
    }

    private Map<String, String> buildEntrySupColumns(DynamicObjectCollection quoteSupCollections, List<String> supColumnInfo) {
        HashMap<String, String> supColumnNameMap = new HashMap<String, String>(8);
        HashMap<String, String> supColumnRelation = new HashMap<String, String>(8);
        DynamicObjectCollection specifiedSupCol = null;
        String supscope = (String)this.getModel().getValue("supscope");
        if (SouSupScopeEnum.SPECIFIED.getVal().equals(supscope)) {
            QFilter billnoFilter = new QFilter("billno", "=", this.getModel().getValue(INQUIRY_NO));
            specifiedSupCol = QueryServiceHelper.query((String)"sou_inquiry", (String)"entryentity.supplier.id,entryentity.supplier.name", (QFilter[])new QFilter[]{billnoFilter}, null);
        }
        EntryGrid inquiryGrid = (EntryGrid)this.getView().getControl(INQUIRY_ENTRYTITY);
        if (supColumnInfo != null) {
            int i = 0;
            for (String supColumn : supColumnInfo) {
                String columnName = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"SouCompareAssistantBatchPlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0]);
                String simpleName = "";
                if (i < quoteSupCollections.size()) {
                    DynamicObject quoteSup = (DynamicObject)quoteSupCollections.get(i);
                    simpleName = quoteSup.getString("supplierName");
                    if (simpleName != null && !simpleName.trim().isEmpty()) {
                        columnName = simpleName;
                        supColumnNameMap.put(supColumn, columnName);
                    }
                    supColumnRelation.put(supColumn, quoteSup.getString("supplier"));
                    LocaleString localStr = new LocaleString(columnName);
                    inquiryGrid.setColumnProperty(supColumn, "header", (Object)localStr);
                    inquiryGrid.setColumnProperty(supColumn, "text-align", (Object)"left");
                    this.getView().setVisible(Boolean.TRUE, new String[]{supColumn});
                } else if (null != specifiedSupCol && SouSupScopeEnum.SPECIFIED.getVal().equals(supscope)) {
                    for (DynamicObject specifiedSup : specifiedSupCol) {
                        String specifiedSupId = specifiedSup.getString("entryentity.supplier.id");
                        if (supColumnRelation.values().contains(specifiedSupId)) continue;
                        supColumnRelation.put(supColumn, specifiedSup.getString("entryentity.supplier.id"));
                        columnName = specifiedSup.getString("entryentity.supplier.name");
                        supColumnNameMap.put(supColumn, columnName);
                        LocaleString localStr = new LocaleString(columnName);
                        inquiryGrid.setColumnProperty(supColumn, "header", (Object)localStr);
                        inquiryGrid.setColumnProperty(supColumn, "text-align", (Object)"left");
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{supColumn});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{supColumn});
                }
                ++i;
            }
        }
        if (!supColumnNameMap.isEmpty()) {
            this.getPageCache().put(supColumnNameMap);
        }
        return supColumnRelation;
    }

    protected void buildQuoHeadData(DynamicObjectCollection quoteCollections) {
        this.buildEntryData(quoteCollections, QUOTESUM_ENTRYTITY, QUOTESUM_ENTRYTITY_SUFFIX);
    }

    protected void buildInquirySumColums(Map<String, String> supColumnRelation, List<String> supColumns) {
        IDataModel model = this.getModel();
        DefaultSouCompareToolSupColumn plugin = new DefaultSouCompareToolSupColumn();
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouCompareToolSupColumn.class, (String)"SCM_SOU_COMPARETOOL_SUPCOLUMN", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.buildInquirySumColumns(model, this.getMsgCancleEditNewAdmin(), supColumnRelation, supColumns);
            return null;
        });
    }

    @Override
    protected void buildHisMinPriceData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection inquiryEntryCols = model.getEntryEntity(INQUIRY_ENTRYTITY);
        ISouCompareAssistantBatchService souCompareAssistantBatchService = this.getSouCompareAssistantService();
        String monthnumStr = this.getPageCache().get("monthnum");
        int monthnum = -1;
        if (!kd.bos.util.StringUtils.isEmpty((String)monthnumStr)) {
            monthnum = Integer.parseInt(monthnumStr);
        }
        Map<String, BigDecimal> mat_priceMap = souCompareAssistantBatchService.getMinPrice(this.getModel(), monthnum);
        for (int i = 0; i < inquiryEntryCols.size(); ++i) {
            Object material = model.getValue("material1", i);
            if (null == material || !(material instanceof DynamicObject)) continue;
            String materialId = ((DynamicObject)material).getPkValue().toString();
            boolean isdisposable = ((DynamicObject)material).getBoolean("isdisposable");
            if (isdisposable) continue;
            model.setValue("hisminprice", (Object)mat_priceMap.get(materialId), i);
        }
    }

    protected ISouCompareAssistantBatchService getSouCompareAssistantService() {
        return new DefaultSouCompareAssistantBatchService();
    }

    @Override
    protected void buildLastComparePriceData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection inquiryEntryCols = model.getEntryEntity(INQUIRY_ENTRYTITY);
        ISouCompareAssistantBatchService souCompareAssistantBatchService = this.getSouCompareAssistantService();
        String monthnumStr = this.getPageCache().get("monthnum");
        int monthnum = -1;
        if (!kd.bos.util.StringUtils.isEmpty((String)monthnumStr)) {
            monthnum = Integer.parseInt(monthnumStr);
        }
        try {
            Map<String, String> mat_billIdComparePriceMap = souCompareAssistantBatchService.getLastComparePrice(this.getModel(), monthnum);
            for (int i = 0; i < inquiryEntryCols.size(); ++i) {
                Object material = model.getValue("material1", i);
                if (null == material || !(material instanceof DynamicObject)) continue;
                String materialId = ((DynamicObject)material).getPkValue().toString();
                DynamicObject purorg = (DynamicObject)model.getValue("purorg");
                String purorgId = purorg == null ? "0" : purorg.getString("id");
                String billId_priceStr = mat_billIdComparePriceMap.get(purorgId + "_" + materialId);
                if (kd.bos.util.StringUtils.isEmpty((String)billId_priceStr) || "0".equals(purorgId)) {
                    Iterator<Map.Entry<String, String>> iterator = mat_billIdComparePriceMap.entrySet().iterator();
                    Map.Entry<String, String> tail = null;
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> temp = iterator.next();
                        if (!materialId.equals(temp.getKey().split("_")[1])) continue;
                        tail = temp;
                    }
                    if (tail != null) {
                        billId_priceStr = (String)tail.getValue();
                    }
                }
                if (kd.bos.util.StringUtils.isEmpty((String)billId_priceStr) || billId_priceStr.split("_").length != 2) continue;
                String[] billId_price = billId_priceStr.split("_");
                model.setValue("lastcompareprice", (Object)(kd.bos.util.StringUtils.isEmpty((String)billId_price[1]) ? null : new BigDecimal(billId_price[1])), i);
                model.setValue("lastcompareid", (Object)billId_price[0], i);
            }
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected void buildLastBidPriceData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection inquiryEntryCols = model.getEntryEntity(INQUIRY_ENTRYTITY);
        ISouCompareAssistantBatchService souCompareAssistantBatchService = this.getSouCompareAssistantService();
        String monthnumStr = this.getPageCache().get("monthnum");
        int monthnum = -1;
        if (!kd.bos.util.StringUtils.isEmpty((String)monthnumStr)) {
            monthnum = Integer.parseInt(monthnumStr);
        }
        try {
            Map<String, String> mat_billIdComparePriceMap = souCompareAssistantBatchService.getLastComparePrice(this.getModel(), monthnum);
            for (int i = 0; i < inquiryEntryCols.size(); ++i) {
                Object material = model.getValue("material1", i);
                if (null == material || !(material instanceof DynamicObject)) continue;
                String materialId = ((DynamicObject)material).getPkValue().toString();
                DynamicObject purorg = (DynamicObject)model.getValue("purorg");
                String purorgId = purorg == null ? "0" : purorg.getString("id");
                String billId_priceStr = mat_billIdComparePriceMap.get(purorgId + "_" + materialId);
                if (kd.bos.util.StringUtils.isEmpty((String)billId_priceStr) || "0".equals(purorgId)) {
                    Iterator<Map.Entry<String, String>> iterator = mat_billIdComparePriceMap.entrySet().iterator();
                    Map.Entry<String, String> tail = null;
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> temp = iterator.next();
                        if (!materialId.equals(temp.getKey().split("_")[1])) continue;
                        tail = temp;
                    }
                    if (tail != null) {
                        billId_priceStr = (String)tail.getValue();
                    }
                }
                if (kd.bos.util.StringUtils.isEmpty((String)billId_priceStr) || billId_priceStr.split("_").length != 2) continue;
                String[] billId_price = billId_priceStr.split("_");
                model.setValue("lastcompareprice", (Object)(kd.bos.util.StringUtils.isEmpty((String)billId_price[1]) ? null : new BigDecimal(billId_price[1])), i);
                model.setValue("lastcompareid", (Object)billId_price[0], i);
            }
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected void buildEntryData(DynamicObjectCollection collections, String entryKey, String entrySuffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(entryKey);
        if (null == collections) {
            return;
        }
        int i = 0;
        ArrayList<String> addedQuoteHead = new ArrayList<String>();
        List properties = DynamicObjectUtil.getEntryentityProperties((IDataModel)model, (String)entryKey);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject dynamicObject : collections) {
            if (QUOTESUM_ENTRYTITY.equals(entryKey)) {
                String quoBillno = dynamicObject.getString("billno");
                if (addedQuoteHead.contains(quoBillno)) continue;
                addedQuoteHead.add(quoBillno);
            }
            Map objectMap = DynamicObjectUtil.plainObject2Map((DynamicObject)dynamicObject);
            for (Map.Entry entry : objectMap.entrySet()) {
                if (QUOTESUM_ENTRYTITY.equals(entryKey)) {
                    BigDecimal[] infos;
                    if (((String)entry.getKey()).contains("amount") || ((String)entry.getKey()).contains("sumtax")) {
                        BigDecimal amt = new BigDecimal(entry.getValue().toString());
                        if (!properties.contains((String)entry.getKey() + entrySuffix)) continue;
                        ts.set((String)entry.getKey() + entrySuffix, (Object)amt, i);
                        continue;
                    }
                    if (!properties.contains((String)entry.getKey() + entrySuffix)) continue;
                    if (((String)entry.getKey()).contains("billno") && (infos = this.adoptQuoteInfoMap.get(entry.getValue())) != null && infos.length == 2 && properties.contains("adoptamount" + entrySuffix) && properties.contains("adopttaxamount" + entrySuffix)) {
                        ts.set("adoptamount" + entrySuffix, (Object)infos[0], i);
                        ts.set("adopttaxamount" + entrySuffix, (Object)infos[1], i);
                    }
                    ts.set((String)entry.getKey() + entrySuffix, entry.getValue(), i);
                    continue;
                }
                if (!properties.contains((String)entry.getKey() + entrySuffix)) continue;
                ts.set((String)entry.getKey() + entrySuffix, entry.getValue(), i);
            }
            ++i;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(entryKey, ts);
        model.endInit();
        this.getView().updateView(entryKey);
    }

    protected void buildHeadData(DynamicObject dynamicObject, String controlKey) {
        Map dynMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
        Container container = (Container)this.getControl(controlKey);
        IDataModel model = this.getModel();
        List proHeadEntity = DynamicObjectUtil.getContainerProperties((Container)container);
        for (String property : proHeadEntity) {
            Object value = dynMap.get(property);
            if (value == null) continue;
            if ("paycond".equals(property) && 0L == (Long)value) {
                model.setValue(property, null);
                continue;
            }
            model.setValue(property, value);
        }
        model.setValue("defrule", dynamicObject.get("adoptrule"));
    }

    @Override
    protected Map<String, Object> buildQuoCondition() {
        String quoteNum;
        String inquiryNo;
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        IPageCache cache = this.getPageCache();
        String fromDate = cache.get("fromdate");
        String pattern = "yyyy-MM-dd";
        SqlParameter parameter = null;
        if (null != fromDate) {
            parameter = new SqlParameter(":a.FendDate", 91, (Object)DateUtil.string2date((String)fromDate, (String)pattern));
            param.put("fromdate", parameter);
        }
        parameter = new SqlParameter(":a.FendDate", 91, (Object)TimeServiceHelper.now());
        param.put("enddate", parameter);
        String org = cache.get("org");
        if (null != org) {
            parameter = new SqlParameter(":a.FORGID", -5, (Object)Long.valueOf(org));
            param.put("org", parameter);
        }
        if (null != (inquiryNo = cache.get(INQUIRY_NO)) && kd.bos.util.StringUtils.isNotEmpty((String)inquiryNo)) {
            parameter = new SqlParameter(":a.finquiryno", 12, (Object)("%" + inquiryNo + "%"));
            param.put(INQUIRY_NO, parameter);
        }
        if (null != (quoteNum = cache.get("quotenum"))) {
            param.put("quotenum", Integer.valueOf(quoteNum));
        } else {
            param.put("quotenum", 1);
        }
        parameter = new SqlParameter(":a.Fbizstatus", 12, (Object)BizStatusEnum.OPENEDTHEBID.getVal());
        param.put("bizstatus", parameter);
        return param;
    }

    private Map<String, Map<String, Object>> buildCondition() {
        HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>();
        IPageCache cache = this.getPageCache();
        String org = cache.get("org");
        if (null != org) {
            HashMap<String, Long> orgMap = new HashMap<String, Long>(1);
            orgMap.put("=", Long.valueOf(org));
            paramMap.put("org", orgMap);
        }
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        paramMap.put("billstatus", statusMap);
        return paramMap;
    }

    private void initAllTreeNodes() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        TreeNode node = new TreeNode("", "0", ResManager.loadKDString((String)"\u8be2\u4ef7\u5355", (String)"SouCompareAssistantBatchPlugin_7", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        treeView.deleteAllNodes();
        treeView.addNode(node);
        treeView.focusNode(node);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        String nodeIdStr = nodeId.toString();
        IPageCache cache = this.getPageCache();
        if (nodeIdStr.equals("0")) {
            this.deleteViewEntry();
            cache.remove(INQUIRY_NO);
        } else {
            this.getPageCache().remove("adoptType");
            cache.put(IS_TREE_NODE_CLICK, INQUIRY_ENTRYTITY_SUFFIX);
            cache.put(IS_TREE_NODE_CLICK, INQUIRY_ENTRYTITY_SUFFIX);
            String currNo = cache.get(INQUIRY_NO);
            if (currNo == null || !currNo.trim().equals(nodeIdStr)) {
                this.allotDynamicData(nodeIdStr);
                cache.put(INQUIRY_NO, nodeIdStr);
            }
        }
    }

    protected void buildTreeData(List<String> inquirynoList, String focusInquiryNo) {
        TreeNode node;
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        this.initAllTreeNodes();
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        IPageCache pageCache = this.getPageCache();
        String maxcount = pageCache.get("maxcount");
        int max = 1000;
        try {
            max = kd.bos.util.StringUtils.isBlank((String)maxcount) ? 1000 : Integer.parseInt(maxcount);
        }
        catch (NumberFormatException e) {
            log.error("maxcount NumberFormatException " + e.getMessage());
        }
        for (int i = 0; i < inquirynoList.size() && i < max; ++i) {
            String inquiryNo = inquirynoList.get(i);
            if (inquiryNo.trim().length() == 0) continue;
            node = new TreeNode("0", inquiryNo, inquiryNo);
            treeNodes.add(node);
        }
        treeView.addNodes(treeNodes);
        treeView.expand("0");
        node = new TreeNode("0", focusInquiryNo, focusInquiryNo);
        treeView.focusNode(node);
    }

    @Override
    protected List<String> getInquiryNoByQuoInfo(Map<String, Object> parameters) {
        ISouGroupParamerterService groupService;
        QFilter filter;
        Object org = null;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = null;
        qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilters.add(qFilter);
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry<String, Object> next : parameters.entrySet()) {
                String key = next.getKey();
                Object value = next.getValue();
                if (!(value instanceof SqlParameter)) continue;
                if ("enddate".equals(key)) {
                    qFilter = new QFilter("enddate", "<=", ((SqlParameter)value).getValue());
                    qFilters.add(qFilter);
                    continue;
                }
                if ("fromdate".equals(key)) {
                    qFilter = new QFilter("enddate", ">=", ((SqlParameter)value).getValue());
                    qFilters.add(qFilter);
                    continue;
                }
                if (INQUIRY_NO.equals(key)) {
                    qFilter = new QFilter("billno", "like", ((SqlParameter)value).getValue());
                    qFilters.add(qFilter);
                    continue;
                }
                if ("org".equals(key) || "bizstatus".equals(key)) {
                    qFilter = new QFilter(key, "=", ((SqlParameter)value).getValue());
                    qFilters.add(qFilter);
                    continue;
                }
                if (!"supquonum".equals(key)) continue;
                qFilter = new QFilter(key, ">", ((SqlParameter)value).getValue());
                qFilters.add(qFilter);
            }
            org = parameters.get("org");
        }
        if ((filter = (groupService = this.getSouGroupParamterService()).getCurrUserGroupFilter()) != null) {
            qFilters.add(filter);
        }
        if (null == org) {
            List inquiryPermissionOrgs;
            List permissionOrgs;
            List quotePermissionOrgs = OrgUtil.getAllPurViewPermissionOrgs((String)"sou_quote");
            List list = permissionOrgs = quotePermissionOrgs.retainAll(inquiryPermissionOrgs = OrgUtil.getAllPurViewPermissionOrgs((String)"sou_inquiry")) ? quotePermissionOrgs : inquiryPermissionOrgs;
            if (permissionOrgs.size() == 0) {
                qFilters.add(new QFilter("org", "=", (Object)0L));
            } else {
                qFilters.add(new QFilter("org", "in", (Object)permissionOrgs));
            }
        }
        ArrayList<String> inquirynos = new ArrayList<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sou_inquiry", (String)"billno", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"billno desc");){
            for (Row row : dataSet) {
                inquirynos.add(row.getString("billno"));
            }
        }
        return inquirynos;
    }

    protected ISouGroupParamerterService getSouGroupParamterService() {
        return new SouGroupParamerterServiceImp();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid inquiryGrid = (EntryGrid)evt.getSource();
        if (INQUIRY_ENTRYTITY.equals(inquiryGrid.getEntryKey())) {
            DynamicObject material;
            int[] selectRows = inquiryGrid.getSelectRows();
            if (selectRows.length == 0) {
                return;
            }
            DynamicObject row = this.getModel().getEntryRowEntity(INQUIRY_ENTRYTITY, selectRows[0]);
            DynamicObject dynamicObject = material = row != null ? row.getDynamicObject("material1") : null;
            if (material != null) {
                ArrayList<Object> materialIds = new ArrayList<Object>(1);
                materialIds.add(material.getPkValue());
                this.allotComparePriceData(materialIds);
                DynamicObjectCollection purOrderCols = this.getPurOrderData(materialIds);
                this.buildRecentPriceData(purOrderCols);
            }
        }
        this.getView().updateView(RECENTLY_ENTRYTITY);
    }

    protected void allotComparePriceData(List<Object> materialIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Date date = TimeServiceHelper.now();
        String monthNum = this.getPageCache().get("monthnum");
        String org = this.getPageCache().get("org");
        QFilter commonFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        if (org != null) {
            commonFilter.and(new QFilter("org", "=", (Object)Long.parseLong(org)));
        } else {
            commonFilter.and(new QFilter("org", "in", (Object)OrgUtil.getAllPurViewPermissionOrgs((String)"sou_compare")));
        }
        commonFilter.and(new QFilter("materialentry.material.id", "in", materialIds));
        if (null != monthNum && !monthNum.trim().isEmpty()) {
            commonFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.getPreviousSomeMonthStingDate((Date)date, (int)(Integer.parseInt(monthNum) - 1))));
        } else {
            commonFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.getPreviousSomeMonthStingDate((Date)date, (int)24)));
        }
        commonFilter.and("materialentry.material.isdisposable", "=", (Object)Boolean.FALSE);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sou_comparetool");
        EntityType recentpriceEntry = (EntityType)dataEntityType.getAllEntities().get(COMPARE_ENTRYTITY);
        HashSet selectList = new HashSet(64);
        MainEntityType orderType = EntityMetadataCache.getDataEntityType((String)"sou_compare");
        EntityType materialentry = (EntityType)orderType.getAllEntities().get("materialentry");
        HashMap blackListMap = new HashMap();
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)recentpriceEntry.getProperties(), selectList, null, blackListMap, (DataEntityPropertyCollection)orderType.getProperties(), (String)"5");
        if (materialentry != null) {
            InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)recentpriceEntry.getProperties(), selectList, null, blackListMap, (DataEntityPropertyCollection)materialentry.getProperties(), (String)"5");
        }
        String selects = StringUtil.join((Object[])selectList.toArray(), (String)",");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData(COMPARE_ENTRYTITY);
        int rowCount = 0;
        DataEntityPropertyCollection properties = model.getEntryEntity(COMPARE_ENTRYTITY).getDynamicObjectType().getProperties();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"sou_compare", (String)selects, (QFilter[])new QFilter[]{commonFilter}, (String)"billdate desc,billno");){
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                for (String field : fieldNames) {
                    String proKey = field + "5";
                    if (!properties.containsKey((Object)proKey)) continue;
                    vs.set(proKey, row.get(field), rowCount);
                }
                ++rowCount;
            }
        }
        model.beginInit();
        model.batchCreateNewEntryRow(COMPARE_ENTRYTITY, vs);
        model.endInit();
        this.getView().updateView(COMPARE_ENTRYTITY);
    }

    protected DynamicObjectCollection getPurOrderData(List<Object> materialPkIds) {
        HashMap blackListMap = new HashMap();
        HashSet selectList = new HashSet(64);
        String monthnumStr = this.getPageCache().get("monthnum");
        SouCompareAssiRecentPriceArgs args = new SouCompareAssiRecentPriceArgs(materialPkIds, monthnumStr, blackListMap, selectList);
        DefaultSouCompareAssistantRecentPriceSource plugin = new DefaultSouCompareAssistantRecentPriceSource();
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouCompareAssistantRecentPriceSource.class, (String)"SCM_SOU_COMPARETOOL_RECENTPRICE", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.doGetData(args);
            return null;
        });
        return args.getResult();
    }

    protected DynamicObject getInquiryObjByBillNo(String billNo) {
        Container inquiryquopanel = (Container)this.getControl("inquiryquopanel");
        Container inquirybasepanel = (Container)this.getControl("inquirybasepanel");
        return AdoptionHelper.getInquiryObjByBillNo(billNo, inquiryquopanel, inquirybasepanel, this, this.getPageCache().get("inquirytitle"));
    }

    private void buildRecentPriceData(DynamicObjectCollection purOrderCollections) {
        this.buildEntryData(purOrderCollections, RECENTLY_ENTRYTITY, RECENTLY_ENTRYTITY_SUFFIX);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        EntryGrid grid = (EntryGrid)e.getSource();
        String gridKey = grid.getKey();
        int index = e.getRowIndex();
        Object val = null;
        String entityKey = null;
        String property = e.getFieldName();
        switch (gridKey) {
            case "quohead_entry": 
            case "quote_entry": 
            case "compareprice_entry": 
            case "recentprice_entry": {
                val = grid.getModel().getValue(property);
                entityKey = billnoEntryMap.get(property);
                String id = billnoIdMap.get(property);
                if (!kd.bos.util.StringUtils.isNotEmpty((String)entityKey)) break;
                Object idValue = null;
                if (kd.bos.util.StringUtils.isNotEmpty((String)id) && (idValue = grid.getModel().getValue(id)) instanceof String) {
                    idValue = Long.valueOf(String.valueOf(idValue));
                }
                SouCompareBillUtil.showBillForm((Object)val, (String)entityKey, (Object)idValue, (IFormView)this.getView());
                break;
            }
        }
        if (gridKey.equals(INQUIRY_ENTRYTITY) && "lastcompareprice".equals(property)) {
            String lastCompareId = (String)this.getModel().getValue("lastcompareid", index);
            OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"sou_compare", (Object)lastCompareId, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }

    public void showBillForm(Object val, String entityKey) {
        SouCompareBillUtil.showBillForm((Object)val, (String)entityKey, null, (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex;
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (this.isNeedChange) {
            this.isNeedChange = false;
            if ("result2".equals(fieldKey)) {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                DynamicObject row = model.getEntryRowEntity(QUOTE_ENTRYTITY, rowIndex);
                DynamicObject curr1 = (DynamicObject)model.getDataEntity(true).get("curr");
                int settleScale = 6;
                if (curr1 != null && curr1.getDynamicObjectType().getProperty("priceprecision") != null) {
                    settleScale = curr1.getInt("priceprecision");
                }
                String taxType = String.valueOf(model.getValue("taxtype"));
                String result = row.getString(fieldKey);
                if (INQUIRY_ENTRYTITY_SUFFIX.equals(result)) {
                    BigDecimal qty = CommonUtil.getBigDecimalPro((Object)row.get("qty2"));
                    BigDecimal price = CommonUtil.getBigDecimalPro((Object)row.get("price2"));
                    BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)row.get("taxprice2"));
                    BigDecimal taxRate = CommonUtil.getBigDecimalPro((Object)row.get("taxrate2"));
                    Object taxRateId = row.get("taxrateid2");
                    model.setValue("cfmprice2", (Object)price, rowIndex);
                    model.setValue("cfmtaxprice2", (Object)taxPrice, rowIndex);
                    model.setValue("cfmtaxrate2", (Object)taxRate, rowIndex);
                    model.setValue("cfmqty2", (Object)qty, rowIndex);
                    DynamicObject curr = row.getDynamicObject("quotecurr2");
                    int scale = 6;
                    if (curr != null && curr.getDynamicObjectType().getProperty("amtprecision") != null) {
                        scale = curr.getInt("amtprecision");
                    }
                    model.setValue("cfmamount2", (Object)MultCurrencyCalImpl.calAmount((DynamicObject)row, (String)taxType, (String)QUOTE_ENTRYTITY_SUFFIX, (int)scale), rowIndex);
                    model.setValue("cfmtaxamount2", (Object)MultCurrencyCalImpl.calTaxAmount((DynamicObject)row, (String)taxType, (String)QUOTE_ENTRYTITY_SUFFIX, (int)scale), rowIndex);
                    model.setValue("cfmtaxrateid2", taxRateId, rowIndex);
                    BigDecimal exRate = row.getBigDecimal("exrate2");
                    String entryquotation = row.getString("entryquotation2");
                    model.setValue("excludeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)price, (BigDecimal)exRate, (int)settleScale, (String)entryquotation), rowIndex);
                    model.setValue("includeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)taxPrice, (BigDecimal)exRate, (int)settleScale, (String)entryquotation), rowIndex);
                } else if (QUOTE_ENTRYTITY_SUFFIX.equals(result)) {
                    model.setValue("cfmprice2", (Object)0, rowIndex);
                    model.setValue("cfmtaxprice2", (Object)0, rowIndex);
                    model.setValue("cfmtaxrate2", (Object)0, rowIndex);
                    model.setValue("cfmqty2", (Object)0, rowIndex);
                    model.setValue("cfmamount2", (Object)0, rowIndex);
                    model.setValue("cfmtaxamount2", (Object)0, rowIndex);
                    model.setValue("cfmtaxrateid2", null, rowIndex);
                    model.setValue("excludeunittax2", (Object)0, rowIndex);
                    model.setValue("includeunittax2", (Object)0, rowIndex);
                }
            } else if ("cfmprice2".equals(fieldKey) || "cfmtaxprice2".equals(fieldKey) || "cfmtaxrate2".equals(fieldKey)) {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                this.calPrice(model, fieldKey, rowIndex);
            } else if ("cfmqty2".equals(fieldKey)) {
                this.dealCfmQtyChange(e, model);
            }
            this.isNeedChange = true;
        }
        if ("cfmamount2".equals(fieldKey) || "cfmtaxamount2".equals(fieldKey)) {
            rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal oldValue = (BigDecimal)e.getChangeSet()[0].getOldValue();
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(QUOTE_ENTRYTITY, rowIndex);
            HashMap<String, BigDecimal[]> midResult = new HashMap<String, BigDecimal[]>(1);
            this.preDealAdoptInfo(midResult, fieldKey, oldValue, newValue, rowInfo);
            this.setAdoptInfo(midResult);
            this.getView().updateView(QUOTESUM_ENTRYTITY);
        }
    }

    private void dealCfmQtyChange(PropertyChangedArgs e, IDataModel model) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject row = model.getEntryRowEntity(QUOTE_ENTRYTITY, rowIndex);
        DynamicObject curr1 = (DynamicObject)model.getDataEntity(true).get("curr");
        int settleScale = 6;
        if (curr1 != null && curr1.getDynamicObjectType().getProperty("priceprecision") != null) {
            settleScale = curr1.getInt("priceprecision");
        }
        String taxType = String.valueOf(model.getValue("taxtype"));
        BigDecimal price = CommonUtil.getBigDecimalPro((Object)row.get("price2"));
        BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)row.get("taxprice2"));
        BigDecimal taxRate = row.getBigDecimal("cfmtaxrate2");
        int scale = 6;
        if (taxRate != null) {
            scale = taxRate.scale() + 2;
        }
        model.setValue("cfmamount2", (Object)MultCurrencyCalImpl.calCfmAmount((DynamicObject)row, (String)taxType, (String)QUOTE_ENTRYTITY_SUFFIX, (int)scale), rowIndex);
        model.setValue("cfmtaxamount2", (Object)MultCurrencyCalImpl.calCfmTaxAmount((DynamicObject)row, (String)taxType, (String)QUOTE_ENTRYTITY_SUFFIX, (int)scale), rowIndex);
        BigDecimal exRate = row.getBigDecimal("exrate2");
        String entryquotation = row.getString("entryquotation2");
        model.setValue("excludeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)price, (BigDecimal)exRate, (int)settleScale, (String)entryquotation), rowIndex);
        model.setValue("includeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)taxPrice, (BigDecimal)exRate, (int)settleScale, (String)entryquotation), rowIndex);
        SouCompareAssistantBatchPlugin.updateEntryBasicQtyByLineIndex(row, model, rowIndex);
    }

    public static void updateEntryBasicQtyByLineIndex(DynamicObject row, IDataModel model, int rowIndex) {
        BigDecimal newQty;
        if (row == null) {
            return;
        }
        BigDecimal basicQty = newQty = row.getBigDecimal("cfmqty2");
        DynamicObject materialObj = row.getDynamicObject("material2");
        DynamicObject unitObj = row.getDynamicObject("unit2");
        DynamicObject basicUnitObj = row.getDynamicObject("basicunit2");
        if (materialObj == null) {
            row.set("cfmbaseqty2", (Object)newQty);
        }
        if (null != materialObj && null != unitObj && null != basicUnitObj) {
            basicQty = unitObj.getPkValue().equals(basicUnitObj.getPkValue()) ? newQty : CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)newQty, (DynamicObject)basicUnitObj);
            basicQty = null == basicQty ? newQty : basicQty;
        }
        model.setValue("cfmbaseqty2", (Object)basicQty, rowIndex);
    }

    private void setAdoptInfo(Map<String, BigDecimal[]> midResultMap) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(QUOTESUM_ENTRYTITY);
        BigDecimal adoptamount = null;
        BigDecimal adoptaxtamount = null;
        int i = 0;
        for (DynamicObject info : entity) {
            BigDecimal[] values = midResultMap.get(info.getString("billno4"));
            if (values != null) {
                ++i;
                adoptamount = info.getBigDecimal("adoptamount4");
                adoptaxtamount = info.getBigDecimal("adopttaxamount4");
                if (adoptamount != null) {
                    if (values[0] != null) {
                        adoptamount = adoptamount.add(values[0]);
                        info.set("adoptamount4", (Object)adoptamount);
                    }
                    if (values[1] != null) {
                        adoptaxtamount = adoptaxtamount.add(values[1]);
                        info.set("adopttaxamount4", (Object)adoptaxtamount);
                    }
                }
            }
            if (i != midResultMap.size()) continue;
            break;
        }
    }

    private void calPrice(IDataModel model, String property, int rowIndex) {
        BigDecimal taxRate;
        int scaleNum = 4;
        int scaleNumCurr = 6;
        DynamicObject row = model.getEntryRowEntity(QUOTE_ENTRYTITY, rowIndex);
        DynamicObject quotecurr = row.getDynamicObject("quotecurr2");
        Object currObj = model.getValue("curr");
        if (null != currObj) {
            DynamicObject curr = (DynamicObject)currObj;
            scaleNumCurr = curr.getInt("priceprecision");
        }
        if (quotecurr != null) {
            scaleNum = quotecurr.getInt("priceprecision");
        }
        BigDecimal cfmQty = CommonUtil.getBigDecimalPro((Object)row.get("cfmqty2"));
        BigDecimal cfmPrice = CommonUtil.getBigDecimalPro((Object)row.get("cfmprice2"));
        BigDecimal cfmTaxPrice = CommonUtil.getBigDecimalPro((Object)row.get("cfmtaxprice2"));
        BigDecimal cfmTaxRate = CommonUtil.getBigDecimalPro((Object)row.get("cfmtaxrate2")).divide(CalConstant.BIGDECIMAL_ONEHUNDRED, scaleNum, RoundingMode.HALF_UP);
        String taxType = (String)model.getValue("taxtype");
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            taxRate = CalConstant.BIGDECIMAL_ONE.add(cfmTaxRate);
            if ("cfmprice2".equals(property)) {
                cfmTaxPrice = cfmPrice.multiply(taxRate).setScale(scaleNum, RoundingMode.HALF_UP);
                model.setValue("cfmtaxprice2", (Object)cfmTaxPrice, rowIndex);
            } else if ("cfmtaxprice2".equals(property) || "cfmtaxrate2".equals(property)) {
                cfmPrice = cfmTaxPrice.divide(taxRate, scaleNum, RoundingMode.HALF_UP);
                model.setValue("cfmprice2", (Object)cfmPrice, rowIndex);
            }
            model.setValue("cfmtaxamount2", (Object)cfmTaxPrice.multiply(cfmQty).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
            BigDecimal taxPrice = cfmTaxPrice.multiply(cfmQty).divide(taxRate, scaleNum, RoundingMode.HALF_UP).multiply(cfmTaxRate);
            model.setValue("cfmamount2", (Object)cfmTaxPrice.multiply(cfmQty).subtract(taxPrice).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            taxRate = CalConstant.BIGDECIMAL_ONE.add(cfmTaxRate);
            if ("cfmprice2".equals(property) || "cfmtaxrate2".equals(property)) {
                cfmTaxPrice = cfmPrice.multiply(taxRate).setScale(scaleNum, RoundingMode.HALF_UP);
                model.setValue("cfmtaxprice2", (Object)cfmTaxPrice, rowIndex);
            } else if ("cfmtaxprice2".equals(property)) {
                cfmPrice = cfmTaxPrice.divide(taxRate, scaleNum, RoundingMode.HALF_UP);
                model.setValue("cfmprice2", (Object)cfmPrice, rowIndex);
            }
            model.setValue("cfmamount2", (Object)cfmPrice.multiply(cfmQty).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
            model.setValue("cfmtaxamount2", (Object)cfmPrice.multiply(cfmQty).multiply(taxRate).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            taxRate = CalConstant.BIGDECIMAL_ONE.subtract(cfmTaxRate);
            if ("cfmprice2".equals(property)) {
                cfmTaxPrice = cfmPrice.divide(taxRate, scaleNum, RoundingMode.HALF_UP);
                model.setValue("cfmtaxprice2", (Object)cfmTaxPrice, rowIndex);
            } else if ("cfmtaxprice2".equals(property) || "cfmtaxrate2".equals(property)) {
                cfmPrice = cfmTaxPrice.multiply(taxRate).setScale(scaleNum, RoundingMode.HALF_UP);
                model.setValue("cfmprice2", (Object)cfmPrice, rowIndex);
            }
            model.setValue("cfmamount2", (Object)cfmTaxPrice.multiply(cfmQty).setScale(scaleNumCurr, RoundingMode.HALF_UP).subtract(cfmTaxPrice.multiply(cfmQty).setScale(scaleNumCurr, RoundingMode.HALF_UP).multiply(cfmTaxRate)), rowIndex);
            model.setValue("cfmtaxamount2", (Object)cfmTaxPrice.multiply(cfmQty).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
        }
        BigDecimal exRate = row.getBigDecimal("exrate2");
        String entryquotation = row.getString("entryquotation2");
        if (entryquotation != null && entryquotation.equals("0")) {
            model.setValue("excludeunittax2", (Object)row.getBigDecimal("cfmprice2").multiply(exRate).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
            model.setValue("includeunittax2", (Object)row.getBigDecimal("cfmtaxprice2").multiply(exRate).setScale(scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
        } else {
            model.setValue("excludeunittax2", (Object)row.getBigDecimal("cfmprice2").divide(exRate, scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
            model.setValue("includeunittax2", (Object)row.getBigDecimal("cfmtaxprice2").divide(exRate, scaleNumCurr, RoundingMode.HALF_UP), rowIndex);
        }
    }

    protected void export() {
        int rowCount = this.getModel().getEntryRowCount(INQUIRY_ENTRYTITY);
        if (rowCount <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"SouCompareAssistantBatchPlugin_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String inquiryNo = this.getModel().getValue(INQUIRY_NO).toString();
        if (!this.validatePerm(inquiryNo)) {
            return;
        }
        IFormView view = this.getView();
        try {
            ExcelDataEntity excelDataEntity = null;
            DynamicObjectCollection rows = this.getModel().getDataEntity().getDynamicObjectCollection(INQUIRY_ENTRYTITY);
            IExcelDataEntityService service = this.getExcelDataEntityService();
            excelDataEntity = service.wrapExcelDataEntity(rows, items -> {
                this.setColumn((List<ControlAp<?>>)items);
                return null;
            });
            excelDataEntity.setFileName(ResManager.loadKDString((String)"\u8be2\u4ef7\u660e\u7ec6.xlsx", (String)"SouCompareAssistantBatchPlugin_9", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            this.setAllSupplierQuoInfo(excelDataEntity);
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"SouCompareAssistantBatchPlugin_10", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
    }

    private void setAllSupplierQuoInfo(ExcelDataEntity excelDataEntity) {
        String inquiryNo = this.getModel().getValue(INQUIRY_NO).toString();
        Map<String, Object> dataMap = this.getQuoteByInquiry(inquiryNo);
        int validnum = excelDataEntity.getColumnKeyList().indexOf("validnum");
        if (validnum >= 0) {
            List validnumCol = excelDataEntity.getColumnValue(0, 0, validnum);
            validnumCol.remove(validnumCol.size() - 1);
        }
        DynamicObjectCollection supplierCols = (DynamicObjectCollection)dataMap.get("supplier");
        ArrayList<String> columnKeyList = new ArrayList<String>(excelDataEntity.getColumnKeyList());
        ArrayList<String> columnNameList = new ArrayList<String>(excelDataEntity.getRowValue(0, 0));
        QFilter billnoFilter = new QFilter("billno", "=", this.getModel().getValue(INQUIRY_NO));
        String supscope = (String)this.getModel().getValue("supscope");
        DynamicObjectCollection specifiedSupCol = null;
        if (SouSupScopeEnum.SPECIFIED.getVal().equals(supscope)) {
            specifiedSupCol = QueryServiceHelper.query((String)"sou_inquiry", (String)"entryentity.supplier.id,entryentity.supplier.name", (QFilter[])new QFilter[]{billnoFilter}, null);
        }
        if (null == supplierCols) {
            supplierCols = new DynamicObjectCollection();
        }
        List<String> supQuoNumColumn = this.getSupQuoNumColumn();
        if (supplierCols.size() > supQuoNumColumn.size() || specifiedSupCol != null && specifiedSupCol.size() > supQuoNumColumn.size()) {
            Map<String, String> supColumnRelation = this.buildEntrySupColumns(supplierCols, this.getSupQuoNumColumn());
            for (DynamicObject supDyn : supplierCols) {
                String supId = supDyn.getString("supplier");
                if (supColumnRelation.containsValue(supId)) continue;
                columnKeyList.add(supId);
                columnNameList.add(supDyn.getString("supplierName"));
            }
            if (null != specifiedSupCol) {
                HashSet supIds = new HashSet();
                supplierCols.forEach(sup -> supIds.add(sup.getLong("supplier")));
                Collection hasExportSupName = this.getPageCache().getAll().values();
                specifiedSupCol.forEach(specifiedSup -> {
                    long specifiedSupId = specifiedSup.getLong("entryentity.supplier.id");
                    String specifiedSupName = specifiedSup.getString("entryentity.supplier.name");
                    if (!supIds.contains(specifiedSup.getLong("entryentity.supplier.id")) && !hasExportSupName.contains(specifiedSupName)) {
                        columnKeyList.add(String.valueOf(specifiedSupId));
                        columnNameList.add(specifiedSup.getString("entryentity.supplier.name"));
                    }
                });
            }
            try {
                excelDataEntity.setColumnKeyList(columnKeyList);
                excelDataEntity.setExcelHeader(columnNameList);
                int entryIdColIndex = columnKeyList.indexOf("srcentryid1");
                List colEntryIdValues = excelDataEntity.getColumnValue(0, 0, entryIdColIndex);
                this.setExSupplierPriceWhenExport(excelDataEntity, columnKeyList, (DynamicObjectCollection)dataMap.get("quote"), colEntryIdValues);
                this.setExSupplierSumPriceWhenExport(excelDataEntity, columnKeyList, colEntryIdValues);
            }
            catch (IOException e) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e));
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u8be2\u4ef7\u660e\u7ec6\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SouCompareAssistantBatchPlugin_19", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setExSupplierPriceWhenExport(ExcelDataEntity excelDataEntity, List<String> columnKeyList, DynamicObjectCollection quoteCol, List<String> colEntryIdValues) throws IOException {
        for (DynamicObject quoteDyn : quoteCol) {
            String quoteSrcEntryId;
            int rowIndex;
            String supplierId = quoteDyn.getString("supplier");
            int colIndex = columnKeyList.indexOf(supplierId);
            if (colIndex <= -1 || (rowIndex = colEntryIdValues.indexOf(quoteSrcEntryId = quoteDyn.getString("srcentryid"))) <= -1) continue;
            BigDecimal quoteTaxPrice = quoteDyn.getBigDecimal("taxprice");
            excelDataEntity.createCell(0, rowIndex, colIndex);
            excelDataEntity.setValueAt(0, rowIndex, colIndex, BigDecimal.ZERO.compareTo(quoteTaxPrice) == 0 ? "" : quoteTaxPrice.toPlainString());
        }
    }

    public void setExSupplierSumPriceWhenExport(ExcelDataEntity excelDataEntity, List<String> exSupplierIds, List<String> colEntryIdValues) throws IOException {
        DynamicObjectCollection quoSumCols = this.getModel().getEntryEntity(QUOTESUM_ENTRYTITY);
        List columnKeyList = excelDataEntity.getColumnKeyList();
        for (DynamicObject quoSum : quoSumCols) {
            DynamicObject supplier = quoSum.getDynamicObject("supplier4");
            String supplierPkStr = "0";
            if (null != supplier) {
                supplierPkStr = String.valueOf(supplier.getPkValue());
            }
            if (!exSupplierIds.contains(supplierPkStr)) continue;
            BigDecimal amount = quoSum.getBigDecimal("sumtaxamount4");
            int rowIndex = colEntryIdValues.size() - 1;
            int colIndex = columnKeyList.indexOf(supplierPkStr);
            if (rowIndex < 0 || colIndex < 0) continue;
            excelDataEntity.createCell(0, rowIndex, colIndex);
            excelDataEntity.setValueAt(0, rowIndex, colIndex, BigDecimal.ZERO.compareTo(amount) == 0 ? "" : amount.toPlainString());
        }
    }

    private void setColumn(List<ControlAp<?>> items) {
        HashMap<String, String> supColumnKeyMap = new HashMap<String, String>(8);
        List<String> supColumns = this.getSupQuoNumColumn();
        for (String supColumn : supColumns) {
            supColumnKeyMap.put(supColumn, supColumn);
        }
        IPageCache cache = this.getPageCache();
        if (items != null) {
            Iterator<ControlAp<?>> iterator = items.iterator();
            while (iterator.hasNext()) {
                ControlAp<?> next = iterator.next();
                int visVal = next.getVisibleValue();
                if ((next.isHidden() || visVal == 0) && !"srcentryid1".equals(next.getKey())) {
                    iterator.remove();
                    continue;
                }
                String supName = cache.get(next.getKey());
                if (null != supName) {
                    next.setName(new LocaleString(supName));
                    continue;
                }
                if (null == supColumnKeyMap.get(next.getKey())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    protected void buildRecentCompareAndOrder(DynamicObjectCollection quoteCollections) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(INQUIRY_ENTRYTITY);
        grid.selectRows(0);
        ArrayList<Object> materialIds = new ArrayList<Object>(1);
        if (!quoteCollections.isEmpty()) {
            materialIds.add(((DynamicObject)quoteCollections.get(0)).get("material"));
            this.allotComparePriceData(materialIds);
            DynamicObjectCollection purOrderCols = this.getPurOrderData(materialIds);
            this.buildRecentPriceData(purOrderCols);
        }
    }

    @Override
    protected DynamicObjectCollection buildInquiryAndQuote(Map<String, Object> dataMap, String inquiryNo) {
        DynamicObject inquiryObj;
        List<String> supColumnInfo = this.getSupQuoNumColumn();
        if (this.adoptionModel == null || this.adoptionModel.getData() == null) {
            this.adoptionModel = new AdoptionModel("sou_comparetool", this.getModel().getDataEntity(true));
            this.adoptionModel.setData(dataMap);
        }
        DynamicObjectCollection quoteCollections = new DynamicObjectCollection();
        DynamicObjectCollection quoteSupCollections = new DynamicObjectCollection();
        if (null != this.adoptionModel.getData().get("quote")) {
            quoteCollections = (DynamicObjectCollection)this.adoptionModel.getData().get("quote");
        }
        if (null != dataMap.get("supplier")) {
            quoteSupCollections = (DynamicObjectCollection)dataMap.get("supplier");
        }
        if ((inquiryObj = this.getInquiryObjByBillNo(inquiryNo)) != null) {
            this.buildHeadData(inquiryObj, "inquiryquopanel");
            this.buildHeadData(inquiryObj, "inquirybasepanel");
            Map<String, String> supColumnRelation = this.buildEntrySupColumns(quoteSupCollections, supColumnInfo);
            this.adoptionModel.adoptByRule(inquiryObj, this.getPageCache().get("adoptType"), param -> {
                DynamicObject addInquiry = (DynamicObject)param.get("addInquiry");
                Map priceMap = (Map)param.get("priceMap");
                DefaultSouCompareToolSupColumn plugin = new DefaultSouCompareToolSupColumn();
                PluginProxy pluginProxy = PluginProxy.create((Object)plugin, ISouCompareToolSupColumn.class, (String)"SCM_SOU_COMPARETOOL_SUPCOLUMN", null);
                pluginProxy.callReplaceIfPresent(p -> {
                    p.dealSupColumn(supColumnInfo, supColumnRelation, priceMap, addInquiry);
                    return null;
                });
                return null;
            });
            this.adoptQuoteInfoMap.putAll(this.adoptionModel.getAdoptQuoteInfoMap());
            DynamicObjectCollection inquiryEntry = this.getModel().getEntryEntity(INQUIRY_ENTRYTITY);
            if (inquiryEntry.size() > 0) {
                ((AbstractFormDataModel)this.getModel()).fillReferenceData(inquiryEntry.toArray((Object[])new DynamicObject[inquiryEntry.size()]), (IDataEntityType)inquiryEntry.getDynamicObjectType());
            }
            this.setSupplierLastWinPrice();
            this.getView().updateView(INQUIRY_ENTRYTITY);
            this.getView().updateView(QUOTE_ENTRYTITY);
            this.buildQuoHeadData(quoteCollections);
            this.buildInquirySumColums(supColumnRelation, supColumnInfo);
            return quoteCollections;
        }
        return null;
    }

    private void setSupplierLastWinPrice() {
        DynamicObjectCollection inquiry_entry = this.getModel().getEntryEntity(INQUIRY_ENTRYTITY);
        Long org = this.getModel().getDataEntity().getLong("purorg.id");
        HashSet<Long> supIdSet = new HashSet<Long>();
        HashSet<Long> materialidSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : inquiry_entry) {
            DynamicObjectCollection quote_entry = dynamicObject.getDynamicObjectCollection(QUOTE_ENTRYTITY);
            for (DynamicObject quoentry : quote_entry) {
                supIdSet.add(quoentry.getLong("supplier2.id"));
                materialidSet.add(quoentry.getLong("material2.id"));
            }
        }
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and(new QFilter("materialentry.supplier", "in", supIdSet));
        filter.and(new QFilter("materialentry.material", "in", materialidSet));
        filter.and("materialentry.exrate", ">", (Object)0);
        filter.and("billstatus", "=", (Object)"C");
        Date date = TimeServiceHelper.now();
        filter.and("billdate", "<=", (Object)date);
        filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)24));
        DynamicObjectCollection comparebills = QueryServiceHelper.query((String)"sou_compare", (String)"id,org,billdate,materialentry.id entryid, materialentry.taxprice taxprice, materialentry.supplier supplier, materialentry.quotecurr quotecurr, materialentry.material material", (QFilter[])filter.toArray());
        HashMap<String, String> lasttpriceMap = new HashMap<String, String>();
        HashMap cacheRateMap = new HashMap();
        for (DynamicObject comparebill : comparebills) {
            BigDecimal lastPrice;
            BigDecimal taxprice = comparebill.getBigDecimal("taxprice");
            if (taxprice == null || (taxprice = ExchangeCurrUtil.exchangeTaxprice((long)comparebill.getLong("quotecurr"), (long)1L, (long)this.getModel().getDataEntity().getLong("exchtype.id"), (BigDecimal)taxprice, cacheRateMap)) == null) continue;
            String compareId = comparebill.getString("id");
            String materialStr = comparebill.getString("material");
            String supStr = comparebill.getString("supplier");
            String compareid_price_date = (String)lasttpriceMap.get(materialStr + "_" + supStr);
            Date billdate = comparebill.getDate("billdate");
            if (compareid_price_date == null) {
                lasttpriceMap.put(materialStr + "_" + supStr, compareId + "_" + taxprice.toPlainString() + "_" + billdate);
                continue;
            }
            String[] split = compareid_price_date.split("_");
            if (billdate != null && billdate.compareTo(DateUtil.string2date((String)split[2], null)) > 0) {
                lasttpriceMap.put(materialStr + "_" + supStr, compareId + "_" + taxprice.toPlainString() + "_" + billdate);
                continue;
            }
            if (billdate == null || billdate.compareTo(DateUtil.string2date((String)split[2], null)) != 0 || taxprice.compareTo(lastPrice = new BigDecimal(split[1])) >= 0) continue;
            lasttpriceMap.put(materialStr + "_" + supStr, compareId + "_" + taxprice.toPlainString() + "_" + billdate);
        }
        log.info("lasttpriceMap: " + SerializationUtils.toJsonString(lasttpriceMap));
        if (lasttpriceMap.size() > 0) {
            for (DynamicObject dynamicObject : inquiry_entry) {
                DynamicObjectCollection quote_entry = dynamicObject.getDynamicObjectCollection(QUOTE_ENTRYTITY);
                for (DynamicObject quoentry : quote_entry) {
                    String key = quoentry.getString("material2.id") + "_" + quoentry.getString("supplier2.id");
                    String priceMapValue = (String)lasttpriceMap.get(key);
                    if (priceMapValue == null) continue;
                    long quotecurr = quoentry.getLong("quotecurr2.id");
                    String[] priceSplit = priceMapValue.split("_");
                    BigDecimal lastPrice = new BigDecimal(priceSplit[1]);
                    lastPrice = ExchangeCurrUtil.exchangeTaxprice((long)1L, (long)quotecurr, (long)this.getModel().getDataEntity().getLong("exchtype.id"), (BigDecimal)lastPrice, cacheRateMap);
                    quoentry.set("lastwinprice2", (Object)lastPrice);
                    quoentry.set("lastwinbillid2", (Object)priceSplit[0]);
                }
            }
        }
    }

    public List<String> getSupQuoNumColumn() {
        return AdoptionHelper.getSupQuoNumColumn();
    }

    @Override
    protected List<String> getEffectiveInquiryNos(Map<String, Object> parameters, String billNoPar) {
        String isTreeNodeClick = this.getPageCache().get(IS_TREE_NODE_CLICK);
        ArrayList<String> inquiryNoByQuoInfo = new ArrayList<String>();
        String currNodeBo = null;
        if (billNoPar != null && billNoPar.trim().length() > 0) {
            currNodeBo = billNoPar;
            inquiryNoByQuoInfo.add(billNoPar);
        } else {
            List<String> noByQuoInfo;
            List<String> inquirynoByQuoList = this.getInquiryNoByQuoInfo(parameters);
            ArrayList<String> inquerynoFilterList = new ArrayList<String>(1024);
            String title = this.getPageCache().get("inquirytitle");
            if (kd.bos.util.StringUtils.isNotEmpty((String)title)) {
                HashSet<String> inqueryNoSet = new HashSet<String>((int)((double)inquirynoByQuoList.size() / 0.75));
                inqueryNoSet.addAll(inquirynoByQuoList);
                DynamicObjectCollection inquiryNoDC = QueryServiceHelper.query((String)"sou_inquiry", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", inqueryNoSet), new QFilter("inquirytitle", "=", (Object)title)});
                for (DynamicObject one : inquiryNoDC) {
                    inquerynoFilterList.add(one.getString("billno"));
                }
                inquirynoByQuoList.retainAll(inquerynoFilterList);
            }
            if ((noByQuoInfo = this.getValideInquirno(inquirynoByQuoList)) != null && !noByQuoInfo.isEmpty()) {
                inquiryNoByQuoInfo.addAll(noByQuoInfo);
                currNodeBo = (String)inquiryNoByQuoInfo.get(0);
            } else {
                this.initAllTreeNodes();
                this.deleteViewEntry();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SouCompareAssistantBatchPlugin_4", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return null;
            }
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter operationRuleFilter = permissionService.getOperationRuleFilter(this.getView().getFormShowParameter().getAppId(), "sou_inquiry", "view", Long.valueOf(0L));
        if (operationRuleFilter != null) {
            DynamicObjectCollection permDC = QueryServiceHelper.query((String)"sou_inquiry", (String)"id,billno", (QFilter[])new QFilter[]{operationRuleFilter});
            List inquirynoPermFilterList = permDC.stream().map(permDO -> permDO.getString("billno")).collect(Collectors.toList());
            inquiryNoByQuoInfo.retainAll(inquirynoPermFilterList);
            if (inquiryNoByQuoInfo.isEmpty()) {
                this.buildTreeData(new ArrayList<String>(), null);
                this.deleteViewEntry();
                return null;
            }
        }
        if (null == isTreeNodeClick || "0".equals(isTreeNodeClick)) {
            this.buildTreeData(inquiryNoByQuoInfo, currNodeBo);
            this.getPageCache().put(INQUIRY_NO, currNodeBo);
        }
        return inquiryNoByQuoInfo;
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        if ("barimport".equals(evt.getCallbackKey())) {
            SouToolBatchDataSheetHandler handler = this.getSouToolBatchDataSheetHandler(evt);
            this.importData(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SouToolBatchDataSheetHandler getSouToolBatchDataSheetHandler(UploadEvent evt) {
        String url = (String)evt.getUrls()[0];
        log.info("@@uplaodurl:" + url);
        ExcelReader reader = new ExcelReader();
        SouToolBatchDataSheetHandler handler = new SouToolBatchDataSheetHandler();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            fileService.download(url, (OutputStream)outStream, "httpclient");
            ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
            reader.read((InputStream)input, (SheetHandler)handler);
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        finally {
            try {
                ((OutputStream)outStream).close();
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
        }
        return handler;
    }

    public void importData(SouToolBatchDataSheetHandler handler) {
        Map<Integer, Map<Integer, String>> rows = handler.getRows();
        try {
            if (rows.size() > 1) {
                SouCompareBatchImportPlugin importPlugin = new SouCompareBatchImportPlugin(handler);
                String error = importPlugin.validateImportInfo(inquiryNo -> {
                    this.fresh(importPlugin.getImportInquiryNo());
                    return (String)this.getModel().getValue("taxtype");
                });
                if (kd.bos.util.StringUtils.isNotEmpty((String)error)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u786e\u8ba4\u62a5\u4ef7\u4fe1\u606f\u9519\u8bef\u3002", (String)"SouCompareAssistantBatchPlugin_21", (String)"scm-sou-formplugin", (Object[])new Object[0]), error, MessageTypes.Default);
                } else {
                    this.setAdoptionRows(null, importPlugin.getDealMap());
                }
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u786e\u8ba4\u62a5\u4ef7\u4fe1\u606f\u9519\u8bef\u3002", (String)"SouCompareAssistantBatchPlugin_21", (String)"scm-quo-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
        }
    }

    public AdoptionModel getAdoptionModel() {
        return this.adoptionModel;
    }

    public void setAdoptionModel(AdoptionModel adoptionModel) {
        this.adoptionModel = adoptionModel;
    }

    static {
        billnoEntryMap.put("billno4", "sou_quote");
        billnoEntryMap.put("billno2", "sou_quote");
        billnoEntryMap.put("lastwinprice2", "sou_compare");
        billnoEntryMap.put("billno5", "sou_compare");
        billnoEntryMap.put("billno3", "pur_order");
        billnoIdMap.put("billno4", "id4");
        billnoIdMap.put("billno2", "billid2");
        billnoIdMap.put("billno5", "id5");
        billnoIdMap.put("billno3", "id3");
        billnoIdMap.put("lastwinprice2", "lastwinbillid2");
    }
}

