/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.helper.pmapply.BidBillFactory;
import kd.scm.common.helper.pmapply.PmApplyStatusUpdate;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.sou.common.SouBidBillUtil;

public class SouExceptionPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(SouExceptionPlugin.class);
    private static final String SUPQUOENTRY = "supquoentry";
    private static final String QUOENTRY = "quoentry";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject bidBill = this.getSouBidBillForSave();
        String bidStatus = bidBill != null ? bidBill.getString("bidstatus") : null;
        ComboEdit result = (ComboEdit)this.getView().getControl("result");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem pause = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6682\u505c\u7ade\u4ef7", (String)"SouExceptionPlugin_6", (String)"scm-sou-formplugin", (Object[])new Object[0])), "A");
        ComboItem stop = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u675f\u7ade\u4ef7", (String)"SouExceptionPlugin_7", (String)"scm-sou-formplugin", (Object[])new Object[0])), "B");
        ComboItem terminate = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ec8\u6b62\u9879\u76ee", (String)"SouExceptionPlugin_8", (String)"scm-sou-formplugin", (Object[])new Object[0])), "C");
        ComboItem start = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ade\u4ef7\u91cd\u542f", (String)"SouExceptionPlugin_9", (String)"scm-sou-formplugin", (Object[])new Object[0])), "D");
        if (BidStatusEnum.BIDDING.getVal().equals(bidStatus)) {
            comboItems.add(pause);
        } else {
            this.getModel().setValue("result", null);
        }
        comboItems.add(stop);
        comboItems.add(terminate);
        if (BidStatusEnum.PAUSED.getVal().equals(bidStatus)) {
            comboItems.add(start);
        }
        result.setComboItems(comboItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Date currDate = TimeServiceHelper.now();
        DynamicObject bidBill = this.getSouBidBillForSave();
        if (bidBill == null) {
            log.info("\u83b7\u53d6\u7ade\u4ef7\u5355\u636e\u4fe1\u606f\u5931\u8d25\u3002");
            return;
        }
        String bidStatus = bidBill.getString("bidstatus");
        String result = (String)model.getValue("result");
        int bidTime = bidBill.getInt("bidtime");
        if (result != null) {
            switch (result) {
                case "A": {
                    if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\uff0c\u624d\u80fd\u6682\u505c\u7ade\u4ef7\u3002", (String)"SouExceptionPlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    bidBill.set("bidstatus", (Object)BidStatusEnum.PAUSED);
                    Date pauseTime = bidBill.getDate("pausetime");
                    long restOfTime = 0L;
                    if (pauseTime == null) {
                        Date openDate = bidBill.getDate("opendate");
                        restOfTime = (long)(bidTime * 60 * 1000) - (currDate.getTime() - openDate.getTime());
                    } else {
                        restOfTime = bidBill.getLong("bidrestoftime");
                        Date pauseRestartDate = bidBill.getDate("pausestarttime");
                        if (pauseRestartDate != null) {
                            restOfTime -= currDate.getTime() - pauseRestartDate.getTime();
                        }
                    }
                    if (restOfTime <= 0L) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u7ade\u4ef7\u65f6\u95f4\u5df2\u7ed3\u675f\uff0c\u65e0\u9700\u6682\u505c\u3002", (String)"SouExceptionPlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    bidBill.set("bidrestoftime", (Object)restOfTime);
                    bidBill.set("pausetime", (Object)currDate);
                    this.setPauseAmt(bidBill);
                    break;
                }
                case "B": {
                    if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\uff0c\u624d\u80fd\u7ed3\u675f\u7ade\u4ef7\u3002", (String)"SouExceptionPlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    bidBill.set("bidstatus", (Object)BidStatusEnum.EVALUATING);
                    SouBidBillUtil.updateSupEntryNotBiddingStatus((DynamicObject)bidBill);
                    this.updateSupplierInfo(bidBill);
                    break;
                }
                case "C": {
                    if (bidStatus.equals(BidStatusEnum.END.getVal())) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\uff0c\u65e0\u9700\u7ec8\u6b62\u3002", (String)"SouExceptionPlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (BidStatusEnum.EXECUTED.getVal().equals(bidStatus)) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\uff0c\u65e0\u9700\u7ec8\u6b62\u3002", (String)"SouExceptionPlugin_10", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    long souBidId = bidBill.getLong("id");
                    QFilter qFilter = new QFilter("billentry.srcbillid", "=", (Object)souBidId);
                    DynamicObject pmOrderDyn = QueryServiceHelper.queryOne((String)"pm_purorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (pmOrderDyn != null) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u7ade\u4ef7\u5b9a\u6807\u5355\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"SouExceptionPlugin_11", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    bidBill.set("bidstatus", (Object)BidStatusEnum.END);
                    SouBidBillUtil.updateSupEntryNotBiddingStatus((DynamicObject)bidBill);
                    break;
                }
                case "D": {
                    if (!bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u662f\u6682\u505c\u72b6\u6001\u7684\u65e0\u9700\u542f\u52a8\u3002", (String)"SouExceptionPlugin_4", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    bidBill.set("bidstatus", (Object)BidStatusEnum.BIDDING.getVal());
                    bidBill.set("pausestarttime", (Object)TimeServiceHelper.now());
                    SaveServiceHelper.save((IDataEntityType)bidBill.getDataEntityType(), (Object[])new Object[]{bidBill});
                    break;
                }
            }
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5904\u7406\u7ed3\u679c\u3002", (String)"SouExceptionPlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        bidBill.set("terminate", model.getValue("suggestion"));
        SaveServiceHelper.save((IDataEntityType)bidBill.getDynamicObjectType(), (Object[])new Object[]{bidBill});
        if ("C".equals(result) && ApiConfigUtil.hasCQScmConfig()) {
            BidBillFactory pmApplyStatusUpdateFactory = new BidBillFactory();
            PmApplyStatusUpdate pmApplyStatusUpdate = pmApplyStatusUpdateFactory.create("sou_bidbill", "terminate", "", new DynamicObject[]{bidBill});
            pmApplyStatusUpdate.execute();
        }
        if ("C".equals(result)) {
            this.deleteEASInfo(bidBill);
        }
        this.getView().close();
    }

    protected void deleteEASInfo(DynamicObject bidBill) {
        if (ApiConfigUtil.hasEASConfig()) {
            this.doDeleteEasInfo(bidBill);
        }
    }

    private void doDeleteEasInfo(DynamicObject bidBill) {
        DynamicObject inquiryEntry = null;
        HashSet<String> srcBillidSet = new HashSet<String>(1024);
        HashSet<String> srcBillEntryidSet = new HashSet<String>(1024);
        DynamicObjectCollection inquiryCol = bidBill.getDynamicObjectCollection("materialentry");
        for (int j = 0; j < inquiryCol.size(); ++j) {
            inquiryEntry = (DynamicObject)inquiryCol.get(j);
            srcBillidSet.add(inquiryEntry.getString("srcbillid"));
            srcBillEntryidSet.add(inquiryEntry.getString("srcentryid"));
        }
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        HashMap<String, HashSet<String>> dataMap = new HashMap<String, HashSet<String>>();
        dataMap.put("soubid", srcBillidSet);
        dataMap.put("soubidsrcentry", srcBillEntryidSet);
        param.put("data", dataMap);
        param.put("code", Integer.valueOf(200));
        ApiUtil.souBillDeleteEAS(param);
    }

    private void updateSupplierInfo(DynamicObject bidBill) {
        SouBidBillUtil.updateSupplierInfo((DynamicObject)bidBill);
    }

    private void setPauseAmt(DynamicObject bidBill) {
        Map supQuoAmtMap = SouBidBillUtil.getNewestSupQuoAmtMap((DynamicObject)bidBill);
        List supQuoAmtList = SouBidBillUtil.rankSupQuoAmt((Map)supQuoAmtMap);
        if (supQuoAmtList.size() > 0) {
            bidBill.set("pauseamt", ((Map.Entry)supQuoAmtList.get(0)).getValue());
        }
    }

    private DynamicObject getSouBidBillForSave() {
        Map<String, Map<String, Object>> params = this.getParams();
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)"materialentry", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)SUPQUOENTRY, (boolean)false);
        DynamicObject[] objs = ORMUtil.load((String)"sou_bidbill", (String)(selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)QUOENTRY, (boolean)false)), params);
        return objs.length == 0 ? null : objs[0];
    }

    private Map<String, Map<String, Object>> getParams() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.parseLong(bidBillIdObj.toString()));
        params.put("id", idMap);
        return params;
    }
}

