/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;

public class SouQualifyPlugin
extends AbstractFormPlugin {
    private static final String SUPQUOENTRY = "supquoentry";
    private static final String CONFIRM = "confirm";

    public void afterCreateNewData(EventObject e) {
        this.bindData();
    }

    private void bindData() {
        DynamicObject souBidBill = this.getSouBidBill();
        if (souBidBill == null) {
            return;
        }
        this.setSupInfo(souBidBill);
    }

    private DynamicObject getSouBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap params = new HashMap(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.parseLong(bidBillIdObj.toString()));
        params.put("id", idMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)SUPQUOENTRY, (boolean)false);
        DynamicObject[] objs = ORMUtil.load((String)"sou_bidbill", (String)selectFields, params);
        return objs.length == 0 ? null : objs[0];
    }

    private void setSupInfo(DynamicObject souBidBill) {
        DynamicObjectCollection quoCols = souBidBill.getDynamicObjectCollection(SUPQUOENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        model.deleteEntryData("entryentity");
        for (int j = quoCols.size() - 1; j >= 0; --j) {
            DynamicObject quoCol = (DynamicObject)quoCols.get(j);
            DynamicObject quoSupplier = quoCol.getDynamicObject("entrysupplier");
            String supEntryStatus = quoCol.getString("supentrystatus");
            Date supauditdate = quoCol.getDate("supauditdate");
            String checktype = souBidBill.getString("checktype");
            if (!supEntryStatus.equals(SupBidStatusEnum.BEEXAMINING.getVal()) && (!"2".equals(checktype) || supauditdate != null)) continue;
            ts.set("qualifyresult", (Object)"A", i);
            ts.set("supplier", quoSupplier.getPkValue(), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "confirm": {
                this.confirmQualify();
                break;
            }
        }
    }

    private void confirmQualify() {
        DynamicObject souBidBill = this.getSouBidBill();
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity("entryentity");
        DynamicObjectCollection supCols = souBidBill.getDynamicObjectCollection(SUPQUOENTRY);
        boolean isConvertStatus = true;
        String bidstatus = souBidBill.getString("bidstatus");
        for (DynamicObject col : cols) {
            DynamicObject supplier = (DynamicObject)col.get("supplier");
            String qualifyResult = col.getString("qualifyresult");
            for (DynamicObject supCol : supCols) {
                DynamicObject entrySup = supCol.getDynamicObject("entrysupplier");
                if (!entrySup.getPkValue().toString().equals(supplier.getPkValue().toString())) continue;
                if (qualifyResult.equals("A")) {
                    isConvertStatus = false;
                    continue;
                }
                if (qualifyResult.equals("B")) {
                    supCol.set("supentrystatus", (Object)SupBidStatusEnum.BEENEXAMINED.getVal());
                } else if (qualifyResult.equals("C")) {
                    supCol.set("supentrystatus", (Object)SupBidStatusEnum.HAVEREFUSED.getVal());
                }
                supCol.set("supaudit", (Object)RequestContext.get().getUserId());
                supCol.set("supauditdate", (Object)TimeServiceHelper.now());
            }
        }
        if (isConvertStatus && (bidstatus == null || BidStatusEnum.ENROLMENT.getVal().equals(bidstatus) || BidStatusEnum.DEADLINE.getVal().equals(bidstatus))) {
            souBidBill.set("bidstatus", (Object)BidStatusEnum.BEENEXAMINED.getVal());
        }
        SaveServiceHelper.save((IDataEntityType)souBidBill.getDynamicObjectType(), (Object[])new Object[]{souBidBill});
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }
}

