/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;

public class SouRcvdepositPlugin
extends AbstractFormPlugin {
    private static final String SUPQUOENTRY = "supquoentry";
    private static final String CONFIRM = "confirm";

    public void afterCreateNewData(EventObject e) {
        this.bindData();
    }

    private void bindData() {
        DynamicObject souBidBill = this.getSouBidBill();
        if (souBidBill == null) {
            return;
        }
        this.setSupInfo(souBidBill);
    }

    private DynamicObject getSouBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        long bidBillIdLong = Long.parseLong(bidBillIdObj.toString());
        HashMap params = new HashMap(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", bidBillIdLong);
        params.put("id", idMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)SUPQUOENTRY, (boolean)false);
        DynamicObject[] objs = ORMUtil.load((String)"sou_bidbill", (String)selectFields, params);
        return objs.length == 0 ? null : objs[0];
    }

    private void setSupInfo(DynamicObject souBidBill) {
        DynamicObjectCollection quoCols = souBidBill.getDynamicObjectCollection(SUPQUOENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        model.deleteEntryData("entryentity");
        String checktype = souBidBill.getString("checktype");
        for (int j = quoCols.size() - 1; j >= 0; --j) {
            DynamicObject quoCol = (DynamicObject)quoCols.get(j);
            String supentrystatus = quoCol.get("supentrystatus").toString();
            DynamicObject quoSupplier = quoCol.getDynamicObject("entrysupplier");
            if ("2".equals(checktype)) {
                if (!SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus)) continue;
                i = this.setSupplier(i, ts, quoCol, quoSupplier);
                continue;
            }
            if (!SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) continue;
            i = this.setSupplier(i, ts, quoCol, quoSupplier);
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private int setSupplier(int i, TableValueSetter ts, DynamicObject quoCol, DynamicObject quoSupplier) {
        ts.set("supplier", quoSupplier.getPkValue(), i);
        if (quoCol.getDate("suppaydate") == null) {
            ts.set("depositstatus", (Object)Boolean.FALSE, i);
            ts.set("deposittime", null, i);
        } else {
            ts.set("depositstatus", (Object)Boolean.TRUE, i);
            ts.set("deposittime", (Object)quoCol.getDate("suppaydate"), i);
        }
        return ++i;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "confirm": {
                this.confirmDeposit();
                break;
            }
        }
    }

    private void confirmDeposit() {
        DynamicObject souBidBill = this.getSouBidBill();
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity("entryentity");
        if (souBidBill != null) {
            DynamicObjectCollection supCols = souBidBill.getDynamicObjectCollection(SUPQUOENTRY);
            for (DynamicObject col : cols) {
                DynamicObject supplier = (DynamicObject)col.get("supplier");
                boolean isRecDeposit = col.getBoolean("depositstatus");
                for (DynamicObject supCol : supCols) {
                    DynamicObject entrySup = supCol.getDynamicObject("entrysupplier");
                    if (!entrySup.getPkValue().toString().equals(supplier.getPkValue().toString())) continue;
                    if (isRecDeposit) {
                        supCol.set("supentrystatus", (Object)SupBidStatusEnum.RECEIPTDEPOSIT.getVal());
                        supCol.set("suppay", (Object)RequestContext.get().getUserId());
                        supCol.set("suppaydate", (Object)TimeServiceHelper.now());
                        continue;
                    }
                    supCol.set("suppay", null);
                    supCol.set("suppaydate", null);
                }
            }
            SaveServiceHelper.save((IDataEntityType)souBidBill.getDynamicObjectType(), (Object[])new Object[]{souBidBill});
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }
}

