/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SouTurnsQuoteMaterialFilterPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final Log logger = LogFactory.getLog(SouTurnsQuoteMaterialFilterPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit inquiryentry = (BasedataEdit)this.getControl("inquiryentry");
        if (inquiryentry != null) {
            inquiryentry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if ("inquiryentry".equals(name)) {
            List filters = e.getCustomQFilters();
            DynamicObjectCollection entryspecify = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryspecify");
            ArrayList<Long> entryIds = new ArrayList<Long>(entryspecify.size());
            for (DynamicObject entry : entryspecify) {
                long entryId = entry.getLong("inquiryentry_id");
                entryIds.add(entryId);
            }
            if (!entryIds.isEmpty()) {
                filters.add(new QFilter("id", "not in", entryIds));
            }
            Object billid = this.getModel().getValue("billid");
            filters.add(new QFilter("billid", "=", billid));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("newentry".equals(operate)) {
            this.getView().getPageCache().put("supplierF7", "1");
        } else if ("newmaterial".equals(operate)) {
            this.getView().getPageCache().put("materialF7", "1");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object billPk = param.get("billid");
        if (billPk != null) {
            DynamicObject info = QueryServiceHelper.queryOne((String)"sou_inquiry", (String)"id,totalinquiry", (QFilter[])new QFilter[]{new QFilter("id", "=", billPk)});
            Boolean enable = (Boolean)this.getModel().getValue("enable");
            if (info.getBoolean("totalinquiry") && enable != null && !enable.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"specifyadvconap"});
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("entrysupplier".equals(name)) {
            this.openF7Form(rowDataEntities, "supplierF7", "suppliernumber");
        }
        if ("entryspecify".equals(name)) {
            this.openF7Form(rowDataEntities, "materialF7", "inquiryentry");
        }
    }

    private void openF7Form(RowDataEntity[] rowDataEntities, String f7type, String name) {
        String firstF7 = this.getView().getPageCache().get(f7type);
        if (rowDataEntities.length > 0) {
            RowDataEntity entitie = rowDataEntities[0];
            logger.info("\u70b9\u51fb\u884c\u53f7\uff1a " + entitie.getRowIndex());
            logger.info("\u884c\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)entitie.getDataEntity()));
            BasedataEdit entrysupplier = (BasedataEdit)this.getView().getFlexControl(name, entitie.getRowIndex());
            if (StringUtils.isNotBlank((CharSequence)firstF7)) {
                entrysupplier.click();
            }
            this.getView().getPageCache().remove(f7type);
        }
    }
}

