/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.sou.common.SouCommonUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.common.SouSendMessageUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SouTurnsQuotePlugin
extends AbstractFormPlugin
implements UploadListener {
    protected int getMaxTurns() {
        return Integer.parseInt("20");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] urlMsgs;
        JSONArray urls = new JSONArray();
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        if (StringUtils.isNotBlank((CharSequence)tempUploadUrl)) {
            urls = JSONArray.fromObject((Object)tempUploadUrl);
        }
        if ((urlMsgs = evt.getUrls()) != null && urlMsgs.length > 0) {
            for (int i = 0; i < urlMsgs.length; ++i) {
                Map urlMsg = (Map)urlMsgs[i];
                JSONObject map = new JSONObject();
                for (Map.Entry entry : urlMsg.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                urls.add((Object)map);
            }
        }
        this.getPageCache().put("tempuploadurl", urls.toString());
    }

    public void remove(UploadEvent evt) {
        Object[] urlMsgs = evt.getUrls();
        if (urlMsgs != null && urlMsgs.length > 0) {
            JSONArray urls = new JSONArray();
            String tempUploadUrl = this.getPageCache().get("tempuploadurl");
            if (StringUtils.isNotBlank((CharSequence)tempUploadUrl)) {
                urls = JSONArray.fromObject((Object)tempUploadUrl);
            }
            Map urlMsg = (Map)urlMsgs[0];
            Iterator urlItr = urls.iterator();
            while (urlItr.hasNext()) {
                JSONObject jo = (JSONObject)urlItr.next();
                if (!StringUtils.isNotBlank((CharSequence)jo.getString("uid")) || !StringUtils.equals((CharSequence)jo.getString("uid"), (CharSequence)String.valueOf(urlMsg.get("uid")))) continue;
                urlItr.remove();
            }
            this.getPageCache().put("tempuploadurl", urls.toString());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        Map param = parameter.getCustomParams();
        Object billPk = param.get("billid");
        if (billPk != null) {
            model.setValue("billno", param.get("billno"));
            model.setValue("inquirytitle", param.get("inquirytitle"));
            model.setValue("enddate", param.get("enddate"));
            model.setValue("curr", param.get("curr"));
            model.setValue("turns", param.get("turns"));
            model.setValue("org", param.get("org"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"bar_confirm")) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            Date endDate = model.getDataEntity().getDate("enddate");
            Date currDate = TimeServiceHelper.now();
            String note = model.getValue("note").toString();
            if (endDate == null || !endDate.after(currDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SouTurnsQuotePlugin_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrysupplier");
            if (entryGrid == null || entryGrid.getSelectRows().length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\u8fdb\u884c\u91cd\u65b0\u62a5\u4ef7\u3002", (String)"SouTurnsQuotePlugin_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (note == null || note.trim().equals("")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u56e0\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SouTurnsQuotePlugin_2", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            boolean hasRule = this.validateRule(new HashMap<Long, Integer>(), model.getDataEntity(true));
            if (!hasRule) {
                evt.setCancel(true);
                return;
            }
            if (!SouPermUtil.validateBizpartner((DynamicObject)this.getModel().getDataEntity(true), (IFormView)this.getView())) {
                evt.setCancel(true);
                return;
            }
        }
    }

    protected boolean validateRule(Map<Long, Integer> infoMap, DynamicObject inquiry) {
        EntryGrid grid = (EntryGrid)this.getControl("entrysupplier");
        int[] selectRows = grid.getSelectRows();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(selectRows.length);
        for (int selectRow : selectRows) {
            map.put(selectRow, selectRow);
        }
        return SouPermUtil.validateRule((IFormView)this.getView(), (DynamicObject)inquiry, map, infoMap);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        super.afterDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "confirm": {
                String msg = event.getOperationResult().getMessage();
                if (null != msg) {
                    return;
                }
                this.confirmTurns();
                break;
            }
        }
    }

    private void confirmTurns() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = this.getSouInquiryBill();
        if (null == inquiryBill) {
            view.showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be2\u4ef7\u5355\u3002", (String)"SouTurnsQuotePlugin_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Date endDate = model.getDataEntity().getDate("enddate");
        String turns = model.getValue("turns").toString();
        String note = model.getValue("note").toString();
        inquiryBill.set("bizstatus", (Object)BizStatusEnum.ENROLMENT.getVal());
        inquiryBill.set("enddate", (Object)endDate);
        inquiryBill.set("turns", (Object)turns);
        inquiryBill.set("opener", null);
        inquiryBill.set("opendate", null);
        DynamicObjectCollection entryDyoCol = inquiryBill.getDynamicObjectCollection("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrysupplier");
        int[] rows = entryGrid.getSelectRows();
        ArrayList<DynamicObject> entrysupplier = new ArrayList<DynamicObject>(rows.length);
        for (int row : rows) {
            entrysupplier.add(this.getModel().getEntryRowEntity("entrysupplier", row));
        }
        Map selectSupplierMap = SouCommonUtil.dealQuoteSupplier((DynamicObject)inquiryBill, entrysupplier, (String)turns, (int)this.getMaxTurns());
        inquiryBill.set("isautofillprice", model.getValue("isautofillprice"));
        this.setMaterialEntryInfo(inquiryBill);
        InquiryUtil.logTurnsQuote((DynamicObject[])new DynamicObject[]{inquiryBill}, (String)note);
        this.createAttachment(inquiryBill);
        this.beforeSendMessage(inquiryBill, selectSupplierMap);
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationServiceHelper.executeOperate((String)"sendmsgforturns", (String)"sou_inquiry", (DynamicObject[])new DynamicObject[]{inquiryBill}, (OperateOption)option);
    }

    private void setMaterialEntryInfo(DynamicObject inquiryBill) {
        DynamicObjectCollection entrysupplier = this.getModel().getEntryEntity("entryspecify");
        HashMap selectSupplierMap = new HashMap((int)((double)entrysupplier.size() / 0.75));
        entrysupplier.forEach(info -> {
            long supplierId = info.getLong("inquiryentry_id");
            if (supplierId != 0L) {
                selectSupplierMap.put(info.getString("inquiryentry_id"), info);
            }
        });
        String turns = inquiryBill.getString("turns");
        DynamicObjectCollection materialentry = inquiryBill.getDynamicObjectCollection("materialentry");
        materialentry.forEach(info -> {
            if (selectSupplierMap.isEmpty() || selectSupplierMap.containsKey(info.getString("id"))) {
                info.set("newestturns", (Object)turns);
            }
        });
    }

    public void createAttachment(DynamicObject inquiryBill) {
        JSONArray urlMsgs;
        String tempUploadUrl = this.getPageCache().get("tempuploadurl");
        if (StringUtils.isNotBlank((CharSequence)tempUploadUrl) && (urlMsgs = JSONArray.fromObject((Object)tempUploadUrl)) != null && urlMsgs.size() > 0) {
            ArrayList attachList = new ArrayList(urlMsgs.size());
            for (int i = 0; i < urlMsgs.size(); ++i) {
                HashMap<String, Object> attachMap = new HashMap<String, Object>();
                JSONObject urlMsg = urlMsgs.getJSONObject(i);
                attachMap.put("lastModified", urlMsg.get("lastModified"));
                attachMap.put("name", urlMsg.get("name"));
                attachMap.put("size", urlMsg.get("size"));
                attachMap.put("status", urlMsg.get("status"));
                attachMap.put("type", urlMsg.get("type"));
                attachMap.put("uid", urlMsg.get("uid"));
                attachMap.put("url", urlMsg.get("url"));
                attachList.add(attachMap);
            }
            HashMap atts = new HashMap();
            if (attachList.size() > 0) {
                atts.put("attachmentpanel", attachList);
            }
            AttachmentServiceHelper.saveTempAttachments((String)"sou_inquiry", (Object)inquiryBill.getPkValue(), (String)"pur", atts);
        }
    }

    private void beforeSendMessage(DynamicObject dataEntity, Map<String, DynamicObject> selectSupplierMap) {
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet<Long> bizPartnerPks = new HashSet<Long>();
        for (DynamicObject row : entryCol) {
            DynamicObject supplier;
            if (SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal().equals(row.getString("supentrystatus")) || !selectSupplierMap.containsKey(row.getString("supplier_id")) || (supplier = row.getDynamicObject("supplier")) == null || !supplier.getDataEntityType().getProperties().containsKey((Object)"bizpartner_id")) continue;
            bizPartnerPks.add(row.getDynamicObject("supplier").getLong("bizpartner_id"));
        }
        List userPks = BizPartnerUtil.getSupUserIdsByBizPartner(bizPartnerPks);
        if (!userPks.isEmpty()) {
            DynamicObject person;
            Long id = dataEntity.getLong("id");
            StringBuilder content = new StringBuilder();
            content.append(dataEntity.getDynamicObject("org").getString("name")).append(ResManager.loadKDString((String)"\u901a\u77e5\uff1a\u4f60\u6709\u8be2\u4ef7\u5355", (String)"SouTurnsQuotePlugin_4", (String)"scm-sou-formplugin", (Object[])new Object[0])).append(dataEntity.getString("billno")).append(ResManager.loadKDString((String)"\u5f85\u62a5\u4ef7\uff0c\u8bf7\u5904\u7406\u3002", (String)"SouTurnsQuotePlugin_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            StringBuilder contentUrl = new StringBuilder();
            contentUrl.append(RequestContext.get().getClientUrl()).append("?formId=").append("quo_inquiry").append("&pkId=").append(id);
            HashMap<String, String> msgParams = new HashMap<String, String>();
            StringBuilder mobUrl = new StringBuilder();
            String domainContextUrl = UrlService.getDomainContextUrl();
            mobUrl.append(domainContextUrl);
            mobUrl.append("/index.html?formId=quo_inquiry&pkId=").append(dataEntity.getPkValue()).append("&type=report");
            String accountId = RequestContext.get().getAccountId();
            if (accountId != null) {
                mobUrl.append('&').append("accountId=").append(accountId);
            }
            if ((person = dataEntity.getDynamicObject("person")) != null) {
                msgParams.put("senderId", String.valueOf(person.getPkValue()));
                msgParams.put("senderName", person.getString("name"));
            } else {
                DynamicObject creator = dataEntity.getDynamicObject("creator");
                msgParams.put("senderId", String.valueOf(creator.getPkValue()));
                msgParams.put("senderName", creator.getString("name"));
            }
            msgParams.put("title", ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u5df2\u751f\u6548\uff0c\u8bf7\u53ca\u65f6\u62a5\u4ef7\u3002", (String)"SouTurnsQuotePlugin_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            msgParams.put("content", content.toString());
            msgParams.put("contentUrl", contentUrl.toString());
            msgParams.put("toMob", "true");
            msgParams.put("mobContentUrl", mobUrl.toString());
            msgParams.put("hasBizDataId", "true");
            msgParams.put("bizDataId", String.valueOf(id));
            msgParams.put("entityNumber", "quo_inquiry");
            msgParams.put("tplScene", "multiturns");
            SouSendMessageUtil.sendMessage(bizPartnerPks, (List)userPks, msgParams);
        }
    }

    private DynamicObject getSouInquiryBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Long billId = (Long)param.get("billid");
        if (billId == null) {
            return null;
        }
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"sou_inquiry");
        return billObj;
    }
}

