/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;

public class SouTurnsQuoteSupFilterPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl("suppliernumber");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inquiryentry = (BasedataEdit)this.getControl("inquiryentry");
        inquiryentry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "suppliernumber": {
                ChangeData[] changeSet = e.getChangeSet();
                String billid = String.valueOf(this.getModel().getValue("billid"));
                Map<String, Map<String, Object>> cacheMap = this.loadFromCache(billid);
                if (cacheMap == null) break;
                for (ChangeData data : changeSet) {
                    DynamicObject newValue = (DynamicObject)data.getNewValue();
                    if (newValue == null) continue;
                    String supplierId = newValue.getString("id");
                    Map<String, Object> cacheInfo = cacheMap.get(supplierId);
                    if (cacheInfo != null) {
                        Set<Map.Entry<String, Object>> entries = cacheInfo.entrySet();
                        for (Map.Entry<String, Object> next : entries) {
                            if ("suppliernumber_id".equals(next.getKey())) continue;
                            this.getModel().setValue(next.getKey(), next.getValue(), data.getRowIndex());
                        }
                        continue;
                    }
                    this.clearRfInfo(billid, data.getRowIndex());
                }
                break;
            }
        }
    }

    protected void clearRfInfo(Object billpk, int index) {
        this.getModel().setValue("supplierbizstatus", (Object)"A", index);
        this.getModel().setValue("taxamount", null, index);
        this.getModel().setValue("quoter", null, index);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object billPk = param.get("billid");
        if (billPk != null) {
            this.getModel().setValue("billid", billPk);
            this.dealSupplierEntryInfo(billPk);
            this.sortSupplierEntry();
        }
    }

    protected void dealSupplierEntryInfo(Object billpk) {
        Map<String, Map<String, Object>> cacheMap = this.loadFromCache(billpk);
        if (cacheMap != null) {
            TableValueSetter ts = new TableValueSetter(new String[0]);
            Set<Map.Entry<String, Map<String, Object>>> entries = cacheMap.entrySet();
            Iterator<Map.Entry<String, Map<String, Object>>> ito = entries.iterator();
            int seq = 0;
            while (ito.hasNext()) {
                Map.Entry<String, Map<String, Object>> next = ito.next();
                Map<String, Object> value = next.getValue();
                if (value == null || this.isSkipSpecalSupplier(value)) continue;
                Set<Map.Entry<String, Object>> infoSet = value.entrySet();
                for (Map.Entry<String, Object> info : infoSet) {
                    ts.set(info.getKey(), info.getValue(), seq);
                }
                ++seq;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entrysupplier", ts);
        }
    }

    protected boolean isSkipSpecalSupplier(Map<String, Object> value) {
        String supplierbizstatus;
        return value != null && "C".equals(supplierbizstatus = (String)value.get("supplierbizstatus"));
    }

    protected Map<String, Map<String, Object>> loadFromCache(Object billpk) {
        String cacheKey = String.valueOf(billpk);
        String value = this.getView().getPageCache().get(cacheKey);
        HashMap<String, Map<String, Object>> resultMap = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            resultMap = (HashMap<String, Map<String, Object>>)SerializationUtils.fromJsonString((String)value, Map.class);
        }
        if (resultMap == null) {
            QFilter qFilter = new QFilter("id", "=", billpk);
            DynamicObjectCollection supplyEntry = QueryServiceHelper.query((String)"sou_inquiry", (String)"org,billno,entryentity,entryentity.supplier supplier,entryentity.supplierbizstatus supplierbizstatus,entryentity.canshow canshow,entryentity.quoter quoter,entryentity.deadline deadline,entryentity.supplier.enable enable", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.deadline desc");
            resultMap = new HashMap<String, Map<String, Object>>();
            String billno = null;
            if (supplyEntry != null) {
                HashSet<Long> supplierIdSet = new HashSet<Long>();
                for (DynamicObject info : supplyEntry) {
                    billno = info.getString("billno");
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    String supplierId = info.getString("supplier");
                    if (resultMap.containsKey(supplierId) || !info.getBoolean("enable")) continue;
                    String supplierBizStatus = info.getString("supplierbizstatus");
                    supplierBizStatus = StringUtils.isBlank((CharSequence)supplierBizStatus) ? "A" : supplierBizStatus;
                    valueMap.put("supplierbizstatus", supplierBizStatus);
                    valueMap.put("quoter_id", info.get("quoter"));
                    valueMap.put("suppliernumber_id", supplierId);
                    supplierIdSet.add(info.getLong("supplier"));
                    resultMap.put(supplierId, valueMap);
                }
                this.setSupplierTaxAmount(supplierIdSet, billno, resultMap);
            }
            this.getView().getPageCache().put(cacheKey, SerializationUtils.toJsonString(resultMap));
        }
        return resultMap;
    }

    protected void sortSupplierEntry() {
        DynamicObjectCollection entry = this.getModel().getDataEntity().getDynamicObjectCollection("entrysupplier");
        entry.sort((a, b) -> {
            if ("B".equals(a.getString("supplierbizstatus")) && "B".equals(b.getString("supplierbizstatus"))) {
                BigDecimal bigDecimal = a.getBigDecimal("taxamount");
                BigDecimal decimal = b.getBigDecimal("taxamount");
                if (bigDecimal == null && decimal == null) {
                    return 0;
                }
                if (bigDecimal != null && bigDecimal.compareTo(decimal) > 0) {
                    return 1;
                }
                return -1;
            }
            if ("B".equals(a.getString("supplierbizstatus")) && !"B".equals(b.getString("supplierbizstatus"))) {
                return -1;
            }
            if (!"B".equals(a.getString("supplierbizstatus")) && "B".equals(b.getString("supplierbizstatus"))) {
                return 1;
            }
            return 0;
        });
    }

    protected void setSupplierTaxAmount(Set<Long> supplierIdSet, String billno, Map<String, Map<String, Object>> map) {
        DynamicObjectCollection collection;
        if (supplierIdSet != null && !supplierIdSet.isEmpty() && StringUtils.isNotBlank((CharSequence)billno) && map != null && (collection = this.getQuoteBillInfo(supplierIdSet, billno)) != null) {
            collection.forEach(info -> {
                Map valueMap = (Map)map.get(info.getString("supplier"));
                if (valueMap != null) {
                    BigDecimal sumtaxamount = info.getBigDecimal("sumtaxamount");
                    if ("A".equals(valueMap.get("supplierbizstatus")) && sumtaxamount != null && sumtaxamount.compareTo(BigDecimal.ZERO) > 0) {
                        valueMap.put("supplierbizstatus", "B");
                    }
                    valueMap.put("taxamount", sumtaxamount);
                }
            });
        }
    }

    protected DynamicObjectCollection getQuoteBillInfo(Set<Long> supplierIdSet, String inquiryno) {
        QFilter qFilter = new QFilter("supplier", "in", supplierIdSet);
        qFilter.and("inquiryno", "=", (Object)inquiryno).and("billstatus", "=", (Object)BizStatusEnum.CONFIRMED);
        qFilter.and("materialentry.entrystatus", "=", (Object)"A");
        return QueryServiceHelper.query((String)"sou_quote", (String)"supplier,sumtaxamount", (QFilter[])new QFilter[]{qFilter});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListSelectedRowCollection().clear();
        switch (name) {
            case "suppliernumber": {
                GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
                DynamicObjectCollection entrysupplier = this.getModel().getDataEntity(true).getDynamicObjectCollection("entrysupplier");
                ArrayList<Long> bizpartnerIdS = new ArrayList<Long>();
                for (DynamicObject supplier : entrysupplier) {
                    bizpartnerIdS.add(supplier.getLong("suppliernumber.bizpartner.id"));
                }
                List customQFilters = e.getCustomQFilters();
                if (bizpartnerIdS.size() <= 0) break;
                QFilter qFilter = new QFilter("bizpartner.id", "not in", bizpartnerIdS);
                customQFilters.add(qFilter);
                break;
            }
        }
    }
}

