/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.scm.common.parent.AbstractMultCurrencyPlugin;
import kd.scm.common.util.cal.MultCurrencyCalImpl;

public class SouCompareBillCurrencyPlugin
extends AbstractMultCurrencyPlugin {
    private MultCurrencyCalImpl currCal = new MultCurrencyCalImpl();
    private boolean isNeedChange = true;

    public void beforeBindData(EventObject e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (this.validateChangedKey(key)) {
            for (ChangeData changeData : e.getChangeSet()) {
                int rowIndex = changeData.getRowIndex();
                int currentRowIndex = model.getEntryCurrentRowIndex("materialentry");
                if (rowIndex >= 0 && currentRowIndex != rowIndex && "materialentry".equals(changeData.getDataEntity().getDataEntityType().getName())) {
                    EntryGrid grid = (EntryGrid)this.getControl("materialentry");
                    grid.selectRows(rowIndex, true);
                }
                if (!this.isNeedChange) continue;
                this.isNeedChange = false;
                if (this.currCal.isNeedChange()) {
                    this.currCal.proChanged(model, "materialentry", key);
                }
                int index = model.getEntryCurrentRowIndex("materialentry");
                Object price = model.getValue("price", index);
                Object taxprice = model.getValue("taxprice", index);
                Object exRate = model.getValue("exrate", index);
                String entryquotation = (String)model.getValue("entryquotation", index);
                Object currObj = model.getValue("curr");
                if (null != currObj && price != null && taxprice != null) {
                    DynamicObject curr = (DynamicObject)currObj;
                    BigDecimal price1 = price == null ? BigDecimal.ZERO : (BigDecimal)price;
                    BigDecimal taxprice1 = taxprice == null ? BigDecimal.ZERO : (BigDecimal)taxprice;
                    BigDecimal exRate1 = exRate == null ? BigDecimal.ZERO : (BigDecimal)exRate;
                    int scaleNumCurr = curr.getInt("priceprecision");
                    if (entryquotation != null && entryquotation.equals("1")) {
                        model.setValue("excludeunittax", (Object)price1.divide(exRate1, scaleNumCurr, RoundingMode.HALF_UP), index);
                        model.setValue("includeunittax", (Object)taxprice1.divide(exRate1, scaleNumCurr, RoundingMode.HALF_UP), index);
                    }
                    model.setValue("excludeunittax", (Object)price1.multiply(exRate1).setScale(scaleNumCurr, RoundingMode.HALF_UP), index);
                    model.setValue("includeunittax", (Object)taxprice1.multiply(exRate1).setScale(scaleNumCurr, RoundingMode.HALF_UP), index);
                }
                this.currCal.needChange(true);
                this.isNeedChange = true;
            }
        }
    }

    protected boolean validateChangedKey(String key) {
        return "qty".equals(key) || "price".equals(key) || "taxprice".equals(key) || "amount".equals(key) || "taxamount".equals(key) || "dctrate".equals(key) || "dctamount".equals(key) || "taxrate".equals(key) || "tax".equals(key);
    }

    protected String getEntryEntity() {
        return "materialentry";
    }
}

