/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.edit;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.sou.common.SouCommonUtil;
import kd.scm.sou.common.SouPermUtil;

public class SouReplenishSupplierEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit suppliernumber = (BasedataEdit)this.getControl("suppliernumber");
        if (suppliernumber != null) {
            suppliernumber.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("suppliernumber".equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
            JSONArray supplier = (JSONArray)this.getView().getFormShowParameter().getCustomParam("supplierIds");
            JSONArray bizpartner = (JSONArray)this.getView().getFormShowParameter().getCustomParam("bizpartnerIds");
            if (supplier != null && bizpartner != null) {
                HashSet bizpartnerIds = new HashSet(bizpartner.toJavaList(Long.class));
                DynamicObjectCollection entrysupplier = this.getModel().getDataEntity(true).getDynamicObjectCollection("entrysupplier");
                entrysupplier.stream().forEach(info -> {
                    if (info.getLong("suppliernumber_id") != 0L) {
                        bizpartnerIds.add(info.getLong("suppliernumber.bizpartner.id"));
                    }
                });
                if (!bizpartnerIds.isEmpty()) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("bizpartner.id", "not in", bizpartnerIds));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("newentry".equals(operate)) {
            this.getView().getPageCache().put("suppliernumber", "1");
        } else if ("confirm".equals(operate)) {
            if (!SouPermUtil.validateRule((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity(true), null, new HashMap())) {
                args.setCancel(true);
                return;
            }
            if (!SouPermUtil.validateBizpartner((DynamicObject)this.getModel().getDataEntity(true), (IFormView)this.getView())) {
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("entrysupplier".equals(name)) {
            this.openF7Form(rowDataEntities, "suppliernumber");
        }
    }

    private void openF7Form(RowDataEntity[] rowDataEntities, String supplier) {
        if (rowDataEntities.length > 0) {
            RowDataEntity entitie = rowDataEntities[0];
            String firstF7 = this.getView().getPageCache().get(supplier);
            if (StringUtils.isNotEmpty((String)firstF7)) {
                BasedataEdit entrySupplier = (BasedataEdit)this.getView().getFlexControl(supplier, entitie.getRowIndex());
                entrySupplier.click();
                this.getView().getPageCache().remove(supplier);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject souInquiryBill;
        super.afterDoOperation(args);
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("confirm".equals(operate) && (souInquiryBill = SouPermUtil.getSouInquiryBill((IFormView)this.getView())) != null) {
            String turns = souInquiryBill.getString("turns");
            DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entrysupplier");
            SouCommonUtil.dealQuoteSupplier((DynamicObject)souInquiryBill, (List)entry, (String)turns, (int)20);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{souInquiryBill});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        Map param = parameter.getCustomParams();
        model.setValue("org", param.get("org"));
    }
}

