/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.list;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.sou.common.SouBidBillUtil;
import kd.scm.sou.common.SouBidCfmBillUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.common.SouSendMessageUtil;
import kd.scm.sou.formplugin.list.SouCoreBillListPlugin;

public class SouBidBillCfmList
extends SouCoreBillListPlugin {
    private static final String ACTION_BOTPLIST = "botpList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ApiConfigUtil.hasEASConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"toorder"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_supplier"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"eas_push"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toorder"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_supplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"eas_push"});
        }
        if (ApiConfigUtil.hasCQScmConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
        }
        SouBidBillUtil.updateBidStatus();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_supplier")) {
            DynamicObject[] dyos;
            ArrayList<String> billnoList = new ArrayList<String>();
            for (DynamicObject dyo : dyos = this.getSelectData(objects)) {
                String bidStatus = dyo.getString("bidstatus");
                if (StringUtils.equals((CharSequence)bidStatus, (CharSequence)BidStatusEnum.CONFIRMED.getVal()) || StringUtils.equals((CharSequence)bidStatus, (CharSequence)BidStatusEnum.EXECUTED.getVal())) continue;
                billnoList.add(dyo.getString("billno"));
            }
            if (!billnoList.isEmpty()) {
                this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u662f\u5df2\u5b9a\u6807/\u5df2\u6267\u884c\u72b6\u6001\uff0c\u4e0d\u80fd\u751f\u6210\u4f9b\u8d27\u6e05\u5355\u3002", (String)"SouBidBillList_20", (String)"scm-sou-formplugin", (Object[])new Object[0]), ((Object)billnoList).toString()));
                evt.setCancel(true);
                return;
            }
        } else if (objects.length == 0 && "toorder".equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SouBidBillList_21", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"toorder") || StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_supplier") || StringUtils.equals((CharSequence)itemKey, (CharSequence)"baritemap1")) {
            StringBuilder errorInfo = new StringBuilder();
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Object[] pks = selectedRows.getPrimaryKeyValues();
            DynamicObjectCollection bidBills = QueryServiceHelper.query((String)"sou_bidbillcfm", (String)"id,billno,entryentity1.entrysupplier.supplier_status.number,entryentity1.supentrystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
            for (DynamicObject bidBill : bidBills) {
                if (!SupBidStatusEnum.WINTHEBID.getVal().equals(bidBill.getString("entryentity1.supentrystatus")) || !"QZGYS".equals(bidBill.getString("entryentity1.entrysupplier.supplier_status.number"))) continue;
                errorInfo.append(bidBill.getString("billno")).append(":").append(ResManager.loadKDString((String)"\u4e2d\u6807\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u8ba4\u8bc1\u4e3a\u6b63\u5f0f\u4f9b\u5e94\u5546\u624d\u80fd\u5173\u8054\u4e0b\u6e38\u5355\u636e\u3002", (String)"SouBidBillCfmList_7", (String)"scm-sou-formplugin", (Object[])new Object[0])).append("\n");
            }
            String errorString = errorInfo.toString();
            if (!"".equals(errorString)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6f5c\u5728\u4f9b\u5e94\u5546\u6821\u9a8c", (String)"SouBidBillList_25", (String)"scm-sou-formplugin", (Object[])new Object[0]), errorString, MessageTypes.Default);
                evt.setCancel(true);
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "bidaudit": {
                    this.confirmBid();
                    break;
                }
                case "returncash": {
                    this.retDeposit();
                    break;
                }
                case "bidhall": {
                    SouBidBillUtil.openBidHall((String)"sou_bidbillcfm", (IFormView)this.getView(), (DynamicObject)this.getSelectData(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "bidHallAtionId"));
                    break;
                }
                case "terminate": {
                    this.terninate();
                    break;
                }
                case "toeasorder": {
                    this.toOrder();
                    break;
                }
                case "mytrackup": {
                    this.trackUp();
                    break;
                }
            }
        }
    }

    private void confirmBid() {
        DynamicObject souBillCfmObj = this.getSelectData();
        if (souBillCfmObj == null) {
            return;
        }
        IFormView view = this.getView();
        String bidStatus = souBillCfmObj.getString("bidstatus");
        String autoconfirm = souBillCfmObj.getString("autoconfirm");
        if (!bidStatus.equals(BidStatusEnum.EVALUATING.getVal())) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u662f\u8bc4\u6807\u4e2d\uff0c\u65e0\u6cd5\u5b9a\u6807\u3002", (String)"SouBidBillCfmList_0", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        if ("true".equals(autoconfirm)) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5b9a\u6807\u7684\u9879\u76ee\u4e0d\u5141\u8bb8\u624b\u52a8\u5b9a\u6807\u5ba1\u6279\u3002", (String)"SouBidBillCfmEdit_13", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        Object curr = souBillCfmObj.getDynamicObject("curr").getPkValue();
        String quotemode = souBillCfmObj.getString("quotemode");
        MutexHelper.require((String)souBillCfmObj.getDataEntityType().getName(), (Object)souBillCfmObj.getPkValue(), (String)"bidaudit", (boolean)true, (StringBuilder)new StringBuilder(1));
        if (StringUtils.equals((CharSequence)quotemode, (CharSequence)"2")) {
            this.openDealPage("sou_bidconfirmbyentry", souBillCfmObj.getPkValue(), "bidAuditActionId", curr, ShowType.Modal);
        } else {
            this.openDealPage("sou_bidconfirm", souBillCfmObj.getPkValue(), "tblauditActionId", curr, ShowType.Modal);
        }
    }

    private void terninate() {
        DynamicObject souBillCfmObj = this.getSelectData();
        if (souBillCfmObj == null) {
            return;
        }
        String bidStatus = souBillCfmObj.getString("bidstatus");
        if (bidStatus.equals(BidStatusEnum.END.getVal())) {
            this.getView().showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u7684\u9879\u76ee\u4e0d\u5141\u8bb8\u518d\u6682\u505c\u3001\u7ed3\u675f\u3001\u7ec8\u6b62\u3002", (String)"SouBidBillCfmList_1", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        this.openDealPage("sou_exception", souBillCfmObj.getPkValue(), "tblterminateActionId", "", ShowType.Modal);
    }

    private void retDeposit() {
        DynamicObject souBillCfmObj = this.getSelectData();
        if (souBillCfmObj == null) {
            return;
        }
        IFormView view = this.getView();
        String bidStatus = souBillCfmObj.getString("bidstatus");
        BigDecimal cashDeposit = CommonUtil.getBigDecimalPro((Object)souBillCfmObj.get("cashdeposit"));
        if (cashDeposit.compareTo(BigDecimal.ZERO) == 0) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u4e3a\u96f6\uff0c\u65e0\u987b\u9000\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillCfmList_3", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        if (!bidStatus.equals(BidStatusEnum.CONFIRMED.getVal()) && !bidStatus.equals(BidStatusEnum.EXECUTED.getVal())) {
            view.showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u672a\u5b9a\u6807\uff0c\u65e0\u6cd5\u9000\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillCfmList_4", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        this.openDealPage("sou_retdeposit", souBillCfmObj.getPkValue(), "tblcashActionId", "", ShowType.Modal);
    }

    protected DynamicObject getSelectData() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length != 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u5206\u5f55\u64cd\u4f5c\u3002", (String)"SouBidBillCfmList_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject[] objs = this.getSelectData(objects);
        return objs.length > 0 ? objs[0] : null;
    }

    protected DynamicObject[] getSelectData(Object[] ids) {
        ArrayList idList = new ArrayList();
        if (ids != null) {
            Collections.addAll(idList, ids);
        } else {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
            Collections.addAll(idList, objects);
        }
        List idLists = CommonUtil.getLongList(idList);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbillcfm", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbillcfm", (String)"entryentity", (boolean)false);
        HashMap filterMap = new HashMap(2);
        HashMap<String, List> idMap = new HashMap<String, List>(1);
        idMap.put("in", idLists);
        filterMap.put("id", idMap);
        return ORMUtil.load((String)"sou_bidbillcfm", (String)selectFields, filterMap);
    }

    private void openDealPage(String pageKey, Object pkVale, String actionId, Object obj, ShowType type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bidBillId", pkVale);
        paramMap.put("curr", obj);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)type));
    }

    public void push1688(ItemClickEvent evt) {
    }

    protected void toOrder() {
        IFormView view = this.getView();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        DynamicObject[] dynamicObjs = this.getSelectData(pks);
        if (null == dynamicObjs) {
            view.showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"SouBidBillCfmList_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        Map resultMap = SouBidCfmBillUtil.verifyEASOrder((DynamicObject[])dynamicObjs);
        if ("true".equals(resultMap.get("succed"))) {
            if ("".equals(resultMap.get("botp"))) {
                DynamicObject[] objs = this.getSelectData(pks);
                SouBidCfmBillUtil.toOrder((DynamicObject[])objs, (String)"entryentity", null, (IFormView)view);
            } else {
                this.openBotpListPage(CommonUtil.objs2str((Object[])pks), (List)resultMap.get("botp"), "order");
            }
        }
        if ("false".equals(resultMap.get("succed"))) {
            this.getView().showMessage(resultMap.get("title").toString(), resultMap.get("message").toString(), MessageTypes.Default);
            return;
        }
    }

    protected void openBotpListPage(String pkStr, List<Object> ruleList, String toBillType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleList);
        param.put("tobilltype", toBillType);
        param.put("pkstr", pkStr);
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"pur_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal);
        this.getView().showForm(formParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            switch (closedCallBackEvent.getActionId()) {
                case "tblauditActionId": 
                case "bidAuditActionId": {
                    DynamicObject selectData = this.getSelectData();
                    MutexHelper.release((String)selectData.getDataEntityType().getName(), (String)"bidaudit", (String)String.valueOf(selectData.get("id")));
                }
            }
            return;
        }
        Map result = (Map)returnData;
        switch (closedCallBackEvent.getActionId()) {
            case "tblauditActionId": 
            case "bidAuditActionId": {
                boolean isConfirmed = (Boolean)result.get("isConfirmed");
                DynamicObject selectData = this.getSelectData();
                if (isConfirmed) {
                    String billno = selectData.getString("billno");
                    this.beforeSendMessage(billno);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("isStrict", "false");
                    OperationServiceHelper.executeOperate((String)"sendmsgtowin", (String)"sou_bidbillcfm", (Object[])new Object[]{selectData.get("id")}, (OperateOption)option);
                    OperationServiceHelper.executeOperate((String)"sendmsgtofail", (String)"sou_bidbillcfm", (Object[])new Object[]{selectData.get("id")}, (OperateOption)option);
                    this.getView().invokeOperation("bidauditconfirm");
                }
                MutexHelper.release((String)selectData.getDataEntityType().getName(), (String)"bidaudit", (String)String.valueOf(selectData.get("id")));
                break;
            }
            case "botpList": {
                Object ruleNumber = result.get("rule");
                if (ruleNumber == null) {
                    return;
                }
                Object[] pks = CommonUtil.str2objs((String)String.valueOf(result.get("pkstr")), (String)",");
                this.pushOrder(pks, String.valueOf(ruleNumber));
                break;
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private void pushOrder(Object[] pks, String botpNumber) {
        DynamicObject[] objs = this.getSelectData(pks);
        IFormView view = this.getView();
        SouBidCfmBillUtil.toOrder((DynamicObject[])objs, (String)"entryentity", (String)botpNumber, (IFormView)view);
    }

    private void trackUp() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        if (pks == null || pks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SouBidBillList_18", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        Long pkId = (Long)pks[0];
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> noPermBill = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbillcfm", (String)"sou_bidbill")) {
            noPermBill.add("sou_bidbill");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u7ade\u4ef7\u53d1\u5e03\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouBidBillCfmList_11", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbillcfm", (String)"sou_notice")) {
            noPermBill.add("sou_notice");
            errMsgList.add(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u516c\u544a\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouBidBillCfmList_12", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        String errMsg = String.join((CharSequence)"\uff0c", errMsgList);
        Map<String, HashSet<Long>> result = this.getTrackUpBill(pks);
        result.entrySet().removeIf(entry -> noPermBill.contains(entry.getKey()));
        if (!noPermBill.isEmpty() && result.isEmpty()) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("param", result);
        if (!errMsgList.isEmpty()) {
            customParams.put("permMsg", errMsg);
        }
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formParam);
    }

    private Map<String, HashSet<Long>> getTrackUpBill(Object[] pks) {
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>();
        HashSet<Long> cfmPkSet = new HashSet<Long>();
        for (Object pk : pks) {
            cfmPkSet.add((Long)pk);
        }
        resultMap.put("sou_bidbill", cfmPkSet);
        Map noticeResult = BFTrackerServiceHelper.findTargetBills((String)"sou_bidbill", (Long[])cfmPkSet.toArray(new Long[0]));
        if (noticeResult != null && !noticeResult.isEmpty() && noticeResult.get("sou_notice") != null) {
            resultMap.put("sou_notice", (HashSet<Long>)noticeResult.get("sou_notice"));
        }
        return resultMap;
    }

    public boolean hasQZGYS() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"sou_bidbillcfm", (String)"entryentity1.entrysupplier.supplier_status.number,entryentity1.supentrystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)}, null);){
            for (Row row : ds) {
                boolean isHasQZGYS;
                boolean bl = isHasQZGYS = SupBidStatusEnum.WINTHEBID.getVal().equals(row.getString("entryentity1.supentrystatus")) && "QZGYS".equals(row.getString("entryentity1.entrysupplier.supplier_status.number"));
                if (!isHasQZGYS) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        return false;
    }

    public void setFilter(SetFilterEvent e) {
        e.addCustomQFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        e.setOrderBy("billstatus,billdate desc");
    }

    private void beforeSendMessage(String billno) {
        DynamicObjectCollection bidBillCfmDC = QueryServiceHelper.query((String)"sou_bidbillcfm", (String)"billno,entryentity1.entrysupplier.bizpartner_id,entryentity1.supenroll.id,entryentity1.supentrystatus,person.name,creator.name,person.id,creator.id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        for (DynamicObject supplierDO : bidBillCfmDC) {
            String adoptStr;
            long bizPartnerPkId = supplierDO.getLong("entryentity1.entrysupplier.bizpartner_id");
            long supenroll = supplierDO.getLong("entryentity1.supenroll.id");
            if (bizPartnerPkId == 0L) continue;
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(supenroll);
            DynamicObject quoBidBillDO = QueryServiceHelper.queryOne((String)"quo_bidbill", (String)"id,billno,name", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            if ("F".equals(supplierDO.getString("entryentity1.supentrystatus"))) {
                adoptStr = ResManager.loadKDString((String)"\u5df2\u4e2d\u6807", (String)"SouBidBillCfmList_13", (String)"scm-sou-formplugin", (Object[])new Object[0]);
            } else {
                if (!"G".equals(supplierDO.getString("entryentity1.supentrystatus"))) continue;
                adoptStr = ResManager.loadKDString((String)"\u672a\u4e2d\u6807", (String)"SouBidBillCfmList_14", (String)"scm-sou-formplugin", (Object[])new Object[0]);
            }
            if (quoBidBillDO == null) continue;
            String content = MessageFormat.format(ResManager.loadKDString((String)"\u7ade\u4ef7\u67e5\u8be2\u5355\uff08\u9879\u76ee\u540d\u79f0\uff1a{0}\uff0c\u9879\u76ee\u7f16\u53f7\uff1a{1}\uff09\u7684\u7ed3\u679c\u72b6\u6001\u4e3a{2}\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SouBidBillCfmList_9", (String)"scm-sou-formplugin", (Object[])new Object[0]), quoBidBillDO.getString("name"), quoBidBillDO.getString("billno"), adoptStr);
            HashMap<String, String> msgParams = new HashMap<String, String>();
            String personName = supplierDO.getString("person.name");
            if (personName != null && !"".equals(personName)) {
                msgParams.put("senderId", String.valueOf(supplierDO.getLong("person.id")));
                msgParams.put("senderName", personName);
            } else {
                String creatorName = supplierDO.getString("creator.name");
                msgParams.put("senderId", String.valueOf(supplierDO.getLong("creator.id")));
                msgParams.put("senderName", creatorName);
            }
            msgParams.put("title", ResManager.loadKDString((String)"\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5", (String)"SouBidBillCfmList_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            msgParams.put("failMsgTitle", ResManager.loadKDString((String)"\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u901a\u77e5\u4e1a\u52a1\u90e8\u95e8\u8ddf\u8fdb\u3002", (String)"SouBidBillCfmList_10", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            msgParams.put("content", content);
            msgParams.put("failMsgContent", String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e3a\u53d1\u9001\u5931\u8d25\u4fe1\u606f\uff1a%1$s", (String)"SouBidBillCfmEdit_9", (String)"scm-sou-formplugin", (Object[])new Object[0]), content));
            msgParams.put("toMob", "false");
            msgParams.put("hasBizDataId", "false");
            msgParams.put("contentUrl", RequestContext.get().getClientUrl() + "?formId=" + "quo_bidbill" + "&pkId=" + quoBidBillDO.getLong("id"));
            HashSet<Long> bizPartnerPkIds = new HashSet<Long>();
            bizPartnerPkIds.add(bizPartnerPkId);
            SouSendMessageUtil.sendMessage(bizPartnerPkIds, ids, msgParams);
        }
    }
}

