/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.sou.common.SouBidBillUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.formplugin.list.SouCoreBillListPlugin;
import net.sf.json.JSONArray;

public class SouBidBillList
extends SouCoreBillListPlugin {
    private static final String ACTION_BOTPLIST = "botpList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject bidBill;
        if ("bidalertdate".equals(evt.getOperationKey()) && null == (bidBill = this.getSelectData())) {
            evt.setCancel(true);
        }
    }

    private void trackDown() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        if (pks == null || pks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SouBidBillList_21", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection selectDatas = QueryServiceHelper.query((String)"sou_bidbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        DynamicObject first = (DynamicObject)selectDatas.get(0);
        Long pkId = first.getLong("id");
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> noPermBill = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbill", (String)"sou_bidbillcfm")) {
            noPermBill.add("sou_bidbillcfm");
            errMsgList.add(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709[\u7ade\u4ef7\u5b9a\u6807]\u7684[\u67e5\u8be2]\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"SouBidBillList_23", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_bidbill", (String)"sou_notice")) {
            noPermBill.add("sou_notice");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u516c\u544a\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouBidBillList_22", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sou_bidbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        ArrayList ids = new ArrayList(1024);
        query.forEach(info -> {
            if (info != null && BillStatusEnum.AUDIT.getVal().equals(info.getString("billstatus"))) {
                ids.add(info.getLong("id"));
            }
        });
        if (ids.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ade\u4ef7\u9879\u76ee\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u4e0b\u6e38\u73af\u8282\u3002", (String)"SouBidBillEditPlugin_22", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        pks = ids.toArray();
        String errMsg = String.join((CharSequence)"\uff0c", errMsgList);
        Map<String, HashSet<Long>> result = this.getTrackDownBill(pks);
        result.entrySet().removeIf(entry -> noPermBill.contains(entry.getKey()));
        if (!noPermBill.isEmpty() && result.isEmpty()) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("param", result);
        if (!errMsgList.isEmpty()) {
            customParams.put("permMsg", errMsg);
        }
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formParam);
    }

    private Map<String, HashSet<Long>> getTrackDownBill(Object[] pks) {
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>();
        HashSet<Long> cfmPkSet = new HashSet<Long>();
        for (Object pk : pks) {
            cfmPkSet.add((Long)pk);
        }
        resultMap.put("sou_bidbillcfm", cfmPkSet);
        Map noticeResult = BFTrackerServiceHelper.findTargetBills((String)"sou_bidbill", (Long[])cfmPkSet.toArray(new Long[0]));
        if (noticeResult != null && !noticeResult.isEmpty()) {
            resultMap.put("sou_notice", (HashSet<Long>)noticeResult.get("sou_notice"));
        }
        return resultMap;
    }

    private void openDealPage(String pageKey, Object pkVale, String actionId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("bidBillId", pkVale);
        if (actionId == null) {
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, null, (ShowType)ShowType.Modal));
        } else {
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)ShowType.Modal));
        }
    }

    private void supQulify() {
        DynamicObjectCollection col;
        DynamicObject souBillObj = this.getSelectData();
        if (souBillObj == null) {
            return;
        }
        IFormView view = this.getView();
        String checkType = souBillObj.getString("checktype");
        if (checkType != null && "3".equals(checkType)) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u8d44\u683c\u514d\u5ba1\uff0c\u65e0\u987b\u5ba1\u67e5\u3002", (String)"SouBidBillList_5", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        String bidStatus = souBillObj.getString("bidstatus");
        if ("2".equals(checkType) && !BidStatusEnum.BIDDING.getVal().equals(bidStatus) && !BidStatusEnum.EVALUATING.getVal().equals(bidStatus)) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u8d44\u683c\u540e\u5ba1\u53ea\u80fd\u5728\u201c\u7ade\u4ef7\u4e2d\u201d\u6216\u201c\u8bc4\u6807\u4e2d\u201d\u8fdb\u884c\u3002", (String)"SouBidBillList_6", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        if ("1".equals(checkType) || "3".equals(checkType)) {
            this.getView().invokeOperation("refresh");
            if (!bidStatus.equals(BidStatusEnum.DEADLINE.getVal())) {
                view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u662f\u62a5\u540d\u622a\u6b62\u7684\u7ade\u4ef7\u5355\u4e0d\u5141\u8bb8\u8d44\u5ba1\u3002", (String)"SouBidBillList_8", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
                return;
            }
        }
        if ((col = souBillObj.getDynamicObjectCollection("supquoentry")).isEmpty()) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u65e0\u4f9b\u5e94\u5546\u62a5\u540d\uff0c\u4e0d\u5141\u8bb8\u8d44\u5ba1\u3002", (String)"SouBidBillList_9", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = souBillObj.getDynamicObjectCollection("supquoentry");
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u672a\u62a5\u540d\uff0c\u65e0\u6cd5\u8d44\u5ba1\u3002", (String)"SouBidBillList_10", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        int count = 0;
        for (DynamicObject bidBill : dynamicObjectCollection) {
            String supentrystatus = bidBill.getString("supentrystatus");
            if (!SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus)) continue;
            ++count;
        }
        if (count == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u8d44\u5ba1\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u68c0\u67e5\u53c2\u4e0e\u4f9b\u5e94\u5546\u662f\u5426\u4e3a\u5f85\u8d44\u5ba1\u72b6\u6001\u3002", (String)"SouBidBillList_24", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openDealPage("sou_qualify", souBillObj.getPkValue(), "comfirmaction");
    }

    private void recDeposit() {
        DynamicObject souBillObj = this.getSelectData();
        if (souBillObj == null) {
            return;
        }
        IFormView view = this.getView();
        DynamicObjectCollection col = souBillObj.getDynamicObjectCollection("supquoentry");
        if (col.isEmpty()) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u5728\u4f9b\u5e94\u5546\u62a5\u540d\u4ee5\u540e\u518d\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillList_11", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        String bidStatus = souBillObj.getString("bidstatus");
        if (!(bidStatus.equals(BidStatusEnum.ENROLMENT.getVal()) || bidStatus.equals(BidStatusEnum.DEADLINE.getVal()) || bidStatus.equals(BidStatusEnum.BEENEXAMINED.getVal()))) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u662f\u62a5\u540d\u4e2d\uff0c\u62a5\u540d\u622a\u6b62\u548c\u5df2\u8d44\u5ba1\u7684\u7ade\u4ef7\u5355\u4e0d\u5141\u8bb8\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillList_12", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        BigDecimal cashDeposit = CommonUtil.getBigDecimalPro((Object)souBillObj.get("cashdeposit"));
        if (cashDeposit.compareTo(BigDecimal.ZERO) == 0) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u4e3a\u96f6\uff0c\u65e0\u987b\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillList_13", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        int count = 0;
        for (DynamicObject dyna : col) {
            String supentrystatus = dyna.getString("supentrystatus");
            if (!SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) continue;
            ++count;
        }
        if (count == 0) {
            view.showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u8d44\u5ba1\u901a\u8fc7\uff0c\u65e0\u6cd5\u6536\u4fdd\u8bc1\u91d1\u3002", (String)"SouBidBillList_14", (String)"scm-sou-formplugin", (Object[])new Object[0])).toString());
            return;
        }
        this.openDealPage("sou_rcvdeposit", souBillObj.getPkValue(), null);
    }

    protected DynamicObject getSelectData() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length != 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u5206\u5f55\u64cd\u4f5c\u3002", (String)"SouBidBillList_15", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject[] objs = this.getSelectData(objects);
        return objs.length > 0 ? objs[0] : null;
    }

    protected DynamicObject[] getSelectData(Object[] ids) {
        ArrayList idList = new ArrayList();
        if (ids != null) {
            Collections.addAll(idList, ids);
        } else {
            BillList list = (BillList)this.getView().getControl("billlistap");
            Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
            Collections.addAll(idList, objects);
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)"materialentry", (boolean)false);
        selectFields = selectFields + ",supquoentry.id,supquoentry.supentrystatus";
        HashMap filterMap = new HashMap(2);
        HashMap idMap = new HashMap(1);
        idMap.put("in", idList);
        filterMap.put("id", idMap);
        return ORMUtil.load((String)"sou_bidbill", (String)selectFields, filterMap);
    }

    public void push1688(ItemClickEvent evt) {
    }

    protected void toOrder() {
        IFormView view = this.getView();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        DynamicObject[] dynamicObjs = this.getSelectData(pks);
        if (null == dynamicObjs) {
            view.showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"SouBidBillList_16", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String inwareRules = SouBidBillUtil.getBotpRule((DynamicObject[])dynamicObjs, (String)"order");
        if (StringUtils.isEmpty((String)inwareRules)) {
            view.showMessage(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"SouBidBillList_17", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONArray orderRuleList = JSONArray.fromObject((Object)inwareRules);
        if (!orderRuleList.isEmpty()) {
            this.openBotpListPage(CommonUtil.objs2str((Object[])pks), (List<Object>)orderRuleList, "order");
        }
    }

    protected void openBotpListPage(String pkStr, List<Object> ruleList, String toBillType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleList);
        param.put("tobilltype", toBillType);
        param.put("pkstr", pkStr);
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"pur_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal);
        this.getView().showForm(formParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "botpList": {
                Object botpListCondition = closedCallBackEvent.getReturnData();
                if (botpListCondition == null) {
                    return;
                }
                Map result = (Map)botpListCondition;
                Object ruleNumber = result.get("rule");
                if (ruleNumber == null) {
                    return;
                }
                Object[] pks = CommonUtil.str2objs((String)String.valueOf(result.get("pkstr")), (String)",");
                this.pushOrder(pks, String.valueOf(ruleNumber));
                break;
            }
            case "comfirmaction": {
                this.getView().updateView();
                break;
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private void pushOrder(Object[] pks, String botpNumber) {
        DynamicObject[] objs = this.getSelectData(pks);
        IFormView view = this.getView();
        SouBidBillUtil.toOrder((DynamicObject[])objs, (String)botpNumber, (IFormView)view);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("bidhall".equals(operate)) {
            DynamicObject bidBill = this.getSelectData();
            if (bidBill != null) {
                DynamicObject query = QueryServiceHelper.queryOne((String)"sou_bidbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidBill.getLong("id"))});
                if (query != null && !BillStatusEnum.AUDIT.getVal().equals(query.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001\u7684\u7ade\u4ef7\u53d1\u5e03\u5355\u624d\u80fd\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"SouBidBillEditPlugin_23", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (null != afterDoOperationEventArgs.getOperationResult() && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "bidalertdate": {
                DynamicObject bidBill = this.getSelectData();
                if (null == bidBill) {
                    return;
                }
                SouBidBillUtil.bidAlertDate((IFormView)this.getView(), (DynamicObject)bidBill, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "bidAlertDate"));
                break;
            }
            case "supaudit": {
                this.supQulify();
                break;
            }
            case "bidcash": {
                this.recDeposit();
                break;
            }
            case "bidhall": {
                SouBidBillUtil.openBidHall((String)"sou_bidbill", (IFormView)this.getView(), (DynamicObject)this.getSelectData(), null);
                break;
            }
            case "mytrackdown": {
                this.trackDown();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SouBidBillUtil.updateBidStatus();
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("id desc");
    }
}

