/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.list;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SouOpenTypeEnum;
import kd.scm.common.util.BOTPUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.sou.common.SouInquiryUtil;
import kd.scm.sou.common.SouPermUtil;
import kd.scm.sou.formplugin.list.SouCoreBillListPlugin;

public class SouInquiryList
extends SouCoreBillListPlugin {
    private static final String CONFIRMCOMPARE_ACTIONID = "confirmCompareActionId";

    protected String getMaxTurns() {
        return "20";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operate = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operate) {
                case "alertdate": {
                    this.alertDate();
                    break;
                }
                case "terminate": {
                    this.terminateInquiryBill();
                    break;
                }
                case "compareresult": {
                    this.compareResult();
                    break;
                }
                case "compare": {
                    if (this.validateCompare()) {
                        return;
                    }
                    this.compareTool();
                    break;
                }
                case "turns": {
                    this.turnsQuote();
                    break;
                }
                case "mytrackdown": {
                    this.trackDown();
                    break;
                }
            }
        }
    }

    private void trackDown() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SouInquiryList_16", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection selectDatas = QueryServiceHelper.query((String)"sou_inquiry", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)objects)});
        DynamicObject first = (DynamicObject)selectDatas.get(0);
        Long pkId = first.getLong("id");
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> noPermBill = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_quote")) {
            noPermBill.add("sou_quote");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u62a5\u4ef7\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryList_22", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_notice")) {
            noPermBill.add("sou_notice");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u516c\u544a\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryList_23", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_compare")) {
            noPermBill.add("sou_compare");
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6bd4\u4ef7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryList_24", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        String errMsg = String.join((CharSequence)"\uff0c", errMsgList);
        Map<String, HashSet<Long>> result = this.getTrackDownBill(objects, list);
        result.entrySet().removeIf(entry -> noPermBill.contains(entry.getKey()));
        if (!noPermBill.isEmpty() && result.isEmpty()) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        ArrayList<String> billNoList = new ArrayList<String>();
        QFilter idFilter = new QFilter("id", "in", (Object)objects);
        DynamicObjectCollection dyoCollection = QueryServiceHelper.query((String)"sou_inquiry", (String)"id,opentype,bizstatus,billno", (QFilter[])new QFilter[]{idFilter});
        if (null != dyoCollection && dyoCollection.size() > 0) {
            for (DynamicObject dyo : dyoCollection) {
                String openType = dyo.getString("opentype");
                String status = dyo.getString("bizstatus");
                if (!openType.equals(SouOpenTypeEnum.INVISIBLE_AUTOOPEN.getVal()) && !openType.equals(SouOpenTypeEnum.INVISIBLE_MANUALOPEN.getVal()) || !status.equals("A")) continue;
                billNoList.add(dyo.getString("billno"));
            }
        }
        if (billNoList.size() > 0) {
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355{0}\u672a\u5f00\u6807\uff0c\u4e0d\u80fd\u4e0b\u67e5\u5355\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SouInquiryList_20", (String)"scm-sou-formplugin", (Object[])new Object[0]), ((Object)billNoList).toString()));
            return;
        }
        if (result.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"SouInquiryList_17", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("param", result);
        if (!errMsgList.isEmpty()) {
            customParams.put("permMsg", errMsg);
        }
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"sou_lookuptracker", customParams, null, (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(formParam);
    }

    private Map<String, HashSet<Long>> getTrackDownBill(Object[] inquiryPKObjs, BillList list) {
        Map noticeResult;
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        QFilter originFilter = new QFilter("origin", "=", (Object)"1");
        QFilter supFilter = filter.and(originFilter);
        QFilter purOriginfilter = new QFilter("origin", "=", (Object)"2");
        HashMap<String, String> entityOfPro = new HashMap<String, String>();
        entityOfPro.put("sou_quote", "inquiryno");
        Map result = BOTPUtil.getTrackDownBillByFilter((Object[])inquiryPKObjs, (String)list.getBillFormId(), entityOfPro, (QFilter)supFilter.or(purOriginfilter));
        entityOfPro.clear();
        entityOfPro.put("sou_compare", "inquiryno");
        Map compareResult = BOTPUtil.getTrackDownBillByFilter((Object[])inquiryPKObjs, (String)list.getBillFormId(), entityOfPro, null);
        if (null != compareResult) {
            result.put("sou_compare", compareResult.get("sou_compare"));
        }
        if ((noticeResult = BFTrackerServiceHelper.findTargetBills((String)"sou_inquiry", (Long[])((Long[])Arrays.stream(inquiryPKObjs).map(p -> Long.valueOf(p.toString())).toArray(Long[]::new)))) != null && !noticeResult.isEmpty()) {
            result.put("sou_notice", noticeResult.get("sou_notice"));
        }
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (null != entry.getValue() && !((HashSet)entry.getValue()).isEmpty()) continue;
            it.remove();
        }
        return result;
    }

    private boolean validateCompare() {
        IFormView view = this.getView();
        BillList list = (BillList)view.getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        DynamicObjectCollection selectDatas = QueryServiceHelper.query((String)"sou_inquiry", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)objects)});
        DynamicObject first = (DynamicObject)selectDatas.get(0);
        Long pkId = first.getLong("id");
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_inquiry")) {
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8be2\u4ef7\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryList_26", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_quote")) {
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u62a5\u4ef7\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryList_22", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!SouPermUtil.hasSouBillViewRightForOrg((Long)pkId, (String)"sou_inquiry", (String)"sou_comparetool")) {
            errMsgList.add(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6bd4\u4ef7\u52a9\u624b\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SouInquiryList_25", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        }
        if (!errMsgList.isEmpty()) {
            view.showErrorNotification(String.join((CharSequence)"\uff0c", errMsgList));
            return true;
        }
        DynamicObject inquiryBill = BillFormUtil.getSelectData((IFormView)view, (String)"sou_inquiry");
        if (inquiryBill == null) {
            return true;
        }
        String billSatus = inquiryBill.getString("billstatus");
        String bizstatus = String.valueOf(inquiryBill.getString("bizstatus"));
        if (!BillStatusEnum.AUDIT.getVal().equals(billSatus)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        Date enddate = inquiryBill.getDate("enddate");
        String billno = inquiryBill.getString("billno");
        ArrayList<String> billNos = new ArrayList<String>();
        billNos.add(inquiryBill.getString("billno"));
        DynamicObject[] quoteBills = InquiryUtil.getQuoteBillByInquiryBillNo(billNos);
        if ("A".equals(bizstatus)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u672a\u5f00\u6807\uff0c\u4e0d\u80fd\u8fdb\u884c\u6bd4\u4ef7\u3002", (String)"SouInquiryList_27", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        if ("E".equals(bizstatus)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject[] compareCol = SouInquiryUtil.getCompareData((String)billno);
        if (compareCol != null && compareCol.length >= 1) {
            String compareBillStatus;
            switch (compareBillStatus = compareCol[0].getString("billstatus")) {
                case "B": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u63d0\u4ea4\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_29", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "C": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_30", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_4", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                }
            }
            return true;
        }
        if (quoteBills.length == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f9b\u5e94\u5546\u62a5\u4ef7\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_6", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (enddate.after(new Date())) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u672a\u5230\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void compareTool() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = BillFormUtil.getSelectData((IFormView)view, (String)"sou_inquiry");
        if (inquiryBill == null) {
            return;
        }
        String billno = inquiryBill.getString("billno");
        String billSatus = inquiryBill.getString("billstatus");
        String bizstatus = String.valueOf(inquiryBill.getString("bizstatus"));
        String opentype = inquiryBill.getString("opentype");
        Date enddate = inquiryBill.getDate("enddate");
        if (BillStatusEnum.AUDIT.getVal().equals(billSatus) && ("B".equals(bizstatus) || SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal().equals(opentype) && enddate.before(new Date()))) {
            DynamicObject[] savedCompareData = SouInquiryUtil.getSavedCompareData((String)billno);
            if (savedCompareData.length != 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMCOMPARE_ACTIONID, (IFormPlugin)this);
                String confirmTip = MessageFormat.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355{0}\u5df2\u751f\u6210\u4fdd\u5b58\u7684\u6bd4\u4ef7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouInquiryList_28", (String)"scm-sou-formplugin", (Object[])new Object[0]), billno);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"SouInquiryList_5", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openDealPage("sou_comparetool", "compareToolAtionId", billno, ShowType.MainNewTabPage);
    }

    private void terminateInquiryBill() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = BillFormUtil.getSelectData((IFormView)view, (String)"sou_inquiry");
        if (inquiryBill == null) {
            return;
        }
        Object bizstatus = inquiryBill.get("bizstatus");
        if (bizstatus.equals("D")) {
            view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u6267\u884c\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"SouInquiryList_7", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        if (bizstatus.equals("E")) {
            view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u65e0\u9700\u7ec8\u6b62\u3002", (String)"SouInquiryList_8", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String billno = inquiryBill.getString("billno");
        QFilter qFilter = new QFilter("inquiryno", "=", (Object)billno);
        DynamicObject souCompareDyn = QueryServiceHelper.queryOne((String)"sou_compare", (String)"id,inquiryno", (QFilter[])new QFilter[]{qFilter});
        if (souCompareDyn != null) {
            QFilter qFilter2 = new QFilter("billentry.srcbillid", "=", (Object)souCompareDyn.getLong("id"));
            DynamicObject pmOrderDyn = QueryServiceHelper.queryOne((String)"pm_purorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter2});
            if (pmOrderDyn != null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6bd4\u4ef7\u5355\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"SouInquiryEdit_32", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject conmContractDyn = QueryServiceHelper.queryOne((String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{qFilter2});
            if (conmContractDyn != null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6bd4\u4ef7\u5355\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"SouInquiryEdit_32", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.openDealPage("sou_inquiryend", inquiryBill.getPkValue(), "", ShowType.Modal);
    }

    private void compareResult() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = BillFormUtil.getSelectData((IFormView)view, (String)"sou_inquiry");
        if (inquiryBill == null) {
            return;
        }
        Map compareResult = SouInquiryUtil.verifyCompareResult((DynamicObject)inquiryBill);
        if ("false".equals(compareResult.get("succed"))) {
            view.showMessage(compareResult.get("message").toString());
            return;
        }
        if ("true".equals(compareResult.get("succed"))) {
            Long[] pkId = new Long[1];
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SouInquiryList", (String)"sou_compare", (String)"id", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", (Object)inquiryBill.getString("billno")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal())}, (String)"id");){
                dataSet.forEach(row -> {
                    pkId[0] = row.getLong("id");
                });
            }
            if (pkId[0] == null) {
                view.showMessage(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u8be2\u4ef7\u5355\u7684\u6bd4\u4ef7\u5355\u3002", (String)"SouInquiryList_9", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            } else {
                BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)"sou_compare", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)pkId[0], null, null);
                view.showForm((FormShowParameter)showParam);
            }
        }
    }

    private void openDealPage(String pageKey, Object pkVale, String billno, ShowType showType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("inquiryBillId", pkVale);
        paramMap.put("inquiryno", billno);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "terminate"), (ShowType)showType));
    }

    private void alertDate() {
        IFormView view = this.getView();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject inquiryObj = BillFormUtil.getSelectData((IFormView)view, (String)"sou_inquiry");
        if (null == inquiryObj) {
            return;
        }
        Object bizStatus = inquiryObj.get("bizstatus");
        if (null != bizStatus && !BizStatusEnum.ENROLMENT.getVal().equals(bizStatus.toString())) {
            view.showMessage(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u9879\u76ee\u72b6\u6001\u4e3a\u62a5\u4ef7\u4e2d\u7684\u624d\u80fd\u53d8\u66f4\u65f6\u95f4\u3002", (String)"SouInquiryList_13", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String openTypeObj = inquiryObj.getString("opentype");
        int supQuoNumObj = inquiryObj.getInt("supquonum");
        if (supQuoNumObj > 0 && (SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal().equals(openTypeObj) || SouOpenTypeEnum.INVISIBLE_AUTOOPEN.getVal().equals(openTypeObj)) && inquiryObj.getDate("enddate").getTime() <= TimeServiceHelper.now().getTime()) {
            view.showMessage(ResManager.loadKDString((String)"\u7cfb\u7edf\u6b63\u5728\u6267\u884c\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u3002", (String)"SouInquiryList_21", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        paramMap.put("billid", inquiryObj.getPkValue());
        paramMap.put("enddate", inquiryObj.getDate("enddate"));
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_alertdate", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "alertDateAction"), (ShowType)ShowType.Modal));
    }

    private void turnsQuote() {
        IFormView view = this.getView();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject inquiryObj = BillFormUtil.getSelectData((IFormView)view, (String)"sou_inquiry");
        if (null == inquiryObj) {
            return;
        }
        Object bizStatus = inquiryObj.get("bizstatus");
        if (null != bizStatus && !BizStatusEnum.OPENEDTHEBID.getVal().equals(bizStatus.toString())) {
            view.showMessage(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u9879\u76ee\u72b6\u6001\u4e3a\u5df2\u5f00\u6807\u7684\u624d\u80fd\u591a\u8f6e\u62a5\u4ef7\u3002", (String)"SouInquiryList_14", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            return;
        }
        String turns = inquiryObj.getString("turns");
        if (turns != null && turns.equals(this.getMaxTurns())) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u7684\u62a5\u4ef7\u8f6e\u6b21\u662f\u7b2c%s\u8f6e\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u591a\u8f6e\u62a5\u4ef7\u3002", (String)"SouInquiryList_15", (String)"scm-sou-formplugin", (Object[])new Object[0]), this.getMaxTurns()));
            return;
        }
        String billNo = inquiryObj.getString("billno");
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"sou_compare", (String)"billno", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", (Object)billNo)});
        if (dyoCol != null && dyoCol.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u751f\u6210\u6bd4\u4ef7\u5355\u3002", (String)"SouInquiryList_18", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            for (DynamicObject dyo : dyoCol) {
                sb.append(dyo.getString("billno")).append(',');
            }
            sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u6bd4\u4ef7\u5355\u518d\u8fdb\u884c\u591a\u8f6e\u62a5\u4ef7\u3002", (String)"SouInquiryList_19", (String)"scm-sou-formplugin", (Object[])new Object[0]));
            view.showMessage(sb.toString());
            return;
        }
        paramMap.put("org", inquiryObj.getLong("org.id"));
        paramMap.put("billid", inquiryObj.getPkValue());
        paramMap.put("billno", inquiryObj.getString("billno"));
        paramMap.put("enddate", inquiryObj.getDate("enddate"));
        paramMap.put("inquirytitle", inquiryObj.getString("inquirytitle"));
        paramMap.put("curr", SrmCommonUtil.getPkValue((DynamicObject)inquiryObj.getDynamicObject("curr")));
        turns = turns == null || turns.equals("") ? "2" : String.valueOf(Integer.parseInt(turns) + 1);
        paramMap.put("turns", turns);
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"sou_inquiryturns", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "turnsQuoteAction"), (ShowType)ShowType.Modal));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView("billlistap");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        DynamicObject inquiryBill;
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CONFIRMCOMPARE_ACTIONID, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && (inquiryBill = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"sou_inquiry")) != null) {
            this.openDealPage("sou_comparetool", inquiryBill.getPkValue(), inquiryBill.getString("billno"), ShowType.MainNewTabPage);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        Object[] selectedRows = args.getListSelectedData().getPrimaryKeyValues();
        switch (operateKey) {
            case "quote": {
                if (selectedRows == null) break;
                ((AbstractOperate)args.getSource()).getOption().setVariableValue("quote_source", "sou");
                if (selectedRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u8be2\u4ef7\u5355\u4ee3\u7406\u62a5\u4ef7\u3002", (String)"SouInquiryList_31", (String)"scm-sou-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (selectedRows.length != 1) break;
                Object pk = selectedRows[0];
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"verifyQuote", (Object[])new Object[]{pk, null});
                if (!"false".equals(result.get("succed"))) break;
                this.getView().showTipNotification(result.get("message").toString());
                args.setCancel(true);
                return;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("id desc");
    }
}

