/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.service.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.scm.common.service.ExcelDataEntityServiceImp;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.scm.common.util.excel.ExcelDataEntity;

public class SouCompareExcelServiceImp
extends ExcelDataEntityServiceImp {
    private String taxType;
    private int settleScale;
    private Map<String, Map<String, String>> comboItemMap = new HashMap<String, Map<String, String>>();

    private SouCompareExcelServiceImp() throws Exception {
        throw new Exception("can not initialize SouCompareExcelServiceImp without paramters");
    }

    protected void setHeader(ExcelDataEntity excelDataEntity, List<ControlAp<?>> items) throws IOException {
        excelDataEntity.setExcelHeaderWithControlAp(items, true);
    }

    public SouCompareExcelServiceImp(String taxType, int settleScale) {
        this.taxType = taxType;
        this.settleScale = settleScale;
    }

    protected String getBigDecimalProp(DynamicObject dyObj, String key) {
        String result;
        if (("cfmprice2".equals(key) || "cfmtaxprice2".equals(key) || "cfmtaxamount2".equals(key) || "cfmamount2".equals(key) || "cfmqty2".equals(key) || "cfmtaxrate2".equals(key)) && !"1".equals(result = dyObj.getString("result2"))) {
            BigDecimal cfmtaxprice2 = dyObj.getBigDecimal("cfmtaxprice2");
            if (cfmtaxprice2 != null && cfmtaxprice2.compareTo(BigDecimal.ZERO) > 0) {
                return super.getBigDecimalProp(dyObj, key);
            }
            dyObj.set("cfmprice2", dyObj.get("price2"));
            dyObj.set("cfmtaxprice2", dyObj.get("taxprice2"));
            dyObj.set("cfmqty2", dyObj.get("qty2"));
            dyObj.set("cfmtaxrate2", dyObj.get("taxrate2"));
            DynamicObject curr = dyObj.getDynamicObject("quotecurr2");
            int scale = 6;
            if (curr != null && curr.getDynamicObjectType().getProperty("amtprecision") != null) {
                scale = curr.getInt("amtprecision");
            }
            dyObj.set("cfmamount2", (Object)MultCurrencyCalImpl.calAmount((DynamicObject)dyObj, (String)this.taxType, (String)"2", (int)scale));
            dyObj.set("cfmtaxamount2", (Object)MultCurrencyCalImpl.calTaxAmount((DynamicObject)dyObj, (String)this.taxType, (String)"2", (int)scale));
            BigDecimal exRate = dyObj.getBigDecimal("exrate2");
            dyObj.set("excludeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)dyObj.getBigDecimal("price2"), (BigDecimal)exRate, (int)this.settleScale));
            dyObj.set("includeunittax2", (Object)MultCurrencyCalImpl.convertByExrate((BigDecimal)dyObj.getBigDecimal("taxprice2"), (BigDecimal)exRate, (int)this.settleScale));
        }
        return super.getBigDecimalProp(dyObj, key);
    }

    protected String getBaseDataInfo(Field<?> item, DynamicObject dyObj, String name) {
        String result = dyObj.getString("result2");
        if (!"1".equals(result) && item.getKey().equals("cfmtaxrateid2")) {
            dyObj.set("cfmtaxrateid2", dyObj.get("taxrateid2"));
        }
        return super.getBaseDataInfo(item, dyObj, name);
    }

    protected String getValueToString(Field<?> item, DynamicObject dyObj, String key) {
        if (item instanceof ComboField) {
            String key1 = item.getKey();
            Map<String, String> comboItem = this.comboItemMap.get(key1);
            if (comboItem == null) {
                List items1 = ((ComboField)item).getItems();
                comboItem = new HashMap<String, String>(items1.size());
                for (ComboItem comboItem1 : items1) {
                    comboItem.put(comboItem1.getValue(), comboItem1.getCaption().getLocaleValue());
                }
                this.comboItemMap.put(key1, comboItem);
            }
            if ("result2".equals(key)) {
                return comboItem.get(dyObj.getString(key) == null ? "2" : dyObj.getString(key));
            }
            return comboItem.get(dyObj.getString(key));
        }
        if (item instanceof DateField) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dyObj.getDate(key);
            return date == null ? "" : dateFormat.format(date);
        }
        return super.getValueToString(item, dyObj, key);
    }
}

