/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;

public class SouBidBillAutoOpenTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SouBidBillAutoOpenTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info(ResManager.loadKDString((String)"\u7ade\u4ef7\u81ea\u52a8\u5f00\u6807\u5f00\u59cb", (String)"SouBidBillAutoOpenTask_0", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        ArrayList<String> bidStatusList = new ArrayList<String>();
        bidStatusList.add(BidStatusEnum.ENROLMENT.getVal());
        bidStatusList.add(BidStatusEnum.DEADLINE.getVal());
        QFilter filter = new QFilter("bidstatus", "in", bidStatusList).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("opendate", "<=", (Object)TimeServiceHelper.now())).and(new QFilter("checktype", "=", (Object)"3")).and(new QFilter("cashdeposit", "<=", (Object)BigDecimal.ZERO));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sou_bidbill", (String)"id,bidstatus", (QFilter[])new QFilter[]{filter});
        List ids = DynamicObjectUtil.array2ListId((DynamicObject[])bills, (String)"id");
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("writeLog", "false");
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"bidstart", (String)"sou_bidbill", (Object[])ids.toArray(new Object[0]), (OperateOption)option);
        if (opResult.isSuccess()) {
            logger.info(ResManager.loadKDString((String)"\u7ade\u4ef7\u81ea\u52a8\u5f00\u6807\u6210\u529f\u3002", (String)"SouBidBillAutoOpenTask_1", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        } else {
            logger.info(String.format(ResManager.loadKDString((String)"\u7ade\u4ef7\u81ea\u52a8\u5f00\u6807\u5931\u8d25%1$s", (String)"SouBidBillAutoOpenTask_2", (String)"scm-sou-formplugin", (Object[])new Object[0]), ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo())));
        }
    }
}

