/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.formplugin.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.scm.common.util.BillFormUtil;

public class SouTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo != null) {
            if (!taskInfo.isTaskEnd()) {
                this.showProgress();
            } else {
                this.complete(taskInfo);
            }
            IFormView view = this.getParentView();
            if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
                this.getMainView().sendFormAction(view);
            }
        }
    }

    private void showProgress() {
        IFormView view;
        if (!this.isExistProgressForm() && (view = this.getParentView()) != null && this.getJobFormInfo() != null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sch_taskprogress");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().putAll(this.getJobFormInfo().getParams());
            showParameter.getCustomParams().put("sch_clientjobinfo", SerializationUtils.toJsonString((Object)this.getJobFormInfo()));
            showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
            view.showForm(showParameter);
            this.setProgressPageId(showParameter.getPageId());
        }
    }

    private void complete(TaskInfo taskInfo) {
        Map data;
        List ids;
        String strData;
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        if (StringUtils.isNotBlank((CharSequence)(strData = taskInfo.getData())) && StringUtils.isNotBlank((Object)(ids = (List)(data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class)).get("successIds")))) {
            this.showResultDetailForm(view, ids);
        }
    }

    private void showResultDetailForm(IFormView view, List<String> ids) {
        if (ids != null && ids.size() > 0) {
            List collect = ids.stream().map(id -> Long.parseLong(id)).collect(Collectors.toList());
            if (collect.size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(view.getEntityId());
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setPkId(collect.get(0));
                view.showForm((FormShowParameter)showParameter);
            } else {
                HashMap customeParam = new HashMap();
                customeParam.put("id", collect);
                ListShowParameter listParam = BillFormUtil.assembleShowListFormParam((String)view.getEntityId(), customeParam, null);
                view.showForm((FormShowParameter)listParam);
            }
        }
        TaskClientProxy.delTask((IFormView)this.getMainView(), (String)this.getTaskId());
    }
}

