/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.src.opplugin.addsupplier.SrcAddSupplierFacade;

public class SrcAutoAddSupplierOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("id");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        String opKey;
        switch (opKey = evt.getOperationKey()) {
            case "audit": {
                this.autoAddSupplier(evt);
                break;
            }
            case "unaudit": {
                this.autoDeletePurlist(evt);
                break;
            }
        }
    }

    private void autoAddSupplier(AfterOperationArgs evt) {
        DynamicObject[] billObjs;
        for (DynamicObject billObj : billObjs = evt.getDataEntities()) {
            if (!this.isAutoAddSupplier(billObj)) continue;
            DynamicObject addSupplierObj = this.createAddSupplierObj(billObj);
            SrcAddSupplierFacade.addSupplier(addSupplierObj);
        }
    }

    private void autoDeletePurlist(AfterOperationArgs evt) {
        DynamicObject[] billObjs;
        for (DynamicObject billObj : billObjs = evt.getDataEntities()) {
            if (!this.isAutoAddSupplier(billObj)) continue;
            QFilter qfilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
            qfilter.and("billtype", "=", (Object)"2");
            DeleteServiceHelper.delete((String)"src_purlistf7", (QFilter[])qfilter.toArray());
        }
    }

    private boolean isAutoAddSupplier(DynamicObject billObj) {
        String sourceclass = billObj.getString("sourceclass.number");
        if (!"C011402".equals(sourceclass)) {
            return false;
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        return QueryServiceHelper.exists((String)"src_supplierinvite", (QFilter[])qfilter.toArray());
    }

    private DynamicObject createAddSupplierObj(DynamicObject billObj) {
        DynamicObject addSupplierObj = BusinessDataServiceHelper.newDynamicObject((String)"src_addsupplier");
        addSupplierObj.set("entityname", (Object)"src_decision");
        addSupplierObj.set("project", (Object)billObj);
        addSupplierObj.set("billid", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        addSupplierObj.set("turns", (Object)"1");
        this.createEntryEntity(billObj, addSupplierObj);
        return addSupplierObj;
    }

    private void createEntryEntity(DynamicObject billObj, DynamicObject addSupplierObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        QFilter supplierFilter = new QFilter("billid", "=", (Object)projectId);
        DynamicObjectCollection supplierRows = QueryServiceHelper.query((String)"src_supplierinvite", (String)"suppliertype,supplier.id", (QFilter[])supplierFilter.toArray());
        Set supplierIds = supplierRows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter purlistFilter = new QFilter("project", "=", (Object)projectId);
        purlistFilter.and("supplier", "=", (Object)0L);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)false);
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])purlistFilter.toArray());
        DynamicObjectCollection rows = addSupplierObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject purlistObj : purlistObjs) {
            DynamicObject row = rows.addNew();
            row.set("purlist", (Object)purlistObj);
            MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)row, supplierIds, (String)"supplier");
        }
    }
}

