/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsNoticeSupUtil;
import kd.scm.src.common.util.SrcQuoteUtil;
import kd.scm.src.common.util.SrcTenderUtil;

public class SrcBidPublishUnAuditOp
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        this.updateTenderStatus(objs);
        SrcQuoteUtil.deleteQuoteBill((DynamicObject[])objs);
        SrcTenderUtil.deleteTenderBill((DynamicObject[])objs);
        PdsNoticeSupUtil.deleteNoticeSup((DynamicObject[])objs);
    }

    private void updateTenderStatus(DynamicObject[] objs) {
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (DynamicObject obj : objs) {
            idList.add(obj.getLong("id"));
        }
        QFilter tenderQFilter = new QFilter("billid", "in", idList);
        DynamicObject[] tenderRows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"isquote,istender,isnegotiate,supplierip", (QFilter[])new QFilter[]{tenderQFilter});
        if (tenderRows == null || tenderRows.length == 0) {
            return;
        }
        for (DynamicObject tenderRow : tenderRows) {
            tenderRow.set("istender", (Object)"0");
            tenderRow.set("isquote", (Object)"0");
            tenderRow.set("isnegotiate", (Object)"0");
            tenderRow.set("supplierip", null);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])tenderRows);
    }
}

