/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.util.SrcScoreUtil;

public class SrcBidassessTecsumSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("scoretype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        HashMap<String, BigDecimal> scoreMap = new HashMap<String, BigDecimal>();
        HashSet<Long> projectIds = new HashSet<Long>();
        this.getScoreTask(objs, scoreMap, projectIds);
        this.setScoreTask(scoreMap);
        SrcScoreUtil.setPackageStatus(projectIds);
    }

    private void getScoreTask(DynamicObject[] objs, Map<String, BigDecimal> scoreMap, Set<Long> projectIds) {
        for (DynamicObject obj : objs) {
            if (obj.getString("scoretype").equals("1")) continue;
            projectIds.add(SrmCommonUtil.getPkValue((DynamicObject)obj));
            DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                scoreMap.put(row.getString("scoretask.id"), row.getBigDecimal("inputscore"));
            }
        }
    }

    private void setScoreTask(Map<String, BigDecimal> scoreMap) {
        if (scoreMap == null || scoreMap.size() == 0) {
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>(scoreMap.size());
        for (Map.Entry<String, BigDecimal> srcoreMapEntry : scoreMap.entrySet()) {
            idSet.add(Long.valueOf(srcoreMapEntry.getKey()));
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        DynamicObject[] scoreObjs = BusinessDataServiceHelper.load((String)"src_scoretaskf7", (String)"sumscore,finishdate,inputscore,bizstatus", (QFilter[])new QFilter[]{qFilter});
        if (scoreObjs == null || scoreObjs.length == 0) {
            return;
        }
        for (DynamicObject scoreObj : scoreObjs) {
            scoreObj.set("sumscore", (Object)scoreMap.get(scoreObj.getPkValue().toString()));
            scoreObj.set("finishdate", (Object)TimeServiceHelper.now());
            scoreObj.set("bizstatus", (Object)SrmScoreStatusEnum.SCORED.getValue());
            scoreObj.set("inputscore", (Object)scoreMap.get(scoreObj.getPkValue().toString()));
        }
        SaveServiceHelper.save((DynamicObject[])scoreObjs);
    }
}

