/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class SrcBillCompTplDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SrcBillCompTplDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("template");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<String> parentIdList = new ArrayList<String>(datas.length);
        HashSet<String> compKeySet = new HashSet<String>();
        for (DynamicObject data : datas) {
            parentIdList.add(data.getPkValue().toString());
            DynamicObject template = data.getDynamicObject("template");
            if (null == template) continue;
            DynamicObjectCollection compEntryCols = template.getDynamicObjectCollection("compentry");
            if (null == compEntryCols) {
                template = BusinessDataServiceHelper.loadSingle((Object)template.getPkValue(), (String)"src_settingtpl");
                compEntryCols = template.getDynamicObjectCollection("compentry");
            }
            for (DynamicObject compEntryCol : compEntryCols) {
                Object component = compEntryCol.get("bizobject");
                if (null == component || component.toString().trim().length() == 0) continue;
                String compKey = component.toString();
                compKeySet.add(compKey);
            }
        }
        if (parentIdList.size() == 0 || compKeySet.size() == 0) {
            return;
        }
        StringBuilder logMsg = new StringBuilder();
        QFilter filter = new QFilter("parentid", "in", parentIdList);
        for (String compKey : compKeySet) {
            int row = DeleteServiceHelper.delete((String)compKey, (QFilter[])new QFilter[]{filter});
            if (row <= 0) continue;
            logMsg.append("###delete ").append(compKey).append(" success,parentID:").append(parentIdList).append(';');
        }
        log.info(logMsg.length() == 0 ? "###del log" : logMsg.toString());
    }
}

