/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcContractSaveByExosysOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("bizstatus");
        e.getFieldKeys().add("systype");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("template");
        e.getFieldKeys().add("tmp_template.tmp_bizobject");
        e.getFieldKeys().add("tmp_template.tmp_component");
        e.getFieldKeys().add("tmp_template.tmp_template");
        e.getFieldKeys().add("tplentry.tmp_bizobject");
        e.getFieldKeys().add("tplentry.tmp_template");
        e.getFieldKeys().add("tplentry.srctplid");
        e.getFieldKeys().add("entrymainflow.biznode");
        e.getFieldKeys().add("entrymainflow.bizobject");
        e.getFieldKeys().add("entrymainflow.extobject");
        e.getFieldKeys().add("entrymainflow.isflowchart");
        e.getFieldKeys().add("entrymainflow.flowbillstatus");
        e.getFieldKeys().add("entrymainflow.flowbizstatus");
        e.getFieldKeys().add("entrysubflow.subbiznode");
        e.getFieldKeys().add("entrysubflow.subisaudit");
        e.getFieldKeys().add("entrysubflow.subbizobject");
        e.getFieldKeys().add("entrysubflow.subextobject");
        e.getFieldKeys().add("entrysubflow.subisflowchart");
        e.getFieldKeys().add("entrysubflow.subflowbillstatus");
        e.getFieldKeys().add("entrysubflow.subflowbizstatus");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        HashSet<Long> unSuccessProjectId = new HashSet<Long>(8);
        StringBuilder messge = new StringBuilder();
        DynamicObject[] billObjs = e.getDataEntities();
        ArrayList<DynamicObject> newBillObjs = new ArrayList<DynamicObject>();
        for (DynamicObject billObj : billObjs) {
            String systype = billObj.getString("systype");
            if (!"3".equals(systype)) continue;
            newBillObjs.add(billObj);
        }
        if (newBillObjs.size() == 0) {
            return;
        }
        for (DynamicObject billObj : newBillObjs) {
            long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
            String billno = billObj.getString("billno");
            try {
                this.beforeHandle(billObj);
                OperationResult result = PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"submit");
                if (null != result && result.isSuccess()) {
                    result = PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"audit");
                }
                if (null != result && !result.isSuccess()) {
                    unSuccessProjectId.add(projectId);
                    StringBuilder errMsg = new StringBuilder();
                    for (int i = 0; i < result.getAllErrorOrValidateInfo().size(); ++i) {
                        errMsg.append(((IOperateInfo)result.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
                    }
                    messge.append(billno);
                    messge.append(':');
                    messge.append((CharSequence)errMsg);
                    continue;
                }
                this.afterHandle(billObj);
            }
            catch (Exception exception) {
                unSuccessProjectId.add(projectId);
                messge.append(billno);
                messge.append(':');
                messge.append(exception.getMessage());
            }
        }
        if (unSuccessProjectId.size() > 0) {
            QFilter filter = new QFilter("id", "in", unSuccessProjectId);
            DeleteServiceHelper.delete((String)"src_contract", (QFilter[])filter.toArray());
            throw new KDBizException(messge.toString());
        }
    }

    private void beforeHandle(DynamicObject billObj) {
        String extNumber = "ISrcContractSaveExoBeforeHandler";
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(billObj);
        List handleList = ExtPluginFactory.getInstance().getExtPluginInstances(extNumber);
        for (IExtPluginHandler handler : handleList) {
            handler.process(context);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
    }

    private void afterHandle(DynamicObject billObj) {
        String extNumber = "ISrcContractSaveExoAfterHandler";
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(billObj);
        List handleList = ExtPluginFactory.getInstance().getExtPluginInstances(extNumber);
        for (IExtPluginHandler handler : handleList) {
            handler.process(context);
        }
    }
}

