/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SrcEvtSubscriptionUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SrcEvtSubscriptionUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5bfb\u6e90\u7ba1\u7406-\u4e8b\u4ef6\u8ba2\u9605\u65e7\u6570\u636e\u5347\u7ea7\u3002", (String)"SrcEvtSubscriptionUpgradePlugin_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"SrcEvtSubscriptionUpgradePlugin_1", (String)"scm-src-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"SrcEvtSubscriptionUpgradePlugin_2", (String)"scm-src-opplugin", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        int pageSize = 200;
        DBRoute dbRoute = new DBRoute(dbKey);
        List<String> numberList = this.getUpdateNumber(dbRoute);
        String numbers = String.join((CharSequence)",", (CharSequence[])numberList.stream().map(String::valueOf).toArray(String[]::new));
        String sqlAll = "select fid from t_evt_subscription where fnumber in(" + numbers + ")";
        try (DataSet dataSet1 = DB.queryDataSet((String)"SrcEvtSubscriptionUpgradePlugin.upgrade", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList idList = new ArrayList();
            dataSet1.forEach(row -> idList.add(row.getLong("fid")));
            pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"SrcEvtSubscriptionUpgradePlugin_3", (String)"scm-src-opplugin", (Object[])new Object[0])).append(idList.size()).append("\n");
            int count = idList.size();
            int totalPages = count / pageSize;
            if (count % pageSize != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List subIdList = (pageIndex + 1) * pageSize > idList.size() ? idList.subList(pageIndex * pageSize, idList.size()) : idList.subList(pageIndex * pageSize, (pageIndex + 1) * pageSize);
                if (subIdList.isEmpty()) continue;
                String ids = String.join((CharSequence)",", (CharSequence[])subIdList.stream().map(String::valueOf).toArray(String[]::new));
                String sql = "select fid,fserviceconfig from t_evt_subscription  where fid in (" + ids + ") ";
                Map<Object, Object> sqlParms = this.callFserviceconfigUpgrade(dbRoute, sql);
                dbRoute = new DBRoute(dbKey);
                ArrayList<Object[]> parms = new ArrayList<Object[]>(sqlParms.size());
                for (Map.Entry<Object, Object> entry : sqlParms.entrySet()) {
                    Object[] parm = new Object[]{entry.getValue(), entry.getKey()};
                    parms.add(parm);
                }
                if (parms.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                this.updateData(dbRoute, parms);
            }
        }
        return true;
    }

    private Map<Object, Object> callFserviceconfigUpgrade(DBRoute dbRoute, String sql) {
        HashMap<Object, Object> sqlParms = new HashMap<Object, Object>();
        try (DataSet dataSet = DB.queryDataSet((String)"SrcEvtSubscriptionUpgradePlugin.callFserviceconfigUpgrade", (DBRoute)dbRoute, (String)sql, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String serviceCofnig = row.getString("fserviceconfig");
                    if (!StringUtils.isNotBlank((CharSequence)serviceCofnig)) continue;
                    JSONObject jsonObject = (JSONObject)JSONObject.parse((String)serviceCofnig);
                    Object signalemail = jsonObject.get((Object)"signalemail");
                    if (null != signalemail && !((Boolean)signalemail).booleanValue()) {
                        jsonObject.put("signalemail", (Object)true);
                        sqlParms.put(row.get("fid"), jsonObject.toJSONString());
                        continue;
                    }
                    if (null == signalemail) {
                        jsonObject.put("signalemail", (Object)true);
                        sqlParms.put(row.get("fid"), jsonObject.toJSONString());
                        continue;
                    }
                    sqlParms.put(row.get("fid"), serviceCofnig);
                }
            }
        }
        return sqlParms;
    }

    private List<String> getUpdateNumber(DBRoute dbRoute) {
        ArrayList<String> numberList = new ArrayList<String>(32);
        numberList.add("'srm_pds_noticesupplier.audit.sendMsg'");
        numberList.add("'srm_pds_supencryptdetail.sendmsg.sendMsg'");
        numberList.add("'srm_src_selectsupplier.audit.sendMsg'");
        numberList.add("'srm_src_question.audit.sendMsg'");
        numberList.add("'srm_src_paymanage.audit.sendMsg'");
        numberList.add("'srm_pds_bidopendetail.sendmsg.sendMsg'");
        numberList.add("'srm_pds_encryptdetail.sendmsg.sendMsg'");
        numberList.add("'srm_src_compete.audit.sendMsg'");
        numberList.add("'srm_src_bidopen.audit.sendMsg'");
        numberList.add("'srm_src_project.audit.sendClarifyMsg'");
        numberList.add("'srm_src_memberclarify.sendmsg.sendMsg'");
        numberList.add("'srm_tnd_query.save.sendMsg'");
        numberList.add("'srm_tnd_reply.save.sendMsg'");
        numberList.add("'srm_tnd_clarify.save.sendMsg'");
        numberList.add("'srm_tnd_payment.submit.sendMsg'");
        numberList.add("'srm_src_project.audit.sendMsg'");
        numberList.add("'srm_src_scoreanalyse.return.sendMsg'");
        numberList.add("'srm_src_negotiatebill.audit.sendMsg'");
        numberList.add("'srm_sou_inquiry.audit.sendMsg'");
        numberList.add("'srm_sou_inquiry.sendmsgforturns.sendMsg'");
        numberList.add("'srm_sou_quote.sendmsgtounadopt.sendMsg'");
        numberList.add("'srm_sou_quote.sendmsgtoadopt.sendMsg'");
        numberList.add("'srm_sou_inquiry.sendmsgforend.sendMsgAll'");
        numberList.add("'srm_sou_bidbillcfm.sendmsgtofail.sendMsg'");
        numberList.add("'srm_sou_inquiry.sendmsgforend.sendMsg'");
        numberList.add("'srm_sou_bidbill.audit.sendMsg'");
        numberList.add("'srm_sou_bidbillcfm.sendmsgtowin.sendMsg'");
        return numberList;
    }

    private void updateData(DBRoute dbRoute, List<Object[]> parms) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update t_evt_subscription set fispreinsdata ='1',fserviceconfig = ? where fid = ?", parms);
    }
}

