/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcInviteSupplierAssAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("managetype");
        e.getFieldKeys().add("sourceclass");
        e.getFieldKeys().add("parentid");
        e.getFieldKeys().add("sourcetype");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("tendertype");
        e.getFieldKeys().add("supplieruser");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] projectObjs = e.getDataEntities();
        ArrayList supplierList = new ArrayList();
        for (DynamicObject projectObj : projectObjs) {
            String entityKey = projectObj.getDynamicObjectType().getName();
            this.createInviteSupplier(projectObj);
            if ("src_selectsupplier".equals(entityKey) || "src_bidpublish".equals(entityKey)) {
                SupplierUtil.createEnrollSupEntry((DynamicObject)projectObj);
            }
            if ("src_selectsupplier".equals(entityKey)) {
                this.batchCreateSupBySelectSupCompData(projectObj);
            } else {
                DynamicObjectCollection entryCols;
                DynamicObject inviteSupplierEntry;
                DynamicObjectCollection bidSuppliers = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("billid", "=", projectObj.getPkValue())});
                if (!CollectionUtils.isEmpty((Collection)bidSuppliers)) {
                    // empty if block
                }
                if (null == (inviteSupplierEntry = TemplateUtil.getComponentData((String)projectObj.getString("id"), (String)"src_supplier_invite"))) continue;
                if ("3".equals(projectObj.getString("managetype"))) {
                    SrcPurListUtil.createInviteSupEntryByItemSup((DynamicObject)projectObj, (DynamicObject)inviteSupplierEntry);
                }
                if ((entryCols = inviteSupplierEntry.getDynamicObjectCollection("entrysupplier")) == null || entryCols.size() == 0 || this.isManualSelectSupplier(projectObj)) continue;
                SrcPurListUtil.createTenderSupEntry((DynamicObject)projectObj, (DynamicObjectCollection)entryCols, supplierList);
            }
            if (supplierList != null && supplierList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])supplierList.toArray(new DynamicObject[supplierList.size()]));
            }
            this.deleteInviteSupplier(projectObj);
        }
    }

    private void batchCreateSupBySelectSupCompData(DynamicObject parentObj) {
        if (this.isManualSelectSupplier(parentObj)) {
            return;
        }
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)parentObj, (String)"src_supplier_select");
        DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entrysupplier");
        DynamicObjectCollection entryCols = new DynamicObjectCollection();
        ArrayList<DynamicObject> supplierColList = new ArrayList<DynamicObject>(8);
        for (DynamicObject col : cols) {
            String publishStatus = col.getString("publishstatus");
            if ("B".equals(publishStatus)) continue;
            supplierColList.add(col);
        }
        if (supplierColList.size() > 0) {
            entryCols.addAll(supplierColList);
            ArrayList supplierList = new ArrayList(8);
            SrcPurListUtil.createTenderSupEntry((DynamicObject)parentObj, (DynamicObjectCollection)entryCols, supplierList);
            SaveServiceHelper.save((DynamicObject[])supplierList.toArray(new DynamicObject[supplierList.size()]));
        }
    }

    private void createInviteSupplier(DynamicObject projectObj) {
        String sourceType = projectObj.getString("sourcetype.number");
        if (!SourceTypeEnums.CONFIRM_PRICE.getValue().equals(sourceType)) {
            return;
        }
        long billId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("supplier"));
        if (supplierId == 0L || billId == 0L) {
            return;
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)billId);
        DeleteServiceHelper.delete((String)"src_supplierinvite", (QFilter[])qfilter.toArray());
        DynamicObject inviteObj = TemplateUtil.getComponentData((String)String.valueOf(billId), (String)"src_supplier_invite");
        if (null == inviteObj) {
            inviteObj = TemplateUtil.createCompData((String)"src_project", (long)billId, (String)"src_supplier_invite");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inviteObj});
        }
        DynamicObject inviteSupObj = BusinessDataServiceHelper.newDynamicObject((String)"src_supplierinvite");
        inviteSupObj.set("billid", (Object)SrmCommonUtil.getPkValue((DynamicObject)inviteObj));
        inviteSupObj.set("parentid", (Object)billId);
        inviteSupObj.set("package", (Object)SrcPurListUtil.getNoPackageNameId((long)billId));
        inviteSupObj.set("suppliertype", (Object)"bd_supplier");
        inviteSupObj.set("supplier", (Object)supplierId);
        DynamicObjectCollection rows = projectObj.getDynamicObjectCollection("supplieruser");
        if (null != rows && rows.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForObject((DynamicObject)inviteSupObj, (DynamicObjectCollection)rows, (String)"supplieruser");
        }
        inviteSupObj.set("isinvite", (Object)"1");
        inviteSupObj.set("isconfirm", (Object)"1");
        inviteSupObj.set("source", (Object)"2");
        SupplierUtil.setBdSupplierInfo((long)supplierId, (DynamicObject)inviteSupObj);
        Map linkManMap = PdsLinkManFacade.getLinkManBySupplierUser((DynamicObjectCollection)rows);
        if (null != linkManMap && linkManMap.size() > 0) {
            inviteSupObj.set("linkman", linkManMap.get("linkman"));
            inviteSupObj.set("phone", linkManMap.get("phone"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inviteSupObj});
    }

    private void deleteInviteSupplier(DynamicObject projectObj) {
        long billId;
        QFilter qfilter;
        if ("2".equals(projectObj.getString("tendertype")) && !QueryServiceHelper.exists((String)"src_enrollsupplier", (QFilter[])(qfilter = new QFilter("billid", "=", (Object)(billId = SrmCommonUtil.getPkValue((DynamicObject)projectObj)))).toArray())) {
            DeleteServiceHelper.delete((String)"src_supplierinvite", (QFilter[])qfilter.toArray());
        }
    }

    private boolean isManualSelectSupplier(DynamicObject projectObj) {
        long sourceFlowId = projectObj.getLong("srctype.id");
        boolean isManualSelectSupplier = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isManualSelectSupplier", (Object)false, (long)projectObj.getLong("id")));
        if (isManualSelectSupplier) {
            DynamicObject[] inviteRows;
            for (DynamicObject inviteRow : inviteRows = BusinessDataServiceHelper.load((String)"src_supplierinvite", (String)"isconfirm,ismanualselect", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj))})) {
                inviteRow.set("isconfirm", (Object)"1");
                inviteRow.set("ismanualselect", (Object)"1");
            }
            PdsCommonUtils.saveDynamicObjects((DynamicObject[])inviteRows);
        }
        return isManualSelectSupplier;
    }
}

