/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.SrcCalcLocalAmount;
import kd.scm.src.common.calc.SrcGlobalCalcContext;

public class SrcProjectInitPriceAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcetype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        DynamicObject[] billObjs;
        for (DynamicObject billObj : billObjs = evt.getDataEntities()) {
            DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)billObj), (String)"src_project");
            String sourceType = projectObj.getString("sourcetype.number");
            if (!SourceTypeEnums.INPUT_PRICE.getValue().equals(sourceType) && !SourceTypeEnums.DIRECT_PUR.getValue().equals(sourceType) && !SourceTypeEnums.INTERNAL_SALE.getValue().equals(sourceType) && !SourceTypeEnums.NET_PUR.getValue().equals(sourceType)) continue;
            this.syntheticalCalculate(projectObj, sourceType);
            this.auditDecision(projectObj, evt.getOperationKey(), sourceType);
        }
    }

    public void auditDecision(DynamicObject projectObj, String operationKey, String sourceType) {
        ExtPluginContext context = new ExtPluginContext();
        context.setOperationKey(operationKey);
        context.setBillObj(projectObj);
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        context.setProjectObj(projectObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        ExtPluginFactory.executeExtplugin((String)PdsCommonUtils.buildString((Object[])new Object[]{"src_project_audit", "_", sourceType}), (ExtPluginContext)context, (boolean)false);
    }

    private void syntheticalCalculate(DynamicObject projectObj, String sourceType) {
        if (sourceType.equals(SourceTypeEnums.INPUT_PRICE.getValue())) {
            this.updatePurlistStatus(projectObj);
        } else if ((sourceType.equals(SourceTypeEnums.DIRECT_PUR.getValue()) || sourceType.equals(SourceTypeEnums.NET_PUR.getValue()) || sourceType.equals(SourceTypeEnums.INTERNAL_SALE.getValue())) && this.isNeedCalculate(projectObj)) {
            SrcCalcHelper.syntheticalCalculate((String)"src_compare", (long)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        }
    }

    private boolean isNeedCalculate(DynamicObject projectObj) {
        QFilter qFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        qFilter.and("entrystatus", "!=", (Object)ProjectStatusEnums.OPENED.getValue());
        return QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])qFilter.toArray());
    }

    private void updatePurlistStatus(DynamicObject projectObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        QFilter qFilters = new QFilter("project", "=", (Object)projectId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)true);
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qFilters.toArray());
        if (null == purlistObjs || purlistObjs.length == 0) {
            return;
        }
        for (DynamicObject purlistObj : purlistObjs) {
            purlistObj.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
            purlistObj.set("sysresult", (Object)ResultStatusEnums.WIN.getValue());
            purlistObj.set("result", (Object)ResultStatusEnums.WIN.getValue());
            purlistObj.set("orderratio", (Object)100);
            purlistObj.set("cfmqty", purlistObj.get("qty"));
        }
        SrcCalcContext context = SrcCalcHelper.createContext((String)"src_project", (long)projectId, (SrcGlobalCalcContext)new SrcGlobalCalcContext(), (boolean)true);
        context.setPurlistObjs(purlistObjs);
        SrcCalcLocalAmount calc = new SrcCalcLocalAmount();
        calc.calcLocalPriceAndAmount(context);
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistObjs);
        SrcCalcHelper.syntheticalCalculate((String)"src_compare", (long)projectId);
    }
}

