/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcProjectPurlistUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("id");
        fields.add("billstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        Long[] pkIds = this.getPkIds(args);
        if (null != pkIds && pkIds.length > 0) {
            this.doUnAudit(pkIds);
        }
    }

    private Long[] getPkIds(BeginOperationTransactionArgs args) {
        DynamicObject[] billObjs = args.getDataEntities();
        List projectIds = Arrays.asList(billObjs).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter qfilter = new QFilter("id", "in", projectIds);
        qfilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObjectCollection purlistObjs = QueryServiceHelper.query((String)"src_purlist", (String)"id", (QFilter[])qfilter.toArray());
        if (null == purlistObjs || purlistObjs.size() == 0) {
            return null;
        }
        return PdsCommonUtils.getPkIds((DynamicObjectCollection)purlistObjs);
    }

    private void doUnAudit(Long[] pkIds) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isStrict", String.valueOf(false));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult unAuditRet = OperationServiceHelper.executeOperate((String)"unaudit", (String)"src_purlist", (Object[])pkIds, (OperateOption)operateOption);
        if (!unAuditRet.isSuccess()) {
            throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)unAuditRet.getAllErrorOrValidateInfo()));
        }
    }
}

