/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcScorerTaskRejectOp
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (context.getEntityId() == null || context.getProjectId() == 0L) {
            return;
        }
        ArrayList<DynamicObject> scorerList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> packageList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> scorertaskList = new ArrayList<DynamicObject>(8);
        this.updateScorerStatus(context.getProjectId(), scorerList);
        this.updatScoreTaskStatus(context.getProjectId(), taskList);
        this.updatPackageStatus(context.getProjectId(), packageList);
        this.updateScorerTaskStatus(context.getBillObj(), scorertaskList);
        PdsCommonUtils.saveDynamicObjects(scorerList);
        PdsCommonUtils.saveDynamicObjects(taskList);
        PdsCommonUtils.saveDynamicObjects(packageList);
        PdsCommonUtils.saveDynamicObjects(scorertaskList);
    }

    private void updateScorerStatus(long projectId, List<DynamicObject> scorerList) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId).and("scored", "=", (Object)"1");
        qfilters.and("index.indextype.basetype", "!=", (Object)"4");
        qfilters.and("index.indextype.basetype", "!=", (Object)"7");
        qfilters.and("billid.bizstatus", "!=", (Object)"E");
        String selectFields = "scored,invalid";
        DynamicObject[] scorerObjs = BusinessDataServiceHelper.load((String)"src_scoreanalyse", (String)selectFields, (QFilter[])qfilters.toArray());
        if (null == scorerObjs || scorerObjs.length == 0) {
            return;
        }
        for (DynamicObject scorerObj : scorerObjs) {
            scorerObj.set("scored", (Object)"0");
            scorerObj.set("invalid", (Object)"0");
            scorerList.add(scorerObj);
        }
    }

    private void updatScoreTaskStatus(long projectId, List<DynamicObject> taskList) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("indextype.basetype", "!=", (Object)"4");
        qfilters.and("indextype.basetype", "!=", (Object)"7");
        qfilters.and("bizstatus", "!=", (Object)"E");
        String selectFields = "id,bizstatus,sumscore,sumscore,finishdate";
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)"src_scoretaskf7", (String)selectFields, (QFilter[])qfilters.toArray());
        if (taskObjs == null || taskObjs.length == 0) {
            return;
        }
        for (DynamicObject taskObj : taskObjs) {
            taskObj.set("bizstatus", (Object)SrmScoreStatusEnum.TOBESCORE.getValue());
            taskObj.set("sumscore", (Object)BigDecimal.ZERO);
            taskObj.set("finishdate", null);
            taskList.add(taskObj);
        }
    }

    private void updatPackageStatus(long projectId, List<DynamicObject> packageList) {
        String selectFields = "istecassess,tecassessdate";
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId).and("istecassess", "=", (Object)"1");
        DynamicObject[] packageObjs = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)selectFields, (QFilter[])qfilters.toArray());
        if (packageObjs == null || packageObjs.length == 0) {
            return;
        }
        for (DynamicObject packageObj : packageObjs) {
            packageObj.set("istecassess", (Object)"0");
            packageObj.set("tecassessdate", null);
            packageList.add(packageObj);
        }
    }

    private void updateScorerTaskStatus(DynamicObject scorerTaskObj, List<DynamicObject> scorertaskList) {
        scorerTaskObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        scorerTaskObj.set("scorestatus", (Object)ProcessStatusEnums.NOTSTARTED.getValue());
        scorertaskList.add(scorerTaskObj);
    }
}

