/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcAptitudeAuditResultHandler4
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (!context.getOperationKey().equals("audit") && !context.getOperationKey().equals("unaudit")) {
            return;
        }
        context.setHandleOk(false);
        Set<String> supPkgSet = this.getUpdateSupPkgSet(context);
        if (null == supPkgSet || supPkgSet.size() == 0) {
            return;
        }
        this.updateInvalidPurlist(context, supPkgSet);
    }

    public Set<String> getUpdateSupPkgSet(ExtPluginContext context) {
        DynamicObject[] rows = null;
        rows = "src_aptitudeaudit".equals(context.getEntityId()) ? this.getEntryRows(context, "src_aptituderesultf7", "billid") : ("src_aptitudeaudit2".equals(context.getEntityId()) ? this.getEntryRows(context, "src_aptituderesult2f7", "billid") : this.getEntryRows(context, "src_bidassess_tec", "billid"));
        if (null == rows || rows.length == 0) {
            return null;
        }
        HashSet<String> supPkgSet = new HashSet<String>();
        boolean isByPackage = this.isByPackage(context);
        boolean isByPurlist = null != rows[0].get("scoretask.purlist");
        context.setHandleOk(isByPurlist);
        for (DynamicObject row : rows) {
            DynamicObject taskObj = row.getDynamicObject("scoretask");
            if (null == taskObj || !"2".equals(row.getString("isaptitude"))) continue;
            supPkgSet.add(this.getKey(taskObj, isByPackage, context.isHandleOk()));
        }
        return supPkgSet;
    }

    public void updateInvalidPurlist(ExtPluginContext context, Set<String> supPkgSet) {
        QFilter qfilters = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()));
        qfilters.and("entrystatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.QUOTED.getValue(), ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.INVALID.getValue()}));
        qfilters.and("entrystatus2", "!=", (Object)ProjectStatusEnums.TERMINATED.getValue());
        String selectFields = "supplier,package,entrystatus,entrystatus2,id purlist.id,rank,result,sysresult";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray());
        if (rows.length == 0) {
            return;
        }
        boolean isByPackage = this.isByPackage(context);
        ArrayList<DynamicObject> purlistList = new ArrayList<DynamicObject>(rows.length);
        for (DynamicObject row : rows) {
            String supPkg = this.getKey(row, isByPackage, context.isHandleOk());
            if (!supPkgSet.contains(supPkg)) continue;
            if (context.getOperationKey().equals("audit")) {
                row.set("entrystatus", (Object)ProjectStatusEnums.INVALID.getValue());
                if (context.isHandleOk()) {
                    row.set("entrystatus2", (Object)ProjectStatusEnums.INVALID.getValue());
                    row.set("rank", (Object)0);
                    row.set("result", null);
                    row.set("sysresult", null);
                }
                purlistList.add(row);
                continue;
            }
            row.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
            if (context.isHandleOk()) {
                row.set("entrystatus2", null);
            }
            purlistList.add(row);
        }
        if (purlistList.size() > 0) {
            PdsCommonUtils.saveDynamicObjects(purlistList);
        }
    }

    public DynamicObject[] getEntryRows(ExtPluginContext context, String entityName, String keyField) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilters = new QFilter(keyField, "=", (Object)projectId);
        String nodeName = context.getBillObj().getDataEntityType().getName();
        if ("src_bidassess".equals(nodeName)) {
            qfilters.and("scoretask.basetype", "!=", (Object)"2");
        } else if ("src_compare".equals(nodeName)) {
            qfilters.and("scoretask.basetype", "=", (Object)"2");
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
    }

    private String getKey(DynamicObject obj, boolean isByPackage, boolean isByPurlist) {
        long supplierId = obj.getLong("supplier.id");
        long packageId = obj.getLong("package.id");
        long purlistId = 0L;
        purlistId = "src_purlistf7".equals(obj.getDataEntityType().getName()) ? obj.getLong("id") : obj.getLong("purlist.id");
        StringBuilder sb = new StringBuilder(String.valueOf(supplierId));
        if (isByPackage) {
            sb.append('_').append(String.valueOf(packageId));
        }
        if (isByPurlist) {
            sb.append('_').append(String.valueOf(purlistId));
        }
        return sb.toString();
    }

    private boolean isByPackage(ExtPluginContext context) {
        return context.getBillObj().getString("managetype").equals("2");
    }
}

