/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.EvaluateGradeEnums;
import kd.scm.pds.common.expertitem.PdsExpertItemUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcExpertEvaluateAuditHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (context.getBillObj().getBoolean("ischanged")) {
            this.updateExpert(context);
        }
    }

    public void updateExpert(ExtPluginContext context) {
        DynamicObject[] resultRows = this.getResultRows(context);
        if (null == resultRows || resultRows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> resultMap = Arrays.asList(resultRows).stream().collect(Collectors.groupingBy(e -> e.getLong("scoretask.supplier.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        DynamicObject[] expertRows = this.getExpertRows(context, resultMap.keySet());
        if (null == expertRows || expertRows.length == 0) {
            return;
        }
        this.updateExpert(context, expertRows, resultMap);
    }

    protected void updateExpert(ExtPluginContext context, DynamicObject[] expertRows, Map<Long, DynamicObject> resultMap) {
        DynamicObject billObj = context.getBillObj();
        long billId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        if ("audit".equals(context.getOperationKey())) {
            PdsExpertItemUtils.expertUpdateLog((DynamicObject[])expertRows, (String)"audit");
            for (DynamicObject expertRow : expertRows) {
                DynamicObject resultObj = resultMap.get(expertRow.getLong("id"));
                if (null == resultObj) continue;
                expertRow.set("srcbilltype", (Object)"1");
                expertRow.set("evaluatedate", (Object)TimeServiceHelper.now());
                expertRow.set("evaluate", (Object)billId);
                expertRow.set("evaluatetype", (Object)billObj.getLong("biztype.id"));
                expertRow.set("period", (Object)billObj.getLong("period.id"));
                expertRow.set("evaluatefrom", (Object)billObj.getDate("datefrom"));
                expertRow.set("evaluateto", (Object)billObj.getDate("dateto"));
                if ("2".equals(billObj.getString("scoretype"))) {
                    expertRow.set("evaluatescore", (Object)resultObj.getBigDecimal("inputscore"));
                } else {
                    expertRow.set("evaluatescore", (Object)resultObj.getBigDecimal("scoretask.sumscore"));
                }
                expertRow.set("evaluategrade", (Object)resultObj.getLong("grade.id"));
                Object valueObj = resultObj.get("grade.paramvalue");
                if (!StringUtils.isBlank((Object)valueObj)) {
                    int month = Integer.parseInt(valueObj.toString());
                    expertRow.set("pausefrom", (Object)TimeServiceHelper.now());
                    expertRow.set("pauseto", (Object)DateUtil.addMonth((Date)TimeServiceHelper.now(), (int)month));
                }
                if (EvaluateGradeEnums.TERMINATE.getId() != resultObj.getLong("grade.id")) continue;
                expertRow.set("enable", (Object)"0");
            }
        } else {
            for (DynamicObject expertRow : expertRows) {
                boolean isAllowUnAudit;
                boolean bl = isAllowUnAudit = "1".equals(expertRow.getString("srcbilltype")) && billId == expertRow.getLong("evaluate.id");
                if (!isAllowUnAudit) continue;
                PdsExpertItemUtils.expertUpdateLog((DynamicObject)expertRow, (String)"unaudit");
            }
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])expertRows);
    }

    public DynamicObject[] getResultRows(ExtPluginContext context) {
        long billId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qfilters = new QFilter("billid", "=", (Object)billId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_evaluateresultf7", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_evaluateresultf7", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    public DynamicObject[] getExpertRows(ExtPluginContext context, Set<Long> expertIds) {
        QFilter qfilters = new QFilter("id", "in", expertIds);
        qfilters.and("enable", "=", (Object)"1");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_expert", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_expert", (String)selectFields, (QFilter[])qfilters.toArray());
    }
}

