/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.enroll;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.util.ExtParameterUtils;

public class SrcEnrollContextInit
implements IPdsEnrollHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsEnrollContext context) {
        this.initEnrollContext(context);
    }

    private void initEnrollContext(PdsEnrollContext context) {
        long projectId = context.getBillObj().getLong("project.id");
        long supplierId = context.getBillObj().getLong("supplier.id");
        DynamicObjectCollection packageObjs = context.getBillObj().getDynamicObjectCollection("enrollpackage");
        String manageType = context.getBillObj().getString("project.managetype");
        if (packageObjs == null || packageObjs.size() == 0) {
            this.logErrorMessage(context, null, ResManager.loadKDString((String)"\u60a8\u672a\u9009\u62e9\u62a5\u540d\u6807\u6bb5\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6807\u6bb5\u3002", (String)"SrcEnrollContextInit_1", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        context.setProjectId(projectId);
        context.setProjectObj(BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project"));
        context.setSupplierId(supplierId);
        context.setPackageObjs(packageObjs);
        context.setManageType(manageType);
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("srctype"));
        boolean isAutoPublish = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isautopublish", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())));
        context.setAutoPublish(isAutoPublish);
    }
}

