/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.enroll;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcEnrollSupplierHandler
implements IPdsEnrollHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsEnrollContext context) {
        if (context.isSucced()) {
            this.createEnrollSupplier(context);
        }
    }

    protected void createEnrollSupplier(PdsEnrollContext context) {
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getProjectId());
        qfilter.and("supplier.id", "=", (Object)context.getSupplierId());
        DeleteServiceHelper.delete((String)"src_enrollsupplier", (QFilter[])qfilter.toArray());
        List<DynamicObject> enrollSupplierList = new ArrayList();
        DynamicObjectCollection attachRows = context.getBillObj().getDynamicObjectCollection("enrollbidattach");
        boolean convertStatus = AttachmentUtils.convertTempAttachments((DynamicObjectCollection)attachRows);
        if (!convertStatus) {
            this.logErrorMessage(context, null, ResManager.loadKDString((String)"\u4e34\u65f6\u9644\u4ef6\u6ca1\u6709\u8f6c\u4e3a\u6b63\u5f0f\u9644\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SrcEnrollSupplierHandler_2", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        int indexSeq = this.getIndexSeq(context);
        for (DynamicObject packageObj : context.getPackageObjs()) {
            long packageId = 0L;
            if (null != context.getManageType() && "2".equals(context.getManageType())) {
                DynamicObject basedataObj = packageObj.getDynamicObject("fbasedataid");
                packageId = (Long)basedataObj.getPkValue();
            }
            DynamicObject supplierObj = SupplierUtil.createSupplierObj((String)"src_enrollsupplier", (PdsEnrollContext)context, (int)indexSeq, (long)packageId);
            supplierObj.set("bidattach", (Object)PdsCommonUtils.cloneAttachment((DynamicObjectCollection)attachRows));
            supplierObj.set("applytime", (Object)TimeServiceHelper.now());
            supplierObj.set("supplierip", (Object)PdsCommonUtils.getLoginIp());
            if (context.isAutoPublish()) {
                supplierObj.set("isselect", (Object)"1");
                supplierObj.set("note", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u63a8\u8350\u5165\u56f4\u3002", (String)"SrcEnrollSupplierHandler_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            }
            enrollSupplierList.add(supplierObj);
            if (packageId != 0L) continue;
            break;
        }
        context.setEnrollSupplierList(enrollSupplierList);
        if (!context.isAutoPublish()) {
            PdsCommonUtils.saveDynamicObjects(enrollSupplierList);
            Set enrollEntryIds = context.getEnrollSupplierList().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            enrollSupplierList = SupplierUtil.reloadSupplierList((String)"src_enrollsupplier", enrollEntryIds);
            context.setEnrollSupplierList(enrollSupplierList);
        }
    }

    private int getIndexSeq(PdsEnrollContext context) {
        int indexSeq = 1;
        QFilter projectFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_enrollsupplier", (String)"id", (QFilter[])projectFilter.toArray());
        if (null != rows && rows.size() > 0) {
            indexSeq = rows.size() + 1;
        }
        return indexSeq;
    }
}

