/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.SrcClarifyUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;

public class SrcAptOpenExpertValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        long projectId = Long.parseLong(validatorData.getBillObj().getPkValue().toString());
        if (projectId == 0L) {
            return;
        }
        String entityName = validatorData.getBillObj().getDataEntityType().getName();
        String cfgEntityName = "src_aptitudeconfigf7";
        if ("src_aptitudeaudit2".equals(entityName)) {
            cfgEntityName = "src_aptitudeconfig2f7";
        }
        QFilter cfgfilter = new QFilter("billid", "=", (Object)projectId).and("expertcount", ">", (Object)0L);
        String seleltFields = DynamicObjectUtil.getSelectfields((String)cfgEntityName, (boolean)false);
        DynamicObject[] cfgRows = BusinessDataServiceHelper.load((String)cfgEntityName, (String)seleltFields, (QFilter[])cfgfilter.toArray());
        if (cfgRows == null || cfgRows.length == 0) {
            return;
        }
        Set cfgEntryIds = Arrays.asList(cfgRows).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter signfilter = new QFilter("project.id", "=", (Object)projectId).and("srcentryid", "in", cfgEntryIds).and("issignin", "=", (Object)"1");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"srcentryid", (QFilter[])signfilter.toArray());
        Map<String, List<DynamicObject>> signMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("srcentryid")));
        Set selectPackageIds = SrcBidOpenFacade.getSelectPackageIds((long)projectId, (String)entityName);
        StringBuilder message = new StringBuilder();
        for (DynamicObject cfgRow : cfgRows) {
            int expertNum;
            long packageId = cfgRow.getLong("package.id");
            if (!selectPackageIds.contains(packageId)) continue;
            String key = cfgRow.getString("id");
            List<DynamicObject> signList = signMap.get(key);
            int n = expertNum = signList == null ? 0 : signList.size();
            if (expertNum >= cfgRow.getInt("expertcount")) continue;
            String note = SrcClarifyUtils.getScorerNote((DynamicObject)cfgRow);
            if (message.length() == 0) {
                message.append(ResManager.loadKDString((String)"\u8d44\u5ba1\u8bc4\u59d4\u7b7e\u5230\u4eba\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u4e0d\u80fd\u5f00\u6807\u3002\n", (String)"SrcAptOpenExpertValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]));
            }
            message.append(String.format(ResManager.loadKDString((String)"%1$s\u8bc4\u59d4\u7b7e\u5230\u4eba\u6570(%2$s), \u4e0d\u7b26\u5408\u8981\u6c42(%3$s)%4$s\u3002", (String)"SrcAptOpenExpertValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), note, expertNum, cfgRow.getInt("expertcount"), "\n"));
        }
        if (!StringUtils.isBlank((String)message.toString())) {
            validatorData.setSucced(false);
            validatorData.setMessage(message.toString());
        }
    }
}

