/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcBidAssesTecOpenValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        String scorerName;
        DynamicObject billObj = context.getBillObj();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        if (this.isExistsNotTecOpen(projectId)) {
            this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u8fd8\u6709\u672a\u5f00\u6807\u7684\u6807\u6bb5\uff0c\u8bf7\u5168\u90e8\u5f00\u6807\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcBidAssesTecOpenValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        if (SrcBidCompTplUtil.hasNode((DynamicObject)billObj, (String)"src_scorertask")) {
            return;
        }
        if (this.isExistsNotTecAccess(projectId) && StringUtils.isNotEmpty((String)(scorerName = SrcBidAssessUtils.getUnFinishScorer((long)projectId, (Set)PdsCommonUtils.buildSet((String[])new String[]{"1", "3"}))))) {
            this.getUnSuccedResult(context, String.format(ResManager.loadKDString((String)"%1$s\u8bc4\u6807\u4e2d\uff0c\u8bf7\u5168\u90e8\u8bc4\u6807\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcBidAssesTecOpenValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), scorerName));
        }
    }

    private boolean isExistsNotTecOpen(long projectId) {
        QFilter filters = new QFilter("billid", "=", (Object)projectId);
        filters = filters.and("istecopen", "=", (Object)Character.valueOf('0'));
        return QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])filters.toArray());
    }

    private boolean isExistsNotTecAccess(long projectId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("istecassess", "=", (Object)Character.valueOf('0'));
        qfilter.and("id", "in", (Object)SrcPurListUtil.getValidPackageIds((long)projectId));
        return QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])qfilter.toArray());
    }
}

