/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcBidCompTplUnAuditValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject nextNode;
            DynamicObject data = dataEntity.getDataEntity();
            String sourceType = data.getString("sourcetype.number");
            if (Objects.equals("src_project", data.getDataEntityType().getName()) && Objects.equals(SourceTypeEnums.INPUT_PRICE.getValue(), sourceType) || !SrcBidCompTplUtil.isNeedAudit((DynamicObject)data)) continue;
            DynamicObject handledNode = SrcBidCompTplUtil.getHandledChildrenNode((DynamicObject)data);
            if (null != handledNode) {
                String entityKey = this.getNodeName(handledNode);
                boolean isQuickFlow = false;
                if (SourceTypeEnums.INPUT_PRICE.getValue().equals(sourceType) || SourceTypeEnums.DIRECT_PUR.getValue().equals(sourceType) || SourceTypeEnums.INTERNAL_SALE.getValue().equals(sourceType) || SourceTypeEnums.NET_PUR.getValue().equals(sourceType)) {
                    isQuickFlow = true;
                }
                boolean isValid = true;
                if (isQuickFlow && "src_contract".equals(entityKey)) {
                    isValid = false;
                }
                if (isValid) {
                    MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityKey);
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5ba1\u6838\u7684\u2018%1$s\u2019\u8282\u70b9\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"SrcBidCompTplUnAuditValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), type.getDisplayName()));
                    return;
                }
            }
            if (!Objects.nonNull(nextNode = SrcBidCompTplUtil.getCurrNextNode((DynamicObject)data))) continue;
            String entityName = this.getNodeName(nextNode);
            QFilter qFilter = new QFilter("id", "=", data.getPkValue());
            qFilter.and("billstatus", "=", (Object)SrcProjectEnum.SUBMIT.getCode());
            boolean isExist = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{qFilter});
            if (!isExist) continue;
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityName);
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u63d0\u4ea4\u7684\u2018%1$s\u2019\u8282\u70b9\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"SrcBidCompTplUnAuditValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), type.getDisplayName()));
        }
    }

    private String getNodeName(DynamicObject handledNode) {
        String nodeKey = handledNode.getDataEntityType() instanceof SubEntryType ? handledNode.getString("subbizobject") : handledNode.getString("bizobject");
        return nodeKey;
    }
}

