/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcBidOpenCfgPercentageValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        long sourceFlowId = context.getBillObj().getLong("projectf7.srctype.id");
        boolean isManualScoreTask = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"ismanualscoretask", (Object)false, (long)context.getBillObj().getLong("projectf7.id")));
        Set sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.BID.getValue(), SourceTypeEnums.BID2.getValue(), SourceTypeEnums.BID3.getValue(), SourceTypeEnums.BID4.getValue()});
        if (isManualScoreTask || sourceTypeSet.contains(billObj.getString("sourcetype.number"))) {
            BigDecimal tecPercent = billObj.getBigDecimal("ratio_tec");
            if (tecPercent.compareTo(BigDecimal.ZERO) == 0) {
                // empty if block
            }
            BigDecimal bizPercent = billObj.getBigDecimal("ratio_biz");
            BigDecimal othPercent = billObj.getBigDecimal("ratio_oth");
            BigDecimal synPercent = billObj.getBigDecimal("ratio_syn");
            BigDecimal all = BigDecimal.ZERO;
            all = billObj.getBoolean("isbyproject") ? synPercent : tecPercent.add(bizPercent).add(othPercent).add(synPercent);
            BigDecimal hundred = new BigDecimal("100");
            StringBuilder sb = new StringBuilder();
            if (hundred.compareTo(all) != 0) {
                Object isratio_othObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isratio_oth");
                if (Objects.nonNull(isratio_othObj) && ((Boolean)isratio_othObj).booleanValue()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u6280\u672f+\u5546\u52a1+\u5546\u52a1\u7efc\u5408\u5360\u6bd4\u7684\u603b\u548c\u5fc5\u987b\u4e3a100%1$s\u3002", (String)"SrcBidOpenCfgPercentageValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), "%\u3002")).append("\n");
                } else {
                    sb.append(String.format(ResManager.loadKDString((String)"\u6280\u672f+\u5546\u52a1\u5360\u6bd4\u7684\u603b\u548c\u5fc5\u987b\u4e3a100%1$s\u3002", (String)"SrcBidOpenCfgPercentageValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), "%\u3002")).append("\n");
                }
            }
            BigDecimal zero = new BigDecimal("0");
            boolean isAllOpen = this.isAllOpen(billObj);
            if (isAllOpen && !billObj.getBoolean("isbyproject") && (tecPercent.compareTo(zero) == 0 || bizPercent.compareTo(zero) == 0)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u5f00\u6807\u65b9\u5f0f\u4e3a\u201c\u5148\u5f00\u6280\u672f\u6807\uff0c\u540e\u5f00\u5546\u52a1\u6807\u201d\u6216\u201c\u5e76\u884c\u5f00\u6280\u672f\u6807\u548c\u5546\u52a1\u6807\u201d\uff0c\u6280\u672f\u4e0e\u5546\u52a1\u7684\u5360\u6bd4\u5fc5\u987b\u5927\u4e8e0%1$s\u3002", (String)"SrcBidOpenCfgPercentageValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), "%\u3002"));
            }
            context.setMessage(sb.toString());
            context.setSucced(false);
        }
    }

    private boolean isAllOpen(DynamicObject billObj) {
        String openType = billObj.getString("opentype");
        return "2".equals(openType) || "4".equals(openType);
    }
}

