/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcCompareCfgValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        Set sourceTypeSet;
        DynamicObject cfgObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getPkValue(), (String)"src_compare_config");
        if ("C010906".equals(cfgObj.getString("winrule.number"))) {
            return;
        }
        if ("4".equals(cfgObj.getString("ruleassess"))) {
            return;
        }
        DynamicObject sourcetype = cfgObj.getDynamicObject("sourcetype");
        String sourcetypeNum = "";
        if (sourcetype != null) {
            sourcetypeNum = sourcetype.getString("number");
        }
        if ((sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.NEGOTIATE_SOLE.getValue(), SourceTypeEnums.NEGOTIATE_SOLE2.getValue()})).contains(sourcetypeNum)) {
            return;
        }
        if (!cfgObj.getBoolean("ispkgscheme")) {
            if (cfgObj.getDynamicObject("scheme") == null) {
                context.setSucced(false);
            }
        } else {
            HashMap<String, String> pkgSchemeMap = new HashMap<String, String>();
            DynamicObjectCollection rows = cfgObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                pkgSchemeMap.put(row.getString("package.id"), row.getString("pkgscheme.id"));
            }
            DynamicObjectCollection pkgRows = QueryServiceHelper.query((String)"src_packagef7", (String)"id,packagename", (QFilter[])new QFilter[]{new QFilter("project", "=", (Object)Long.parseLong(context.getBillObj().getPkValue().toString()))});
            StringBuilder sb = new StringBuilder();
            for (DynamicObject pkgRow : pkgRows) {
                if (pkgSchemeMap.get(pkgRow.getString("id")) != null) continue;
                if (sb.length() > 0) {
                    sb = sb.append(';').append(pkgRow.getString("packagename"));
                    continue;
                }
                sb = sb.append(pkgRow.getString("packagename"));
            }
            if (sb != null && sb.length() > 0) {
                this.getUnSuccedResult(context, String.format(ResManager.loadKDString((String)"\u8fd9\u4e9b\u6807\u6bb5\u672a\u8bbe\u7f6e\u6bd4\u4ef7\u65b9\u6848\uff1a %1$s\u3002", (String)"SrcCompareCfgValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), sb) + "\n");
            }
        }
    }
}

