/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcDecisionWinSupplierValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        this.verifyAmountOrRatio(context);
    }

    protected void verifyAmountOrRatio(SrcValidatorData context) {
        String pentitykey = context.getBillObj().getString("pentitykey");
        if (!Objects.equals(pentitykey, "src_decision")) {
            return;
        }
        String sourceType = context.getBillObj().getString("projectf7.sourcetype.number");
        Set sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.SCHEME_AWARD.getValue(), SourceTypeEnums.SCHEME_AWARD2.getValue()});
        if (sourceTypeSet.contains(sourceType)) {
            return;
        }
        DynamicObjectCollection entryRows = context.getBillObj().getDynamicObjectCollection("entryentity");
        StringBuilder message = new StringBuilder();
        if (!entryRows.stream().anyMatch(e -> e.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0 || e.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) > 0 || e.getBigDecimal("orderratio").compareTo(BigDecimal.ZERO) > 0 || e.getBigDecimal("orderratio1").compareTo(BigDecimal.ZERO) > 0)) {
            message.append(ResManager.loadKDString((String)"\u4e2d\u6807\u672a\u7a0e\u91d1\u989d\u3001\u4e2d\u6807\u672a\u7a0e\u5360\u6bd4\u3001\u4e2d\u6807\u542b\u7a0e\u91d1\u989d\u3001\u4e2d\u6807\u542b\u7a0e\u5360\u6bd4\u5747\u4e3a0\uff0c\u8bf7\u7efc\u5408\u8ba1\u7b97\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcDecisionWinSupplierValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
        }
        if (message.length() > 0) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }
}

