/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcNegotiateSubmitDeadlineValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        DynamicObject negBillObj = validatorData.getBillObj();
        String negotiateType = negBillObj.getString("negotiatetype");
        String opentype = negBillObj.getString("opentype");
        if (Objects.equals(SrcNegotiatetypeEnums.ONLINE.getValue(), negotiateType) || Objects.equals("3", opentype)) {
            Date deadline = negBillObj.getDate("deadline");
            if (null == deadline) {
                validatorData.setMessage(ResManager.loadKDString((String)"\u7ebf\u4e0a\u8bae\u4ef7\u6216\u81ea\u52a8\u5f00\u6807\uff0c\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcNegotiateSubmitDeadlineValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]));
                validatorData.setSucced(false);
                return;
            }
            if (TimeServiceHelper.now().after(deadline)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String message = String.format(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4(%1$s)\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\u3002", (String)"SrcNegotiateSubmitDeadlineValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(deadline), sdf.format(TimeServiceHelper.now()));
                validatorData.setMessage(message);
                validatorData.setSucced(false);
            }
        }
    }
}

