/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlFacade;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcProjectManValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        if (null == validatorData.getBillObj()) {
            return;
        }
        PdsOpenControlContext context = PdsOpenControlFacade.isNeedOpenCtlValidate((DynamicObject)validatorData.getBillObj(), null);
        if (!context.isNeedOpenCtlValidate()) {
            return;
        }
        Map bizRoleMap = PdsOpenControlUtils.getBizRoleMap((ExtPluginContext)context);
        StringBuilder sb = new StringBuilder();
        String aptMsg = ResManager.loadKDString((String)"\u5f00\u8d44\u5ba1\u6807", (String)"SrcProjectManValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]);
        String tecMsg = ResManager.loadKDString((String)"\u5f00\u6807/\u5f00\u6280\u672f\u6807", (String)"SrcProjectManValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]);
        String bizMsg = ResManager.loadKDString((String)"\u5f00\u8d44\u5ba1\u6807", (String)"SrcProjectManValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]);
        sb.append((CharSequence)this.verifyRoleNum(aptMsg, bizRoleMap, context.getAptSchemeObj()));
        sb.append((CharSequence)this.verifyRoleNum(tecMsg, bizRoleMap, context.getTecSchemeObj()));
        sb.append((CharSequence)this.verifyRoleNum(bizMsg, bizRoleMap, context.getBizSchemeObj()));
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            validatorData.setSucced(false);
            String str = sb.toString();
            if (str.endsWith("\n")) {
                str = str.substring(0, str.length() - 1);
            }
            validatorData.setMessage(str);
        }
    }

    private StringBuilder verifyRoleNum(String type, Map<Long, List<DynamicObject>> bizRoleMap, DynamicObject schemeObj) {
        StringBuilder sb = new StringBuilder();
        if (null != schemeObj) {
            StringBuilder sb1 = this.verifyRoleNum(ResManager.loadKDString((String)"\u53c2\u4e0e\u52a0\u5bc6", (String)"SrcProjectManValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), bizRoleMap, MultiBasedataUtils.getBasedataIdSet((DynamicObject)schemeObj, (String)"encryptrole"), schemeObj.getInt("encryptnum"));
            StringBuilder sb2 = this.verifyRoleNum(ResManager.loadKDString((String)"\u53c2\u4e0e\u5f00\u6807", (String)"SrcProjectManValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]), bizRoleMap, MultiBasedataUtils.getBasedataIdSet((DynamicObject)schemeObj, (String)"openrole"), schemeObj.getInt("opennum"));
            if (sb1.length() > 0) {
                sb.append(type).append((CharSequence)sb1).append('\n');
            }
            if (sb2.length() > 0) {
                sb.append(type).append((CharSequence)sb2).append('\n');
            }
        }
        return sb;
    }

    private StringBuilder verifyRoleNum(String title, Map<Long, List<DynamicObject>> bizRoleMap, Set<Long> roleIds, int requestNum) {
        ArrayList<DynamicObject> memberList = new ArrayList<DynamicObject>();
        for (long roleId : roleIds) {
            List<DynamicObject> roleList = bizRoleMap.get(roleId);
            if (null == roleList || roleList.size() <= 0) continue;
            memberList.addAll(roleList);
        }
        long realNum = 0L;
        if (memberList.size() > 0) {
            realNum = memberList.stream().map(e -> e.getLong("bidder.id")).distinct().count();
        }
        StringBuilder sb = new StringBuilder();
        if (realNum < (long)requestNum) {
            sb.append(title).append(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u6210\u5458\u4eba\u6570(%1$s), \u4e0d\u7b26\u5408\u6700\u4f4e\u4eba\u6570\u8981\u6c42(%2$s)\u3002", (String)"SrcProjectManValidator_5", (String)"scm-src-opplugin", (Object[])new Object[0]), realNum, requestNum));
        }
        return sb;
    }
}

