/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.util.SrcAppCache;

public class SrcPurlistRankByBaseValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        IFormView parentView = context.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (!Objects.equals(entityId, "src_project") && !Objects.equals(entityId, "src_purlist")) {
            return;
        }
        String winrulePageid = (String)SrcAppCache.get((String)"winrulepageid", String.class, (IFormView)parentView);
        if (StringUtils.isEmpty((CharSequence)winrulePageid) && StringUtils.isEmpty((CharSequence)(winrulePageid = (String)SrcAppCache.get((String)"winrulepageid", String.class, (IFormView)parentView.getParentView())))) {
            return;
        }
        IFormView winruleView = context.getView().getView(winrulePageid);
        if (Objects.isNull(winruleView)) {
            return;
        }
        String rankType = winruleView.getModel().getDataEntity().getString("scheme.ranktype");
        if (StringUtils.isBlank((CharSequence)rankType) || !rankType.equals("5")) {
            return;
        }
        String basePageId = (String)SrcAppCache.get((String)"baseinfopageid", String.class, (IFormView)parentView);
        if (StringUtils.isEmpty((CharSequence)basePageId) && StringUtils.isEmpty((CharSequence)(basePageId = (String)SrcAppCache.get((String)"baseinfopageid", String.class, (IFormView)parentView.getParentView())))) {
            return;
        }
        IFormView baseView = context.getView().getView(basePageId);
        if (Objects.isNull(baseView)) {
            return;
        }
        String taxType = baseView.getModel().getDataEntity().getString("taxtype");
        String decisionType = baseView.getModel().getDataEntity().getString("decisiontype");
        Map maxPriceFieldMap = PdsVieHelper.getMaxPriceField((String)decisionType, (String)taxType);
        String maxPriceField = (String)maxPriceFieldMap.get("fieldid");
        String fieldName = (String)maxPriceFieldMap.get("fieldname");
        DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            int i = 1;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject row : rows) {
                if (row.getBigDecimal(maxPriceField).compareTo(BigDecimal.ZERO) <= 0) {
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c,\u6392\u540d\u65b9\u5f0f\u6309\u57fa\u51c6\u503c\u65f6\uff0c{1} \u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrcPurlistRankByBaseValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), i, fieldName));
                    sb.append('\n');
                }
                ++i;
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                context.setSucced(false);
                context.setMessage(sb.toString());
            }
        }
    }
}

